/*
 * Decompiled with CFR 0.152.
 */
package com.rws.lt.lc.publicapi.sdk.client;

import com.rws.lt.lc.publicapi.sdk.api.AccountApi;
import com.rws.lt.lc.publicapi.sdk.api.ConnectedAiApi;
import com.rws.lt.lc.publicapi.sdk.api.CustomFieldApi;
import com.rws.lt.lc.publicapi.sdk.api.CustomerApi;
import com.rws.lt.lc.publicapi.sdk.api.FileApi;
import com.rws.lt.lc.publicapi.sdk.api.FileProcessingConfigurationApi;
import com.rws.lt.lc.publicapi.sdk.api.FolderApi;
import com.rws.lt.lc.publicapi.sdk.api.GroupApi;
import com.rws.lt.lc.publicapi.sdk.api.IntegrationApi;
import com.rws.lt.lc.publicapi.sdk.api.LanguageApi;
import com.rws.lt.lc.publicapi.sdk.api.LanguageProcessingApi;
import com.rws.lt.lc.publicapi.sdk.api.MachineTranslationApi;
import com.rws.lt.lc.publicapi.sdk.api.PerfectMatchMappingApi;
import com.rws.lt.lc.publicapi.sdk.api.PricingModelApi;
import com.rws.lt.lc.publicapi.sdk.api.ProjectApi;
import com.rws.lt.lc.publicapi.sdk.api.ProjectGroupApi;
import com.rws.lt.lc.publicapi.sdk.api.ProjectTemplateApi;
import com.rws.lt.lc.publicapi.sdk.api.QuoteApi;
import com.rws.lt.lc.publicapi.sdk.api.RateLimitsApi;
import com.rws.lt.lc.publicapi.sdk.api.ScheduleTemplateApi;
import com.rws.lt.lc.publicapi.sdk.api.SourceFileApi;
import com.rws.lt.lc.publicapi.sdk.api.TargetFileApi;
import com.rws.lt.lc.publicapi.sdk.api.TaskApi;
import com.rws.lt.lc.publicapi.sdk.api.TaskTypeApi;
import com.rws.lt.lc.publicapi.sdk.api.TermbaseApi;
import com.rws.lt.lc.publicapi.sdk.api.TermbaseExportApi;
import com.rws.lt.lc.publicapi.sdk.api.TermbaseImportApi;
import com.rws.lt.lc.publicapi.sdk.api.TermbaseTemplateApi;
import com.rws.lt.lc.publicapi.sdk.api.TqaProfileApi;
import com.rws.lt.lc.publicapi.sdk.api.TranslationDomainApi;
import com.rws.lt.lc.publicapi.sdk.api.TranslationEngineApi;
import com.rws.lt.lc.publicapi.sdk.api.TranslationMemoryApi;
import com.rws.lt.lc.publicapi.sdk.api.TranslationMemoryExportApi;
import com.rws.lt.lc.publicapi.sdk.api.TranslationMemoryImportApi;
import com.rws.lt.lc.publicapi.sdk.api.UserApi;
import com.rws.lt.lc.publicapi.sdk.api.WorkflowApi;
import com.rws.lt.lc.publicapi.sdk.auth.ServiceAuthenticationHandler;
import com.rws.lt.lc.publicapi.sdk.auth.ServiceCredentials;
import com.rws.lt.lc.publicapi.sdk.exception.CustomErrorDecoder;
import com.rws.lt.lc.publicapi.sdk.invoker.ApiClient;
import com.rws.lt.lc.publicapi.sdk.region.RegionDiscoverer;
import feign.RequestInterceptor;
import feign.codec.ErrorDecoder;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nullable;
import lombok.Generated;

public class LanguageCloudClientProvider {
    AtomicInteger uniqueId = new AtomicInteger(0);
    private ApiClient apiClient;
    private RegionDiscoverer regionDiscoverer = new RegionDiscoverer();
    private final String DEFAULT_REGION = "eu";
    private static final String CONTEXT_ROOT = "/public-api/v1";
    private static final String PROTOCOL = "https://";

    private LanguageCloudClientProvider(@Nullable String regionCode, @Nullable String baseUrl, @Nullable ServiceCredentials serviceCredentials, @Nullable List<RequestInterceptor> requestInterceptors) {
        String basePath = Optional.ofNullable(baseUrl).orElseGet(() -> {
            String hostResolvedByRegion = this.regionDiscoverer.getRegionHostForRegionCode(Optional.ofNullable(regionCode).orElse("eu"));
            return PROTOCOL + hostResolvedByRegion + CONTEXT_ROOT;
        });
        this.apiClient = new ApiClient();
        this.apiClient.setBasePath(basePath);
        this.apiClient.getFeignBuilder().errorDecoder((ErrorDecoder)new CustomErrorDecoder());
        Optional.ofNullable(requestInterceptors).ifPresentOrElse(interceptors -> this.addAuthorization(this.apiClient, (List<RequestInterceptor>)interceptors), () -> this.addAuthorization(this.apiClient, List.of(new ServiceAuthenticationHandler(serviceCredentials))));
    }

    public static Builder builder() {
        return new Builder();
    }

    public AccountApi getAccountClient() {
        return this.apiClient.buildClient(AccountApi.class);
    }

    public CustomerApi getCustomerClient() {
        return this.apiClient.buildClient(CustomerApi.class);
    }

    public CustomFieldApi getCustomFieldClient() {
        return this.apiClient.buildClient(CustomFieldApi.class);
    }

    public FileProcessingConfigurationApi getFileProcessingConfigurationClient() {
        return this.apiClient.buildClient(FileProcessingConfigurationApi.class);
    }

    public FileApi getFileClient() {
        return this.apiClient.buildClient(FileApi.class);
    }

    public FolderApi getFolderClient() {
        return this.apiClient.buildClient(FolderApi.class);
    }

    public GroupApi getGroupClient() {
        return this.apiClient.buildClient(GroupApi.class);
    }

    public LanguageApi getLanguageClient() {
        return this.apiClient.buildClient(LanguageApi.class);
    }

    public PricingModelApi getPricingModelClient() {
        return this.apiClient.buildClient(PricingModelApi.class);
    }

    public ProjectApi getProjectClient() {
        return this.apiClient.buildClient(ProjectApi.class);
    }

    public ProjectTemplateApi getProjectTemplateClient() {
        return this.apiClient.buildClient(ProjectTemplateApi.class);
    }

    public QuoteApi getQuotesClient() {
        return this.apiClient.buildClient(QuoteApi.class);
    }

    public SourceFileApi getSourceFileClient() {
        return this.apiClient.buildClient(SourceFileApi.class);
    }

    public TargetFileApi getTargetFileClient() {
        return this.apiClient.buildClient(TargetFileApi.class);
    }

    public TaskApi getTaskClient() {
        return this.apiClient.buildClient(TaskApi.class);
    }

    public TaskTypeApi getTaskTypeClient() {
        return this.apiClient.buildClient(TaskTypeApi.class);
    }

    public TqaProfileApi getTqaProfileClient() {
        return this.apiClient.buildClient(TqaProfileApi.class);
    }

    public TranslationEngineApi getTranslationEngineClient() {
        return this.apiClient.buildClient(TranslationEngineApi.class);
    }

    public UserApi getUserClient() {
        return this.apiClient.buildClient(UserApi.class);
    }

    public WorkflowApi getWorkflowClient() {
        return this.apiClient.buildClient(WorkflowApi.class);
    }

    public TermbaseApi getTermbaseClient() {
        return this.apiClient.buildClient(TermbaseApi.class);
    }

    public TermbaseTemplateApi getTermbaseTemplateClient() {
        return this.apiClient.buildClient(TermbaseTemplateApi.class);
    }

    public TermbaseImportApi getTermbaseImportClient() {
        return this.apiClient.buildClient(TermbaseImportApi.class);
    }

    public TermbaseExportApi getTermbaseExportClient() {
        return this.apiClient.buildClient(TermbaseExportApi.class);
    }

    public LanguageProcessingApi getLanguageProcessingClient() {
        return this.apiClient.buildClient(LanguageProcessingApi.class);
    }

    public TranslationMemoryApi getTranslationMemoryClient() {
        return this.apiClient.buildClient(TranslationMemoryApi.class);
    }

    public TranslationMemoryImportApi getTranslationMemoryImportClient() {
        return this.apiClient.buildClient(TranslationMemoryImportApi.class);
    }

    public TranslationMemoryExportApi getTranslationMemoryExportClient() {
        return this.apiClient.buildClient(TranslationMemoryExportApi.class);
    }

    public ProjectGroupApi getProjectGroupClient() {
        return this.apiClient.buildClient(ProjectGroupApi.class);
    }

    public RateLimitsApi getRateLimitsClient() {
        return this.apiClient.buildClient(RateLimitsApi.class);
    }

    public MachineTranslationApi getMachineTranslationClient() {
        return this.apiClient.buildClient(MachineTranslationApi.class);
    }

    public ScheduleTemplateApi getScheduleTemplateClient() {
        return this.apiClient.buildClient(ScheduleTemplateApi.class);
    }

    public PerfectMatchMappingApi getPerfectMatchMappingClient() {
        return this.apiClient.buildClient(PerfectMatchMappingApi.class);
    }

    public ConnectedAiApi getConnectedAiClient() {
        return this.apiClient.buildClient(ConnectedAiApi.class);
    }

    public TranslationDomainApi getTranslationDomainClient() {
        return this.apiClient.buildClient(TranslationDomainApi.class);
    }

    public IntegrationApi getIntegrationClient() {
        return this.apiClient.buildClient(IntegrationApi.class);
    }

    private void addAuthorization(ApiClient apiClient, List<RequestInterceptor> requestInterceptors) {
        requestInterceptors.forEach(requestInterceptor -> apiClient.addAuthorization("authorization" + this.uniqueId.incrementAndGet(), (RequestInterceptor)requestInterceptor));
    }

    @Generated
    public void setUniqueId(AtomicInteger uniqueId) {
        this.uniqueId = uniqueId;
    }

    @Generated
    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    @Generated
    public void setRegionDiscoverer(RegionDiscoverer regionDiscoverer) {
        this.regionDiscoverer = regionDiscoverer;
    }

    public static class Builder {
        private String regionCode;
        private String baseUrl;
        private ServiceCredentials serviceCredentials;
        private List<RequestInterceptor> requestInterceptors;

        public Builder withRegionCode(String regionCode) {
            this.regionCode = regionCode;
            return this;
        }

        public Builder withBaseUrl(String baseUrl) {
            this.baseUrl = baseUrl;
            return this;
        }

        public Builder withServiceCredentials(ServiceCredentials serviceCredentials) {
            this.serviceCredentials = serviceCredentials;
            return this;
        }

        public Builder withRequestInterceptors(List<RequestInterceptor> requestInterceptors) {
            this.requestInterceptors = requestInterceptors;
            return this;
        }

        public LanguageCloudClientProvider build() {
            return new LanguageCloudClientProvider(this.regionCode, this.baseUrl, this.serviceCredentials, this.requestInterceptors);
        }
    }
}

