/*
 * Decompiled with CFR 0.152.
 */
package com.rws.lt.lc.publicapi.sdk.auth;

import com.rws.lt.lc.publicapi.sdk.auth.AuthenticationService;
import com.rws.lt.lc.publicapi.sdk.auth.ServiceCredentials;
import com.rws.lt.lc.publicapi.sdk.context.LCContext;
import com.rws.lt.lc.publicapi.sdk.exception.ApiUnauthorizedException;
import feign.Request;
import feign.RequestInterceptor;
import feign.RequestTemplate;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;

public class ServiceAuthenticationHandler
implements RequestInterceptor {
    private static final String FAILED_TO_AUTHENTICATE = "Failed to authenticate.";
    private final ServiceCredentials serviceCredentials;
    private final AuthenticationService authenticationService;

    public ServiceAuthenticationHandler(@Nullable ServiceCredentials serviceCredentials) {
        this.serviceCredentials = serviceCredentials;
        this.authenticationService = AuthenticationService.getInstance();
    }

    public void apply(RequestTemplate requestTemplate) {
        Optional<String> oToken = this.resolveToken(this.serviceCredentials);
        Optional<String> oTenant = this.resolveTenant(this.serviceCredentials);
        if (oToken.isEmpty() || oTenant.isEmpty()) {
            throw new ApiUnauthorizedException(requestTemplate.url(), Request.HttpMethod.valueOf((String)requestTemplate.method()), 401, FAILED_TO_AUTHENTICATE);
        }
        String traceId = ServiceAuthenticationHandler.resolveTraceId();
        requestTemplate.header("Authorization", new String[]{"Bearer " + oToken.get()});
        oTenant.ifPresent(tenant -> requestTemplate.header("X-LC-Tenant", new String[]{tenant}));
        requestTemplate.header("TR_ID", new String[]{traceId});
    }

    private Optional<String> resolveToken(ServiceCredentials serviceCredentials) {
        ServiceCredentials contextCredentials = (ServiceCredentials)LCContext.getFromLCContext("serviceCredentials");
        return Optional.ofNullable(contextCredentials).or(() -> Optional.ofNullable(serviceCredentials)).map(this.authenticationService::getToken);
    }

    private Optional<String> resolveTenant(ServiceCredentials serviceCredentials) {
        String tenantId = (String)LCContext.getFromLCContext("tenantId");
        return Optional.ofNullable(tenantId).or(() -> Optional.ofNullable(serviceCredentials).map(ServiceCredentials::getTenantId));
    }

    private static String resolveTraceId() {
        return Optional.ofNullable(LCContext.getFromLCContext("traceId")).orElse(UUID.randomUUID()).toString();
    }
}

