/*
 * Decompiled with CFR 0.152.
 */
package com.rws.lt.lc.publicapi.sdk.auth;

import com.rws.lt.lc.publicapi.sdk.auth.AuthenticationService;
import com.rws.lt.lc.publicapi.sdk.auth.ServiceCredentials;
import com.rws.lt.lc.publicapi.sdk.context.LCContext;
import com.rws.lt.lc.publicapi.sdk.exception.ApiUnauthorizedException;
import com.rws.lt.lc.publicapi.sdk.exception.MissingCredentialsException;
import feign.Request;
import feign.RequestInterceptor;
import feign.RequestTemplate;
import java.util.UUID;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;

public abstract class CustomServiceAuthenticationHandler
implements RequestInterceptor {
    private static final String FAILED_TO_AUTHENTICATE = "Failed to authenticate.";
    private final AuthenticationService authenticationService;

    public CustomServiceAuthenticationHandler() {
        this.authenticationService = AuthenticationService.getInstance();
    }

    public CustomServiceAuthenticationHandler(AuthenticationService authenticationService) {
        this.authenticationService = authenticationService;
    }

    public void apply(RequestTemplate requestTemplate) throws MissingCredentialsException {
        ServiceCredentials serviceCredentials = this.getServiceCredentials();
        Object contextCredentials = LCContext.getFromLCContext("serviceCredentials");
        if (contextCredentials != null) {
            serviceCredentials = (ServiceCredentials)contextCredentials;
        }
        if (serviceCredentials == null) {
            throw new MissingCredentialsException("No credentials supplied.");
        }
        String token = this.authenticationService.getToken(serviceCredentials);
        String tenant = this.resolveTenantId(serviceCredentials);
        if (StringUtils.isBlank((CharSequence)token) || StringUtils.isBlank((CharSequence)tenant)) {
            throw new ApiUnauthorizedException(requestTemplate.url(), Request.HttpMethod.valueOf((String)requestTemplate.method()), 401, FAILED_TO_AUTHENTICATE);
        }
        String traceId = this.getTraceId();
        if (traceId == null) {
            traceId = UUID.randomUUID().toString();
        }
        if (LCContext.containsValueForKey("traceId").booleanValue()) {
            traceId = LCContext.getFromLCContext("traceId").toString();
        }
        requestTemplate.header("X-LC-Tenant", new String[]{tenant});
        requestTemplate.header("Authorization", new String[]{"Bearer " + token});
        requestTemplate.header("TR_ID", new String[]{traceId});
    }

    @Nullable
    protected String resolveTenantId(ServiceCredentials serviceCredentials) {
        String tenant = (String)LCContext.getFromLCContext("tenantId");
        if (StringUtils.isBlank((CharSequence)tenant)) {
            tenant = this.getTenantId();
        }
        if (StringUtils.isBlank((CharSequence)tenant)) {
            tenant = serviceCredentials.getTenantId();
        }
        return tenant;
    }

    public abstract ServiceCredentials getServiceCredentials();

    public abstract String getTraceId();

    public abstract String getTenantId();
}

