/*
 * Decompiled with CFR 0.152.
 */
package com.rws.lt.lc.publicapi.sdk.auth;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.rws.lt.lc.publicapi.sdk.auth.Auth0RequestModel;
import com.rws.lt.lc.publicapi.sdk.auth.Auth0ResponseModel;
import com.rws.lt.lc.publicapi.sdk.auth.AuthConstants;
import com.rws.lt.lc.publicapi.sdk.auth.ClientCredentials;
import com.rws.lt.lc.publicapi.sdk.auth.JwtToken;
import com.rws.lt.lc.publicapi.sdk.auth.ServiceCredentials;
import com.rws.lt.lc.publicapi.sdk.exception.ApiErrorException;
import com.rws.lt.lc.publicapi.sdk.exception.ApiErrorResponse;
import feign.Request;
import java.io.IOException;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.Calendar;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import lombok.Generated;

public class AuthenticationService {
    private static final AuthenticationService instance = new AuthenticationService();
    private static final String EMPTY_STRING = "";
    private final ObjectMapper objectMapper;
    private final ConcurrentMap<ClientCredentials, JwtToken> cachedTokens = new ConcurrentHashMap<ClientCredentials, JwtToken>();
    private final HttpClient httpClient;
    private final Object lock = new Object();
    private String grantType;
    private String audience;
    private String url;

    private AuthenticationService() {
        this.objectMapper = new ObjectMapper();
        this.httpClient = HttpClient.newHttpClient();
    }

    AuthenticationService(HttpClient httpClient) {
        this.objectMapper = new ObjectMapper();
        this.httpClient = httpClient;
    }

    public static AuthenticationService getInstance() {
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getToken(ServiceCredentials serviceCredentials) {
        if (serviceCredentials.getClientCredentials() == null) {
            return EMPTY_STRING;
        }
        JwtToken cachedToken = (JwtToken)this.cachedTokens.get(serviceCredentials.getClientCredentials());
        if (cachedToken != null && !cachedToken.isExpiring(60)) {
            return cachedToken.getData();
        }
        Object object = this.lock;
        synchronized (object) {
            Auth0ResponseModel auth0LoginResponse = this.login_clientIdClientSecret(serviceCredentials);
            if (auth0LoginResponse.getAccess_token() != null) {
                JwtToken parsedToken = this.parseJwtToken(auth0LoginResponse.getAccess_token(), auth0LoginResponse.getExpires_in());
                this.cachedTokens.compute(serviceCredentials.getClientCredentials(), (k, v) -> parsedToken);
                return parsedToken.getData();
            }
        }
        return EMPTY_STRING;
    }

    private JwtToken parseJwtToken(String token, int expiresIn) {
        Calendar expiryTime = Calendar.getInstance();
        expiryTime.add(13, expiresIn);
        return new JwtToken(token, expiryTime.toInstant());
    }

    private Auth0ResponseModel login_clientIdClientSecret(ServiceCredentials serviceCredentials) {
        Auth0ResponseModel auth0ResponseModel;
        if (this.grantType == null || this.audience == null || this.url == null) {
            this.grantType = "client_credentials";
            this.audience = AuthConstants.CLIENT_CREDENTIALS_AUDIENCE;
            this.url = AuthConstants.CLIENT_CREDENTIALS_AUTH0_URL;
        }
        Auth0RequestModel auth0RequestModel = new Auth0RequestModel(serviceCredentials.getClientId(), serviceCredentials.getClientSecret(), this.grantType, this.audience);
        try {
            String requestBody = this.objectMapper.writeValueAsString((Object)auth0RequestModel);
            HttpRequest request = HttpRequest.newBuilder().header("Content-Type", "application/json").uri(URI.create(this.url)).POST(HttpRequest.BodyPublishers.ofString(requestBody)).build();
            HttpResponse<String> response = this.httpClient.send(request, HttpResponse.BodyHandlers.ofString());
            auth0ResponseModel = (Auth0ResponseModel)this.objectMapper.readValue(response.body(), Auth0ResponseModel.class);
        }
        catch (IOException | InterruptedException e) {
            throw new ApiErrorException(new ApiErrorResponse(), 500, this.url, Request.HttpMethod.POST, e.getMessage());
        }
        return auth0ResponseModel;
    }

    @Generated
    public void setGrantType(String grantType) {
        this.grantType = grantType;
    }

    @Generated
    public void setAudience(String audience) {
        this.audience = audience;
    }

    @Generated
    public void setUrl(String url) {
        this.url = url;
    }
}

