/*
 * Decompiled with CFR 0.152.
 */
package com.rws.lt.lc.publicapi.sdk.api;

import com.rws.lt.lc.publicapi.sdk.invoker.ApiClient;
import com.rws.lt.lc.publicapi.sdk.invoker.EncodingUtils;
import com.rws.lt.lc.publicapi.sdk.model.ApiResponse;
import com.rws.lt.lc.publicapi.sdk.model.ListTasksResponse;
import com.rws.lt.lc.publicapi.sdk.model.Task;
import com.rws.lt.lc.publicapi.sdk.model.TaskAssignRequest;
import com.rws.lt.lc.publicapi.sdk.model.TaskCompleteRequest;
import feign.Headers;
import feign.Param;
import feign.QueryMap;
import feign.RequestLine;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public interface TaskApi
extends ApiClient.Api {
    @RequestLine(value="PUT /tasks/{taskId}/accept")
    @Headers(value={"Accept: application/json"})
    public void acceptTask(@Param(value="taskId") @Nonnull String var1);

    @RequestLine(value="PUT /tasks/{taskId}/accept")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> acceptTaskWithHttpInfo(@Param(value="taskId") @Nonnull String var1);

    @RequestLine(value="PUT /tasks/{taskId}/assign")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public void assignTask(@Param(value="taskId") @Nonnull String var1, @Nonnull TaskAssignRequest var2);

    @RequestLine(value="PUT /tasks/{taskId}/assign")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<Void> assignTaskWithHttpInfo(@Param(value="taskId") @Nonnull String var1, @Nonnull TaskAssignRequest var2);

    @RequestLine(value="PUT /tasks/{taskId}/complete")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public void completeTask(@Param(value="taskId") @Nonnull String var1, @Nonnull TaskCompleteRequest var2);

    @RequestLine(value="PUT /tasks/{taskId}/complete")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<Void> completeTaskWithHttpInfo(@Param(value="taskId") @Nonnull String var1, @Nonnull TaskCompleteRequest var2);

    @RequestLine(value="GET /tasks/{taskId}?fields={fields}")
    @Headers(value={"Accept: application/json"})
    public Task getTask(@Param(value="taskId") @Nonnull String var1, @Param(value="fields") @Nullable String var2);

    @RequestLine(value="GET /tasks/{taskId}?fields={fields}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Task> getTaskWithHttpInfo(@Param(value="taskId") @Nonnull String var1, @Param(value="fields") @Nullable String var2);

    @RequestLine(value="GET /tasks/{taskId}?fields={fields}")
    @Headers(value={"Accept: application/json"})
    public Task getTask(@Param(value="taskId") @Nonnull String var1, @QueryMap(encoded=true) GetTaskQueryParams var2);

    @RequestLine(value="GET /tasks/{taskId}?fields={fields}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Task> getTaskWithHttpInfo(@Param(value="taskId") @Nonnull String var1, @QueryMap(encoded=true) GetTaskQueryParams var2);

    @RequestLine(value="GET /tasks/assigned?status={status}&top={top}&skip={skip}&location={location}&locationStrategy={locationStrategy}&sort={sort}&fields={fields}")
    @Headers(value={"Accept: application/json"})
    public ListTasksResponse listTasksAssignedToMe(@Param(value="status") @Nullable String var1, @Param(value="top") @Nullable Integer var2, @Param(value="skip") @Nullable Integer var3, @Param(value="location") @Nullable List<String> var4, @Param(value="locationStrategy") @Nullable String var5, @Param(value="sort") @Nullable String var6, @Param(value="fields") @Nullable String var7);

    @RequestLine(value="GET /tasks/assigned?status={status}&top={top}&skip={skip}&location={location}&locationStrategy={locationStrategy}&sort={sort}&fields={fields}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<ListTasksResponse> listTasksAssignedToMeWithHttpInfo(@Param(value="status") @Nullable String var1, @Param(value="top") @Nullable Integer var2, @Param(value="skip") @Nullable Integer var3, @Param(value="location") @Nullable List<String> var4, @Param(value="locationStrategy") @Nullable String var5, @Param(value="sort") @Nullable String var6, @Param(value="fields") @Nullable String var7);

    @RequestLine(value="GET /tasks/assigned?status={status}&top={top}&skip={skip}&location={location}&locationStrategy={locationStrategy}&sort={sort}&fields={fields}")
    @Headers(value={"Accept: application/json"})
    public ListTasksResponse listTasksAssignedToMe(@QueryMap(encoded=true) ListTasksAssignedToMeQueryParams var1);

    @RequestLine(value="GET /tasks/assigned?status={status}&top={top}&skip={skip}&location={location}&locationStrategy={locationStrategy}&sort={sort}&fields={fields}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<ListTasksResponse> listTasksAssignedToMeWithHttpInfo(@QueryMap(encoded=true) ListTasksAssignedToMeQueryParams var1);

    @RequestLine(value="PUT /tasks/{taskId}/reclaim")
    @Headers(value={"Accept: application/json"})
    public void reclaimTask(@Param(value="taskId") @Nonnull String var1);

    @RequestLine(value="PUT /tasks/{taskId}/reclaim")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> reclaimTaskWithHttpInfo(@Param(value="taskId") @Nonnull String var1);

    @RequestLine(value="PUT /tasks/{taskId}/reject")
    @Headers(value={"Accept: application/json"})
    public void rejectTask(@Param(value="taskId") @Nonnull String var1);

    @RequestLine(value="PUT /tasks/{taskId}/reject")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> rejectTaskWithHttpInfo(@Param(value="taskId") @Nonnull String var1);

    @RequestLine(value="PUT /tasks/{taskId}/release")
    @Headers(value={"Accept: application/json"})
    public void releaseTask(@Param(value="taskId") @Nonnull String var1);

    @RequestLine(value="PUT /tasks/{taskId}/release")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> releaseTaskWithHttpInfo(@Param(value="taskId") @Nonnull String var1);

    public static class ListTasksAssignedToMeQueryParams
    extends HashMap<String, Object> {
        public ListTasksAssignedToMeQueryParams status(@Nullable String value) {
            this.put("status", EncodingUtils.encode(value));
            return this;
        }

        public ListTasksAssignedToMeQueryParams top(@Nullable Integer value) {
            this.put("top", EncodingUtils.encode(value));
            return this;
        }

        public ListTasksAssignedToMeQueryParams skip(@Nullable Integer value) {
            this.put("skip", EncodingUtils.encode(value));
            return this;
        }

        public ListTasksAssignedToMeQueryParams location(@Nullable List<String> value) {
            this.put("location", EncodingUtils.encodeCollection(value, "csv"));
            return this;
        }

        public ListTasksAssignedToMeQueryParams locationStrategy(@Nullable String value) {
            this.put("locationStrategy", EncodingUtils.encode(value));
            return this;
        }

        public ListTasksAssignedToMeQueryParams sort(@Nullable String value) {
            this.put("sort", EncodingUtils.encode(value));
            return this;
        }

        public ListTasksAssignedToMeQueryParams fields(@Nullable String value) {
            this.put("fields", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class GetTaskQueryParams
    extends HashMap<String, Object> {
        public GetTaskQueryParams fields(@Nullable String value) {
            this.put("fields", EncodingUtils.encode(value));
            return this;
        }
    }
}

