/*
 * Decompiled with CFR 0.152.
 */
package com.rws.lt.lc.publicapi.sdk.api;

import com.rws.lt.lc.publicapi.sdk.invoker.ApiClient;
import com.rws.lt.lc.publicapi.sdk.invoker.EncodingUtils;
import com.rws.lt.lc.publicapi.sdk.model.ApiResponse;
import com.rws.lt.lc.publicapi.sdk.model.CustomFieldUpdateRequest;
import com.rws.lt.lc.publicapi.sdk.model.ListProjectsResponse;
import com.rws.lt.lc.publicapi.sdk.model.ListTasksResponse;
import com.rws.lt.lc.publicapi.sdk.model.Project;
import com.rws.lt.lc.publicapi.sdk.model.ProjectConfiguration;
import com.rws.lt.lc.publicapi.sdk.model.ProjectConfigurationRequest;
import com.rws.lt.lc.publicapi.sdk.model.ProjectCreateRequest;
import com.rws.lt.lc.publicapi.sdk.model.ProjectPricingModelUpdateRequest;
import com.rws.lt.lc.publicapi.sdk.model.ProjectUpdateRequest;
import com.rws.lt.lc.publicapi.sdk.model.RescheduleTasksRequest;
import com.rws.lt.lc.publicapi.sdk.model.ZipFileExportRequest;
import com.rws.lt.lc.publicapi.sdk.model.ZipFileExportResponse;
import com.rws.lt.lc.publicapi.sdk.multipart.FileResponse;
import feign.Headers;
import feign.Param;
import feign.QueryMap;
import feign.RequestLine;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.joda.time.DateTime;

public interface ProjectApi
extends ApiClient.Api {
    @RequestLine(value="PUT /projects/{projectId}/files/{fileId}/cancel")
    @Headers(value={"Accept: application/json"})
    public void cancelProjectFile(@Param(value="projectId") @Nonnull String var1, @Param(value="fileId") @Nonnull String var2);

    @RequestLine(value="PUT /projects/{projectId}/files/{fileId}/cancel")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> cancelProjectFileWithHttpInfo(@Param(value="projectId") @Nonnull String var1, @Param(value="fileId") @Nonnull String var2);

    @RequestLine(value="PUT /projects/{projectId}/complete")
    @Headers(value={"Accept: application/json"})
    public void completeProject(@Param(value="projectId") @Nonnull String var1);

    @RequestLine(value="PUT /projects/{projectId}/complete")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> completeProjectWithHttpInfo(@Param(value="projectId") @Nonnull String var1);

    @RequestLine(value="POST /projects?fields={fields}")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public Project createProject(@Nonnull ProjectCreateRequest var1, @Param(value="fields") @Nullable String var2);

    @RequestLine(value="POST /projects?fields={fields}")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<Project> createProjectWithHttpInfo(@Nonnull ProjectCreateRequest var1, @Param(value="fields") @Nullable String var2);

    @RequestLine(value="POST /projects?fields={fields}")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public Project createProject(@Nonnull ProjectCreateRequest var1, @QueryMap(encoded=true) CreateProjectQueryParams var2);

    @RequestLine(value="POST /projects?fields={fields}")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<Project> createProjectWithHttpInfo(@Nonnull ProjectCreateRequest var1, @QueryMap(encoded=true) CreateProjectQueryParams var2);

    @RequestLine(value="DELETE /projects/{projectId}")
    @Headers(value={"Accept: application/json"})
    public void deleteProject(@Param(value="projectId") @Nonnull String var1);

    @RequestLine(value="DELETE /projects/{projectId}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> deleteProjectWithHttpInfo(@Param(value="projectId") @Nonnull String var1);

    @RequestLine(value="GET /projects/{projectId}/files/exports/{exportId}/download")
    @Headers(value={"Accept: application/json,application/octet-stream"})
    public FileResponse downloadFile(@Param(value="projectId") @Nonnull String var1, @Param(value="exportId") @Nonnull String var2);

    @RequestLine(value="GET /projects/{projectId}/files/exports/{exportId}/download")
    @Headers(value={"Accept: application/json,application/octet-stream"})
    public ApiResponse<FileResponse> downloadFileWithHttpInfo(@Param(value="projectId") @Nonnull String var1, @Param(value="exportId") @Nonnull String var2);

    @RequestLine(value="POST /projects/{projectId}/files/exports")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ZipFileExportResponse exportProjectFiles(@Param(value="projectId") @Nonnull String var1, @Nullable ZipFileExportRequest var2);

    @RequestLine(value="POST /projects/{projectId}/files/exports")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<ZipFileExportResponse> exportProjectFilesWithHttpInfo(@Param(value="projectId") @Nonnull String var1, @Nullable ZipFileExportRequest var2);

    @RequestLine(value="GET /projects/{projectId}/files/exports/{exportId}")
    @Headers(value={"Accept: application/json"})
    public ZipFileExportResponse exportProjectFilesStatus(@Param(value="projectId") @Nonnull String var1, @Param(value="exportId") @Nonnull String var2);

    @RequestLine(value="GET /projects/{projectId}/files/exports/{exportId}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<ZipFileExportResponse> exportProjectFilesStatusWithHttpInfo(@Param(value="projectId") @Nonnull String var1, @Param(value="exportId") @Nonnull String var2);

    @RequestLine(value="GET /projects/{projectId}?fields={fields}")
    @Headers(value={"Accept: application/json"})
    public Project getProject(@Param(value="projectId") @Nonnull String var1, @Param(value="fields") @Nullable String var2);

    @RequestLine(value="GET /projects/{projectId}?fields={fields}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Project> getProjectWithHttpInfo(@Param(value="projectId") @Nonnull String var1, @Param(value="fields") @Nullable String var2);

    @RequestLine(value="GET /projects/{projectId}?fields={fields}")
    @Headers(value={"Accept: application/json"})
    public Project getProject(@Param(value="projectId") @Nonnull String var1, @QueryMap(encoded=true) GetProjectQueryParams var2);

    @RequestLine(value="GET /projects/{projectId}?fields={fields}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Project> getProjectWithHttpInfo(@Param(value="projectId") @Nonnull String var1, @QueryMap(encoded=true) GetProjectQueryParams var2);

    @RequestLine(value="GET /projects/{projectId}/configuration?fields={fields}")
    @Headers(value={"Accept: application/json"})
    public ProjectConfiguration getProjectConfiguration(@Param(value="projectId") @Nonnull String var1, @Param(value="fields") @Nullable String var2);

    @RequestLine(value="GET /projects/{projectId}/configuration?fields={fields}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<ProjectConfiguration> getProjectConfigurationWithHttpInfo(@Param(value="projectId") @Nonnull String var1, @Param(value="fields") @Nullable String var2);

    @RequestLine(value="GET /projects/{projectId}/configuration?fields={fields}")
    @Headers(value={"Accept: application/json"})
    public ProjectConfiguration getProjectConfiguration(@Param(value="projectId") @Nonnull String var1, @QueryMap(encoded=true) GetProjectConfigurationQueryParams var2);

    @RequestLine(value="GET /projects/{projectId}/configuration?fields={fields}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<ProjectConfiguration> getProjectConfigurationWithHttpInfo(@Param(value="projectId") @Nonnull String var1, @QueryMap(encoded=true) GetProjectConfigurationQueryParams var2);

    @RequestLine(value="GET /projects/{projectId}/tasks?top={top}&skip={skip}&location={location}&locationStrategy={locationStrategy}&sort={sort}&fields={fields}")
    @Headers(value={"Accept: application/json"})
    public ListTasksResponse listProjectTasks(@Param(value="projectId") @Nonnull String var1, @Param(value="top") @Nullable Integer var2, @Param(value="skip") @Nullable Integer var3, @Param(value="location") @Nullable List<String> var4, @Param(value="locationStrategy") @Nullable String var5, @Param(value="sort") @Nullable String var6, @Param(value="fields") @Nullable String var7);

    @RequestLine(value="GET /projects/{projectId}/tasks?top={top}&skip={skip}&location={location}&locationStrategy={locationStrategy}&sort={sort}&fields={fields}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<ListTasksResponse> listProjectTasksWithHttpInfo(@Param(value="projectId") @Nonnull String var1, @Param(value="top") @Nullable Integer var2, @Param(value="skip") @Nullable Integer var3, @Param(value="location") @Nullable List<String> var4, @Param(value="locationStrategy") @Nullable String var5, @Param(value="sort") @Nullable String var6, @Param(value="fields") @Nullable String var7);

    @RequestLine(value="GET /projects/{projectId}/tasks?top={top}&skip={skip}&location={location}&locationStrategy={locationStrategy}&sort={sort}&fields={fields}")
    @Headers(value={"Accept: application/json"})
    public ListTasksResponse listProjectTasks(@Param(value="projectId") @Nonnull String var1, @QueryMap(encoded=true) ListProjectTasksQueryParams var2);

    @RequestLine(value="GET /projects/{projectId}/tasks?top={top}&skip={skip}&location={location}&locationStrategy={locationStrategy}&sort={sort}&fields={fields}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<ListTasksResponse> listProjectTasksWithHttpInfo(@Param(value="projectId") @Nonnull String var1, @QueryMap(encoded=true) ListProjectTasksQueryParams var2);

    @RequestLine(value="GET /projects?top={top}&skip={skip}&location={location}&locationStrategy={locationStrategy}&sort={sort}&fields={fields}&excludeOnline={excludeOnline}&status={status}&createdFrom={createdFrom}&createdTo={createdTo}&createdBy={createdBy}&projectTemplateId={projectTemplateId}&projectIds={projectIds}&sourceLanguage={sourceLanguage}&targetLanguage={targetLanguage}&projectName={projectName}&dueFrom={dueFrom}&dueTo={dueTo}&lastModifiedFrom={lastModifiedFrom}&lastModifiedTo={lastModifiedTo}")
    @Headers(value={"Accept: application/json"})
    public ListProjectsResponse listProjects(@Param(value="top") @Nullable Integer var1, @Param(value="skip") @Nullable Integer var2, @Param(value="location") @Nullable List<String> var3, @Param(value="locationStrategy") @Nullable String var4, @Param(value="sort") @Nullable String var5, @Param(value="fields") @Nullable String var6, @Param(value="excludeOnline") @Nullable Boolean var7, @Param(value="status") @Nullable String var8, @Param(value="createdFrom") @Nullable DateTime var9, @Param(value="createdTo") @Nullable DateTime var10, @Param(value="createdBy") @Nullable String var11, @Param(value="projectTemplateId") @Nullable String var12, @Param(value="projectIds") @Nullable List<String> var13, @Param(value="sourceLanguage") @Nullable String var14, @Param(value="targetLanguage") @Nullable String var15, @Param(value="projectName") @Nullable String var16, @Param(value="dueFrom") @Nullable String var17, @Param(value="dueTo") @Nullable String var18, @Param(value="lastModifiedFrom") @Nullable String var19, @Param(value="lastModifiedTo") @Nullable String var20);

    @RequestLine(value="GET /projects?top={top}&skip={skip}&location={location}&locationStrategy={locationStrategy}&sort={sort}&fields={fields}&excludeOnline={excludeOnline}&status={status}&createdFrom={createdFrom}&createdTo={createdTo}&createdBy={createdBy}&projectTemplateId={projectTemplateId}&projectIds={projectIds}&sourceLanguage={sourceLanguage}&targetLanguage={targetLanguage}&projectName={projectName}&dueFrom={dueFrom}&dueTo={dueTo}&lastModifiedFrom={lastModifiedFrom}&lastModifiedTo={lastModifiedTo}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<ListProjectsResponse> listProjectsWithHttpInfo(@Param(value="top") @Nullable Integer var1, @Param(value="skip") @Nullable Integer var2, @Param(value="location") @Nullable List<String> var3, @Param(value="locationStrategy") @Nullable String var4, @Param(value="sort") @Nullable String var5, @Param(value="fields") @Nullable String var6, @Param(value="excludeOnline") @Nullable Boolean var7, @Param(value="status") @Nullable String var8, @Param(value="createdFrom") @Nullable DateTime var9, @Param(value="createdTo") @Nullable DateTime var10, @Param(value="createdBy") @Nullable String var11, @Param(value="projectTemplateId") @Nullable String var12, @Param(value="projectIds") @Nullable List<String> var13, @Param(value="sourceLanguage") @Nullable String var14, @Param(value="targetLanguage") @Nullable String var15, @Param(value="projectName") @Nullable String var16, @Param(value="dueFrom") @Nullable String var17, @Param(value="dueTo") @Nullable String var18, @Param(value="lastModifiedFrom") @Nullable String var19, @Param(value="lastModifiedTo") @Nullable String var20);

    @RequestLine(value="GET /projects?top={top}&skip={skip}&location={location}&locationStrategy={locationStrategy}&sort={sort}&fields={fields}&excludeOnline={excludeOnline}&status={status}&createdFrom={createdFrom}&createdTo={createdTo}&createdBy={createdBy}&projectTemplateId={projectTemplateId}&projectIds={projectIds}&sourceLanguage={sourceLanguage}&targetLanguage={targetLanguage}&projectName={projectName}&dueFrom={dueFrom}&dueTo={dueTo}&lastModifiedFrom={lastModifiedFrom}&lastModifiedTo={lastModifiedTo}")
    @Headers(value={"Accept: application/json"})
    public ListProjectsResponse listProjects(@QueryMap(encoded=true) ListProjectsQueryParams var1);

    @RequestLine(value="GET /projects?top={top}&skip={skip}&location={location}&locationStrategy={locationStrategy}&sort={sort}&fields={fields}&excludeOnline={excludeOnline}&status={status}&createdFrom={createdFrom}&createdTo={createdTo}&createdBy={createdBy}&projectTemplateId={projectTemplateId}&projectIds={projectIds}&sourceLanguage={sourceLanguage}&targetLanguage={targetLanguage}&projectName={projectName}&dueFrom={dueFrom}&dueTo={dueTo}&lastModifiedFrom={lastModifiedFrom}&lastModifiedTo={lastModifiedTo}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<ListProjectsResponse> listProjectsWithHttpInfo(@QueryMap(encoded=true) ListProjectsQueryParams var1);

    @RequestLine(value="PATCH /projects/{projectId}/tasks/reschedule")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public void rescheduleProjectTasks(@Param(value="projectId") @Nonnull String var1, @Nonnull RescheduleTasksRequest var2);

    @RequestLine(value="PATCH /projects/{projectId}/tasks/reschedule")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<Void> rescheduleProjectTasksWithHttpInfo(@Param(value="projectId") @Nonnull String var1, @Nonnull RescheduleTasksRequest var2);

    @RequestLine(value="PUT /projects/{projectId}/start")
    @Headers(value={"Accept: application/json"})
    public void startProject(@Param(value="projectId") @Nonnull String var1);

    @RequestLine(value="PUT /projects/{projectId}/start")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> startProjectWithHttpInfo(@Param(value="projectId") @Nonnull String var1);

    @RequestLine(value="PUT /projects/{projectId}/custom-fields/{customFieldKey}")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public void updateCustomField(@Param(value="projectId") @Nonnull String var1, @Param(value="customFieldKey") @Nonnull String var2, @Nullable CustomFieldUpdateRequest var3);

    @RequestLine(value="PUT /projects/{projectId}/custom-fields/{customFieldKey}")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<Void> updateCustomFieldWithHttpInfo(@Param(value="projectId") @Nonnull String var1, @Param(value="customFieldKey") @Nonnull String var2, @Nullable CustomFieldUpdateRequest var3);

    @RequestLine(value="PUT /projects/{projectId}")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public void updateProject(@Param(value="projectId") @Nonnull String var1, @Nonnull ProjectUpdateRequest var2);

    @RequestLine(value="PUT /projects/{projectId}")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<Void> updateProjectWithHttpInfo(@Param(value="projectId") @Nonnull String var1, @Nonnull ProjectUpdateRequest var2);

    @RequestLine(value="PUT /projects/{projectId}/configuration")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public void updateProjectConfiguration(@Param(value="projectId") @Nonnull String var1, @Nullable ProjectConfigurationRequest var2);

    @RequestLine(value="PUT /projects/{projectId}/configuration")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<Void> updateProjectConfigurationWithHttpInfo(@Param(value="projectId") @Nonnull String var1, @Nullable ProjectConfigurationRequest var2);

    @RequestLine(value="PUT /projects/{projectId}/pricing-model")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public void updateProjectPricingModel(@Param(value="projectId") @Nonnull String var1, @Nonnull ProjectPricingModelUpdateRequest var2);

    @RequestLine(value="PUT /projects/{projectId}/pricing-model")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<Void> updateProjectPricingModelWithHttpInfo(@Param(value="projectId") @Nonnull String var1, @Nonnull ProjectPricingModelUpdateRequest var2);

    public static class ListProjectsQueryParams
    extends HashMap<String, Object> {
        public ListProjectsQueryParams top(@Nullable Integer value) {
            this.put("top", EncodingUtils.encode(value));
            return this;
        }

        public ListProjectsQueryParams skip(@Nullable Integer value) {
            this.put("skip", EncodingUtils.encode(value));
            return this;
        }

        public ListProjectsQueryParams location(@Nullable List<String> value) {
            this.put("location", EncodingUtils.encodeCollection(value, "csv"));
            return this;
        }

        public ListProjectsQueryParams locationStrategy(@Nullable String value) {
            this.put("locationStrategy", EncodingUtils.encode(value));
            return this;
        }

        public ListProjectsQueryParams sort(@Nullable String value) {
            this.put("sort", EncodingUtils.encode(value));
            return this;
        }

        public ListProjectsQueryParams fields(@Nullable String value) {
            this.put("fields", EncodingUtils.encode(value));
            return this;
        }

        public ListProjectsQueryParams excludeOnline(@Nullable Boolean value) {
            this.put("excludeOnline", EncodingUtils.encode(value));
            return this;
        }

        public ListProjectsQueryParams status(@Nullable String value) {
            this.put("status", EncodingUtils.encode(value));
            return this;
        }

        public ListProjectsQueryParams createdFrom(@Nullable DateTime value) {
            this.put("createdFrom", EncodingUtils.encode(value));
            return this;
        }

        public ListProjectsQueryParams createdTo(@Nullable DateTime value) {
            this.put("createdTo", EncodingUtils.encode(value));
            return this;
        }

        public ListProjectsQueryParams createdBy(@Nullable String value) {
            this.put("createdBy", EncodingUtils.encode(value));
            return this;
        }

        public ListProjectsQueryParams projectTemplateId(@Nullable String value) {
            this.put("projectTemplateId", EncodingUtils.encode(value));
            return this;
        }

        public ListProjectsQueryParams projectIds(@Nullable List<String> value) {
            this.put("projectIds", EncodingUtils.encodeCollection(value, "multi"));
            return this;
        }

        public ListProjectsQueryParams sourceLanguage(@Nullable String value) {
            this.put("sourceLanguage", EncodingUtils.encode(value));
            return this;
        }

        public ListProjectsQueryParams targetLanguage(@Nullable String value) {
            this.put("targetLanguage", EncodingUtils.encode(value));
            return this;
        }

        public ListProjectsQueryParams projectName(@Nullable String value) {
            this.put("projectName", EncodingUtils.encode(value));
            return this;
        }

        public ListProjectsQueryParams dueFrom(@Nullable String value) {
            this.put("dueFrom", EncodingUtils.encode(value));
            return this;
        }

        public ListProjectsQueryParams dueTo(@Nullable String value) {
            this.put("dueTo", EncodingUtils.encode(value));
            return this;
        }

        public ListProjectsQueryParams lastModifiedFrom(@Nullable String value) {
            this.put("lastModifiedFrom", EncodingUtils.encode(value));
            return this;
        }

        public ListProjectsQueryParams lastModifiedTo(@Nullable String value) {
            this.put("lastModifiedTo", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class ListProjectTasksQueryParams
    extends HashMap<String, Object> {
        public ListProjectTasksQueryParams top(@Nullable Integer value) {
            this.put("top", EncodingUtils.encode(value));
            return this;
        }

        public ListProjectTasksQueryParams skip(@Nullable Integer value) {
            this.put("skip", EncodingUtils.encode(value));
            return this;
        }

        public ListProjectTasksQueryParams location(@Nullable List<String> value) {
            this.put("location", EncodingUtils.encodeCollection(value, "csv"));
            return this;
        }

        public ListProjectTasksQueryParams locationStrategy(@Nullable String value) {
            this.put("locationStrategy", EncodingUtils.encode(value));
            return this;
        }

        public ListProjectTasksQueryParams sort(@Nullable String value) {
            this.put("sort", EncodingUtils.encode(value));
            return this;
        }

        public ListProjectTasksQueryParams fields(@Nullable String value) {
            this.put("fields", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class GetProjectConfigurationQueryParams
    extends HashMap<String, Object> {
        public GetProjectConfigurationQueryParams fields(@Nullable String value) {
            this.put("fields", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class GetProjectQueryParams
    extends HashMap<String, Object> {
        public GetProjectQueryParams fields(@Nullable String value) {
            this.put("fields", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class CreateProjectQueryParams
    extends HashMap<String, Object> {
        public CreateProjectQueryParams fields(@Nullable String value) {
            this.put("fields", EncodingUtils.encode(value));
            return this;
        }
    }
}

