/*
 * Decompiled with CFR 0.152.
 */
package com.rws.lt.lc.publicapi.sdk.api;

import com.rws.lt.lc.publicapi.sdk.invoker.ApiClient;
import com.rws.lt.lc.publicapi.sdk.invoker.EncodingUtils;
import com.rws.lt.lc.publicapi.sdk.model.ApiResponse;
import com.rws.lt.lc.publicapi.sdk.model.Customer;
import com.rws.lt.lc.publicapi.sdk.model.CustomerCreateRequest;
import com.rws.lt.lc.publicapi.sdk.model.CustomerUpdateRequest;
import com.rws.lt.lc.publicapi.sdk.model.ListCustomersResponse;
import feign.Headers;
import feign.Param;
import feign.QueryMap;
import feign.RequestLine;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public interface CustomerApi
extends ApiClient.Api {
    @RequestLine(value="POST /customers?fields={fields}")
    @Headers(value={"Content-Type: application/json", "Accept: application/json,application/xml"})
    public Customer createCustomer(@Nonnull CustomerCreateRequest var1, @Param(value="fields") @Nullable String var2);

    @RequestLine(value="POST /customers?fields={fields}")
    @Headers(value={"Content-Type: application/json", "Accept: application/json,application/xml"})
    public ApiResponse<Customer> createCustomerWithHttpInfo(@Nonnull CustomerCreateRequest var1, @Param(value="fields") @Nullable String var2);

    @RequestLine(value="POST /customers?fields={fields}")
    @Headers(value={"Content-Type: application/json", "Accept: application/json,application/xml"})
    public Customer createCustomer(@Nonnull CustomerCreateRequest var1, @QueryMap(encoded=true) CreateCustomerQueryParams var2);

    @RequestLine(value="POST /customers?fields={fields}")
    @Headers(value={"Content-Type: application/json", "Accept: application/json,application/xml"})
    public ApiResponse<Customer> createCustomerWithHttpInfo(@Nonnull CustomerCreateRequest var1, @QueryMap(encoded=true) CreateCustomerQueryParams var2);

    @RequestLine(value="DELETE /customers/{customerId}")
    @Headers(value={"Accept: application/json"})
    public void deleteCustomer(@Param(value="customerId") @Nonnull String var1);

    @RequestLine(value="DELETE /customers/{customerId}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Void> deleteCustomerWithHttpInfo(@Param(value="customerId") @Nonnull String var1);

    @RequestLine(value="GET /customers/{customerId}?fields={fields}")
    @Headers(value={"Accept: application/json"})
    public Customer getCustomer(@Param(value="customerId") @Nonnull String var1, @Param(value="fields") @Nullable String var2);

    @RequestLine(value="GET /customers/{customerId}?fields={fields}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Customer> getCustomerWithHttpInfo(@Param(value="customerId") @Nonnull String var1, @Param(value="fields") @Nullable String var2);

    @RequestLine(value="GET /customers/{customerId}?fields={fields}")
    @Headers(value={"Accept: application/json"})
    public Customer getCustomer(@Param(value="customerId") @Nonnull String var1, @QueryMap(encoded=true) GetCustomerQueryParams var2);

    @RequestLine(value="GET /customers/{customerId}?fields={fields}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<Customer> getCustomerWithHttpInfo(@Param(value="customerId") @Nonnull String var1, @QueryMap(encoded=true) GetCustomerQueryParams var2);

    @RequestLine(value="GET /customers?top={top}&skip={skip}&location={location}&locationStrategy={locationStrategy}&sort={sort}&fields={fields}")
    @Headers(value={"Accept: application/json"})
    public ListCustomersResponse listCustomers(@Param(value="top") @Nullable Integer var1, @Param(value="skip") @Nullable Integer var2, @Param(value="location") @Nullable List<String> var3, @Param(value="locationStrategy") @Nullable String var4, @Param(value="sort") @Nullable String var5, @Param(value="fields") @Nullable String var6);

    @RequestLine(value="GET /customers?top={top}&skip={skip}&location={location}&locationStrategy={locationStrategy}&sort={sort}&fields={fields}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<ListCustomersResponse> listCustomersWithHttpInfo(@Param(value="top") @Nullable Integer var1, @Param(value="skip") @Nullable Integer var2, @Param(value="location") @Nullable List<String> var3, @Param(value="locationStrategy") @Nullable String var4, @Param(value="sort") @Nullable String var5, @Param(value="fields") @Nullable String var6);

    @RequestLine(value="GET /customers?top={top}&skip={skip}&location={location}&locationStrategy={locationStrategy}&sort={sort}&fields={fields}")
    @Headers(value={"Accept: application/json"})
    public ListCustomersResponse listCustomers(@QueryMap(encoded=true) ListCustomersQueryParams var1);

    @RequestLine(value="GET /customers?top={top}&skip={skip}&location={location}&locationStrategy={locationStrategy}&sort={sort}&fields={fields}")
    @Headers(value={"Accept: application/json"})
    public ApiResponse<ListCustomersResponse> listCustomersWithHttpInfo(@QueryMap(encoded=true) ListCustomersQueryParams var1);

    @RequestLine(value="PUT /customers/{customerId}")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public void updateCustomer(@Param(value="customerId") @Nonnull String var1, @Nonnull CustomerUpdateRequest var2);

    @RequestLine(value="PUT /customers/{customerId}")
    @Headers(value={"Content-Type: application/json", "Accept: application/json"})
    public ApiResponse<Void> updateCustomerWithHttpInfo(@Param(value="customerId") @Nonnull String var1, @Nonnull CustomerUpdateRequest var2);

    public static class ListCustomersQueryParams
    extends HashMap<String, Object> {
        public ListCustomersQueryParams top(@Nullable Integer value) {
            this.put("top", EncodingUtils.encode(value));
            return this;
        }

        public ListCustomersQueryParams skip(@Nullable Integer value) {
            this.put("skip", EncodingUtils.encode(value));
            return this;
        }

        public ListCustomersQueryParams location(@Nullable List<String> value) {
            this.put("location", EncodingUtils.encodeCollection(value, "csv"));
            return this;
        }

        public ListCustomersQueryParams locationStrategy(@Nullable String value) {
            this.put("locationStrategy", EncodingUtils.encode(value));
            return this;
        }

        public ListCustomersQueryParams sort(@Nullable String value) {
            this.put("sort", EncodingUtils.encode(value));
            return this;
        }

        public ListCustomersQueryParams fields(@Nullable String value) {
            this.put("fields", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class GetCustomerQueryParams
    extends HashMap<String, Object> {
        public GetCustomerQueryParams fields(@Nullable String value) {
            this.put("fields", EncodingUtils.encode(value));
            return this;
        }
    }

    public static class CreateCustomerQueryParams
    extends HashMap<String, Object> {
        public CreateCustomerQueryParams fields(@Nullable String value) {
            this.put("fields", EncodingUtils.encode(value));
            return this;
        }
    }
}

