/*
 * Decompiled with CFR 0.152.
 */
package com.rvirin.onvif.onvifcamera;

import android.util.Base64;
import com.rvirin.onvif.onvifcamera.OnvifDeviceKt;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.SimpleDateFormat;
import java.util.GregorianCalendar;
import java.util.Random;
import java.util.SimpleTimeZone;
import java.util.TimeZone;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u000b\n\u0002\u0010\u0012\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u000b\u001a\u0004\u0018\u00010\u00042\u0006\u0010\f\u001a\u00020\u0004H\u0002J\b\u0010\r\u001a\u00020\u0004H\u0002J\u0010\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0012\u0010\u000e\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0011\u001a\u00020\u0004H\u0002R\u0011\u0010\u0003\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\u0006R\u000e\u0010\t\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/rvirin/onvif/onvifcamera/OnvifXMLBuilder;", "", "()V", "authorizationHeader", "", "getAuthorizationHeader", "()Ljava/lang/String;", "envelopeEnd", "getEnvelopeEnd", "nonce", "utcTime", "encryptPassword", "password", "getUTCTime", "toBase64", "data", "", "message", "onvifcamera_release"})
public final class OnvifXMLBuilder {
    private static final String utcTime;
    private static final String nonce;
    public static final OnvifXMLBuilder INSTANCE;

    @NotNull
    public final String getAuthorizationHeader() {
        String authorizationPart = "";
        String envelopePart = "<?xml version=\"1.0\" encoding=\"utf-8\"?><soap:Envelope xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:soap=\"http://www.w3.org/2003/05/soap-envelope\" >";
        if (!StringsKt.equals((String)OnvifDeviceKt.currentDevice.username, (String)"", (boolean)true)) {
            authorizationPart = "<soap:Header><wsse:Security xmlns:wsse=\"http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd\"><wsse:UsernameToken xmlns:wsu=\"http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd\"><wsse:Username>" + OnvifDeviceKt.currentDevice.username + "</wsse:Username>" + "<wsse:Password Type=\"http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-username-token-profile-1.0#PasswordDigest\">" + this.encryptPassword(OnvifDeviceKt.currentDevice.password) + "</wsse:Password>" + "<wsse:Nonce EncodingType=\"http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-soap-message-security-1.0#Base64Binary\">" + this.toBase64(nonce) + "</wsse:Nonce>" + "<wsu:Created>" + utcTime + "</wsu:Created>" + "</wsse:UsernameToken>" + "</wsse:Security>" + "</soap:Header>";
        }
        return "" + envelopePart + "" + authorizationPart + "<soap:Body>";
    }

    @NotNull
    public final String getEnvelopeEnd() {
        return "</soap:Body></soap:Envelope>";
    }

    private final String encryptPassword(String password) {
        byte[] encryptedRaw;
        String beforeEncryption = nonce + utcTime + password;
        try {
            MessageDigest SHA1 = MessageDigest.getInstance("SHA-1");
            SHA1.reset();
            String string = beforeEncryption;
            MessageDigest messageDigest = SHA1;
            Charset charset = Charsets.UTF_8;
            String string2 = string;
            if (string2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            byte[] byArray = string2.getBytes(charset);
            Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
            byte[] byArray2 = byArray;
            messageDigest.update(byArray2);
            byte[] byArray3 = SHA1.digest();
            Intrinsics.checkExpressionValueIsNotNull((Object)byArray3, (String)"SHA1.digest()");
            encryptedRaw = byArray3;
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
            return null;
        }
        String encodedString = this.toBase64(encryptedRaw);
        encodedString = StringsKt.replace$default((String)encodedString, (String)"\n", (String)"", (boolean)false, (int)4, null);
        return encodedString;
    }

    private final String toBase64(String message) {
        try {
            String string = message;
            Object object = "UTF-8";
            Charset charset = Charset.forName((String)object);
            Intrinsics.checkExpressionValueIsNotNull((Object)charset, (String)"Charset.forName(charsetName)");
            object = charset;
            String string2 = string;
            if (string2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            byte[] byArray = string2.getBytes((Charset)object);
            Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
            byte[] data = byArray;
            return this.toBase64(data);
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return null;
        }
    }

    private final String toBase64(byte[] data) {
        String string = Base64.encodeToString((byte[])data, (int)0);
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"encodeToString(data, DEFAULT)");
        return string;
    }

    private final String getUTCTime() {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:sss'Z'");
        sdf.setTimeZone(new SimpleTimeZone(2, "UTC"));
        GregorianCalendar cal = new GregorianCalendar(TimeZone.getTimeZone("UTC"));
        String string = sdf.format(cal.getTime());
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"sdf.format(cal.time)");
        return string;
    }

    private OnvifXMLBuilder() {
    }

    static {
        OnvifXMLBuilder onvifXMLBuilder;
        INSTANCE = onvifXMLBuilder = new OnvifXMLBuilder();
        utcTime = onvifXMLBuilder.getUTCTime();
        nonce = "" + new Random().nextInt();
    }
}

