/*
 * Decompiled with CFR 0.152.
 */
package com.rvirin.onvif.onvifcamera;

import android.util.Base64;
import com.rvirin.onvif.onvifcamera.OnvifDeviceKt;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.SimpleDateFormat;
import java.util.GregorianCalendar;
import java.util.Random;
import java.util.SimpleTimeZone;
import java.util.TimeZone;

public class OnvifHeaderBody {
    private static String utcTime;
    private static String nonce;

    public static String getAuthorizationHeader() {
        nonce = "" + new Random().nextInt();
        utcTime = OnvifHeaderBody.getUTCTime();
        String authorizationPart = "";
        String envelopePart = "<SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://www.w3.org/2003/05/soap-envelope\" xmlns:SOAP-ENC=\"http://www.w3.org/2003/05/soap-encoding\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:wsa=\"http://schemas.xmlsoap.org/ws/2004/08/addressing\" xmlns:wsdd=\"http://schemas.xmlsoap.org/ws/2005/04/discovery\" xmlns:chan=\"http://schemas.microsoft.com/ws/2005/02/duplex\" xmlns:wsa5=\"http://www.w3.org/2005/08/addressing\" xmlns:xmime=\"http://tempuri.org/xmime.xsd\" xmlns:xop=\"http://www.w3.org/2004/08/xop/include\" xmlns:tt=\"http://www.onvif.org/ver10/schema\" xmlns:wsrfbf=\"http://docs.oasis-open.org/wsrf/bf-2\" xmlns:wstop=\"http://docs.oasis-open.org/wsn/t-1\" xmlns:wsrfr=\"http://docs.oasis-open.org/wsrf/r-2\" xmlns:tdn=\"http://www.onvif.org/ver10/network/wsdl\" xmlns:tds=\"http://www.onvif.org/ver10/device/wsdl\" xmlns:tev=\"http://www.onvif.org/ver10/events/wsdl\" xmlns:wsnt=\"http://docs.oasis-open.org/wsn/b-2\" xmlns:tptz=\"http://www.onvif.org/ver20/ptz/wsdl\" xmlns:trt=\"http://www.onvif.org/ver10/media/wsdl\">";
        if (!OnvifDeviceKt.currentDevice.username.equalsIgnoreCase("")) {
            authorizationPart = "<SOAP-ENV:Header><Security SOAP-ENV:mustUnderstand=\"true\"><UsernameToken><Username>" + OnvifDeviceKt.currentDevice.username + "</Username>" + "<Password Type=\"http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-username-token-profile-1.0#PasswordDigest\">" + OnvifHeaderBody.encryptPassword(OnvifDeviceKt.currentDevice.password) + "</Password>" + "<Nonce>" + OnvifHeaderBody.toBase64(nonce) + "</Nonce>" + "<Created>" + utcTime + "</Created>" + "</UsernameToken>" + "</Security>" + "</SOAP-ENV:Header>";
        }
        return envelopePart + authorizationPart + "<SOAP-ENV:Body>";
    }

    public static String getEnvelopeEnd() {
        return "</SOAP-ENV:Body></SOAP-ENV:Envelope>";
    }

    private static String encryptPassword(String password) {
        byte[] encryptedRaw;
        String beforeEncryption = nonce + utcTime + password;
        try {
            MessageDigest SHA1 = MessageDigest.getInstance("SHA-1");
            SHA1.reset();
            SHA1.update(beforeEncryption.getBytes());
            encryptedRaw = SHA1.digest();
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
            return null;
        }
        String encodedString = OnvifHeaderBody.toBase64(encryptedRaw);
        encodedString = encodedString.replace("\n", "");
        return encodedString;
    }

    private static String toBase64(String message) {
        try {
            byte[] data = message.getBytes("UTF-8");
            return OnvifHeaderBody.toBase64(data);
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return null;
        }
    }

    private static String toBase64(byte[] data) {
        return Base64.encodeToString((byte[])data, (int)0);
    }

    private static String getUTCTime() {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:sss'Z'");
        sdf.setTimeZone(new SimpleTimeZone(2, "UTC"));
        GregorianCalendar cal = new GregorianCalendar(TimeZone.getTimeZone("UTC"));
        return sdf.format(cal.getTime());
    }
}

