/*
 * Decompiled with CFR 0.152.
 */
package com.rvirin.onvif.onvifcamera;

import com.rvirin.onvif.onvifcamera.OnvifResponseParser;

public class OnvifDeviceInformation {
    private String manufacturerName = "unknown";
    private String modelName = "unknown";
    private String fwVersion = "unknown";
    private String serialNumber = "unknown";
    private String hwID = "unknown";

    public static String getDeviceInformationCommand() {
        return "<GetDeviceInformation xmlns=\"http://www.onvif.org/ver10/device/wsdl\"/>";
    }

    public static boolean parseDeviceInformationResponse(String response, OnvifDeviceInformation parsed) {
        try {
            OnvifResponseParser.lastIndex = 0;
            parsed.manufacturerName = OnvifResponseParser.parseOnvifString("facturer>", "</tds", response);
            parsed.modelName = OnvifResponseParser.parseOnvifString("Model>", "</tds", response);
            parsed.fwVersion = OnvifResponseParser.parseOnvifString("Version>", "</tds", response);
            parsed.serialNumber = OnvifResponseParser.parseOnvifString("Number>", "</tds", response);
            parsed.hwID = OnvifResponseParser.parseOnvifString("reId>", "</tds", response);
            return true;
        }
        catch (StringIndexOutOfBoundsException ignore) {
            return false;
        }
    }

    public static String deviceInformationToString(OnvifDeviceInformation parsed) {
        String parsedResult = "Device information:\n";
        parsedResult = parsedResult + "Manufacturer: " + parsed.manufacturerName + "\n";
        parsedResult = parsedResult + "Model: " + parsed.modelName + "\n";
        parsedResult = parsedResult + "FirmwareVersion: " + parsed.fwVersion + "\n";
        parsedResult = parsedResult + "SerialNumber: " + parsed.serialNumber + "\n";
        return parsedResult;
    }
}

