/*
 * Decompiled with CFR 0.152.
 */
package com.rvirin.onvif.onvifcamera;

import android.os.AsyncTask;
import android.util.Log;
import com.rvirin.onvif.onvifcamera.MediaProfile;
import com.rvirin.onvif.onvifcamera.OnvifDeviceInformation;
import com.rvirin.onvif.onvifcamera.OnvifDeviceKt;
import com.rvirin.onvif.onvifcamera.OnvifHeaderBody;
import com.rvirin.onvif.onvifcamera.OnvifListener;
import com.rvirin.onvif.onvifcamera.OnvifMediaProfiles;
import com.rvirin.onvif.onvifcamera.OnvifMediaStreamURI;
import com.rvirin.onvif.onvifcamera.OnvifRequest;
import com.rvirin.onvif.onvifcamera.OnvifResponse;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import okio.Buffer;
import okio.BufferedSink;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001+B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\"\u001a\u00020\u00032\u0006\u0010#\u001a\u00020\u0003H\u0002J\u0006\u0010$\u001a\u00020%J\u0006\u0010&\u001a\u00020%J\u0006\u0010'\u001a\u00020%J\u0010\u0010(\u001a\u00020\u00032\u0006\u0010)\u001a\u00020*H\u0002R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\t\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\u000b\"\u0004\b\f\u0010\rR\u001c\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R \u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001aR\u0010\u0010\u0005\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u001b\u001a\u0004\u0018\u00010\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\u001d\"\u0004\b\u001e\u0010\u001fR\u0011\u0010 \u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\u001dR\u0010\u0010\u0004\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006,"}, d2={"Lcom/rvirin/onvif/onvifcamera/OnvifDevice;", "", "IPAddress", "", "username", "password", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "deviceInformation", "Lcom/rvirin/onvif/onvifcamera/OnvifDeviceInformation;", "isConnected", "", "()Z", "setConnected", "(Z)V", "listener", "Lcom/rvirin/onvif/onvifcamera/OnvifListener;", "getListener", "()Lcom/rvirin/onvif/onvifcamera/OnvifListener;", "setListener", "(Lcom/rvirin/onvif/onvifcamera/OnvifListener;)V", "mediaProfiles", "", "Lcom/rvirin/onvif/onvifcamera/MediaProfile;", "getMediaProfiles", "()Ljava/util/List;", "setMediaProfiles", "(Ljava/util/List;)V", "rtspURI", "getRtspURI", "()Ljava/lang/String;", "setRtspURI", "(Ljava/lang/String;)V", "url", "getUrl", "appendCredentials", "streamURI", "getDeviceInformation", "", "getProfiles", "getStreamURI", "parseOnvifResponses", "result", "Lcom/rvirin/onvif/onvifcamera/OnvifResponse;", "ONVIFcommunication", "onvifcamera_release"})
public final class OnvifDevice {
    @Nullable
    private OnvifListener listener;
    private boolean isConnected;
    @NotNull
    private final String url;
    private final OnvifDeviceInformation deviceInformation;
    @NotNull
    private List<MediaProfile> mediaProfiles;
    @Nullable
    private String rtspURI;
    @JvmField
    @NotNull
    public final String username;
    @JvmField
    @NotNull
    public final String password;

    @Nullable
    public final OnvifListener getListener() {
        return this.listener;
    }

    public final void setListener(@Nullable OnvifListener onvifListener) {
        this.listener = onvifListener;
    }

    public final boolean isConnected() {
        return this.isConnected;
    }

    public final void setConnected(boolean bl) {
        this.isConnected = bl;
    }

    @NotNull
    public final String getUrl() {
        return this.url;
    }

    @NotNull
    public final List<MediaProfile> getMediaProfiles() {
        return this.mediaProfiles;
    }

    public final void setMediaProfiles(@NotNull List<MediaProfile> list) {
        Intrinsics.checkParameterIsNotNull(list, (String)"<set-?>");
        this.mediaProfiles = list;
    }

    @Nullable
    public final String getRtspURI() {
        return this.rtspURI;
    }

    public final void setRtspURI(@Nullable String string) {
        this.rtspURI = string;
    }

    public final void getDeviceInformation() {
        String string = OnvifDeviceInformation.getDeviceInformationCommand();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"getDeviceInformationCommand()");
        OnvifRequest request = new OnvifRequest(string, OnvifRequest.Type.GetDeviceInformation);
        new ONVIFcommunication().execute(new OnvifRequest[]{request});
    }

    public final void getProfiles() {
        OnvifRequest request = new OnvifRequest(OnvifMediaProfiles.Companion.getProfilesCommand(), OnvifRequest.Type.GetProfiles);
        new ONVIFcommunication().execute(new OnvifRequest[]{request});
    }

    public final void getStreamURI() {
        block0: {
            MediaProfile mediaProfile;
            MediaProfile mediaProfile2 = (MediaProfile)CollectionsKt.lastOrNull(this.mediaProfiles);
            if (mediaProfile2 == null) break block0;
            MediaProfile it = mediaProfile = mediaProfile2;
            OnvifRequest request = new OnvifRequest(OnvifMediaStreamURI.Companion.getStreamURICommand(it), OnvifRequest.Type.GetStreamURI);
            new ONVIFcommunication().execute(new OnvifRequest[]{request});
        }
    }

    private final String appendCredentials(String streamURI) {
        String string;
        String protocol = "rtsp://";
        int startIndex = protocol.length();
        String string2 = string = streamURI;
        if (string2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        String string3 = string2.substring(startIndex);
        Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"(this as java.lang.String).substring(startIndex)");
        String uri = string3;
        return protocol + OnvifDeviceKt.currentDevice.username + ":" + OnvifDeviceKt.currentDevice.password + "@" + uri;
    }

    private final String parseOnvifResponses(OnvifResponse result) {
        String parsedResult;
        block2: {
            block4: {
                String string;
                block3: {
                    block1: {
                        parsedResult = "Parsing failed";
                        if (result.getSuccess()) break block1;
                        parsedResult = "Communication error trying to get " + result.getRequest() + ":\n\n" + result.getError();
                        break block2;
                    }
                    if (!Intrinsics.areEqual((Object)((Object)result.getRequest().getType()), (Object)((Object)OnvifRequest.Type.GetDeviceInformation))) break block3;
                    this.isConnected = true;
                    if (!OnvifDeviceInformation.parseDeviceInformationResponse(result.getResult(), OnvifDeviceKt.currentDevice.deviceInformation)) break block2;
                    String string2 = OnvifDeviceInformation.deviceInformationToString(OnvifDeviceKt.currentDevice.deviceInformation);
                    Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"deviceInformationToStrin\u2026Device.deviceInformation)");
                    parsedResult = string2;
                    break block2;
                }
                if (!Intrinsics.areEqual((Object)((Object)result.getRequest().getType()), (Object)((Object)OnvifRequest.Type.GetProfiles))) break block4;
                String string3 = result.getResult();
                if (string3 == null) break block2;
                String it = string = string3;
                List<MediaProfile> profiles = OnvifMediaProfiles.Companion.parseXML(it);
                OnvifDeviceKt.currentDevice.mediaProfiles = profiles;
                Collection collection = profiles;
                StringBuilder stringBuilder = new StringBuilder();
                int n = collection.size();
                parsedResult = stringBuilder.append(String.valueOf(n)).append(" profiles retrieved.").toString();
                break block2;
            }
            if (!Intrinsics.areEqual((Object)((Object)result.getRequest().getType()), (Object)((Object)OnvifRequest.Type.GetStreamURI))) break block2;
            String string = result.getResult();
            if (string != null) {
                String string4;
                String it = string4 = string;
                String streamURI = OnvifMediaStreamURI.Companion.parseStreamURIXML(it);
                OnvifDeviceKt.currentDevice.rtspURI = this.appendCredentials(streamURI);
                parsedResult = "RTSP URI retrieved.";
            }
        }
        return parsedResult;
    }

    public OnvifDevice(@NotNull String IPAddress, @NotNull String username, @NotNull String password) {
        Intrinsics.checkParameterIsNotNull((Object)IPAddress, (String)"IPAddress");
        Intrinsics.checkParameterIsNotNull((Object)username, (String)"username");
        Intrinsics.checkParameterIsNotNull((Object)password, (String)"password");
        this.username = username;
        this.password = password;
        this.url = "http://" + IPAddress + "/onvif/device_service";
        this.deviceInformation = new OnvifDeviceInformation();
        this.mediaProfiles = CollectionsKt.emptyList();
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u0014\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0001B\u0005\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00032\u0006\u0010\u0007\u001a\u00020\bH\u0002J!\u0010\t\u001a\u00020\u00042\u0012\u0010\n\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00020\u000b\"\u00020\u0002H\u0014\u00a2\u0006\u0002\u0010\fJ\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0004H\u0014\u00a8\u0006\u0010"}, d2={"Lcom/rvirin/onvif/onvifcamera/OnvifDevice$ONVIFcommunication;", "Landroid/os/AsyncTask;", "Lcom/rvirin/onvif/onvifcamera/OnvifRequest;", "", "Lcom/rvirin/onvif/onvifcamera/OnvifResponse;", "(Lcom/rvirin/onvif/onvifcamera/OnvifDevice;)V", "bodyToString", "request", "Lokhttp3/Request;", "doInBackground", "params", "", "([Lcom/rvirin/onvif/onvifcamera/OnvifRequest;)Lcom/rvirin/onvif/onvifcamera/OnvifResponse;", "onPostExecute", "", "result", "onvifcamera_release"})
    private final class ONVIFcommunication
    extends AsyncTask<OnvifRequest, String, OnvifResponse> {
        @NotNull
        protected OnvifResponse doInBackground(OnvifRequest ... params) {
            Intrinsics.checkParameterIsNotNull((Object)params, (String)"params");
            OnvifRequest onvifRequest = params[0];
            OkHttpClient client = new OkHttpClient.Builder().connectTimeout(10000L, TimeUnit.SECONDS).writeTimeout(100L, TimeUnit.SECONDS).readTimeout(10000L, TimeUnit.SECONDS).build();
            MediaType reqBodyType = MediaType.parse((String)"application/soap+xml; charset=utf-8;");
            RequestBody reqBody = RequestBody.create((MediaType)reqBodyType, (String)(OnvifHeaderBody.getAuthorizationHeader() + onvifRequest.getXmlCommand() + OnvifHeaderBody.getEnvelopeEnd()));
            Request request = null;
            try {
                request = new Request.Builder().url(OnvifDeviceKt.currentDevice.getUrl()).addHeader("content-type", "application/soap+xml; charset=UTF-8").post(reqBody).build();
            }
            catch (IllegalArgumentException e) {
                String string = e.getMessage();
                if (string == null) {
                    Intrinsics.throwNpe();
                }
                Log.e((String)"ERROR", (String)string);
                e.printStackTrace();
            }
            OnvifResponse result = new OnvifResponse(onvifRequest);
            if (request != null) {
                try {
                    Response response = client.newCall(request).execute();
                    Log.d((String)"BODY", (String)this.bodyToString(request));
                    Log.d((String)"RESPONSE", (String)response.toString());
                    if (response.code() != 200) {
                        String message = String.valueOf(response.code()) + " - " + response.message();
                        result.updateResponse(false, message);
                    } else {
                        ResponseBody responseBody = response.body();
                        if (responseBody == null) {
                            Intrinsics.throwNpe();
                        }
                        String string = responseBody.string();
                        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"response.body()!!.string()");
                        result.updateResponse(true, string);
                    }
                }
                catch (IOException e) {
                    String string = e.getMessage();
                    if (string == null) {
                        Intrinsics.throwNpe();
                    }
                    result.updateResponse(false, string);
                }
            }
            return result;
        }

        private final String bodyToString(Request request) {
            try {
                Request copy = request.newBuilder().build();
                Buffer buffer = new Buffer();
                RequestBody requestBody = copy.body();
                if (requestBody == null) {
                    Intrinsics.throwNpe();
                }
                requestBody.writeTo((BufferedSink)buffer);
                String string = buffer.readUtf8();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"buffer.readUtf8()");
                return string;
            }
            catch (IOException e) {
                return "did not work";
            }
        }

        protected void onPostExecute(@NotNull OnvifResponse result) {
            block0: {
                Intrinsics.checkParameterIsNotNull((Object)result, (String)"result");
                Log.d((String)"RESULT", (String)String.valueOf(result.getSuccess()));
                String uiMessage = OnvifDevice.this.parseOnvifResponses(result);
                OnvifListener onvifListener = OnvifDevice.this.getListener();
                if (onvifListener == null) break block0;
                onvifListener.requestPerformed(result, uiMessage);
            }
        }
    }
}

