/*
 * Decompiled with CFR 0.152.
 */
package com.rvalerio.fgchecker.detectors;

import android.annotation.TargetApi;
import android.app.usage.UsageEvents;
import android.app.usage.UsageStatsManager;
import android.content.Context;
import com.rvalerio.fgchecker.Utils;
import com.rvalerio.fgchecker.detectors.Detector;

public class LollipopDetector
implements Detector {
    @Override
    @TargetApi(value=21)
    public String getForegroundApp(Context context) {
        if (!Utils.hasUsageStatsPermission(context)) {
            return null;
        }
        String foregroundApp = null;
        UsageStatsManager mUsageStatsManager = (UsageStatsManager)context.getSystemService("usagestats");
        long time = System.currentTimeMillis();
        UsageEvents usageEvents = mUsageStatsManager.queryEvents(time - 3600000L, time);
        UsageEvents.Event event = new UsageEvents.Event();
        while (usageEvents.hasNextEvent()) {
            usageEvents.getNextEvent(event);
            if (event.getEventType() != 1) continue;
            foregroundApp = event.getPackageName();
        }
        return foregroundApp;
    }
}

