/*
 * Decompiled with CFR 0.152.
 */
package com.rvalerio.fgchecker;

import android.content.Context;
import android.os.Handler;
import android.os.Looper;
import com.rvalerio.fgchecker.Utils;
import com.rvalerio.fgchecker.detectors.Detector;
import com.rvalerio.fgchecker.detectors.LollipopDetector;
import com.rvalerio.fgchecker.detectors.PreLollipopDetector;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class AppChecker {
    ScheduledExecutorService service;
    Runnable runnable;
    static final int DEFAULT_TIMEOUT = 1000;
    int timeout = 1000;
    Listener defaultListener;
    Map<String, Listener> listeners = new HashMap<String, Listener>();
    Detector detector;
    Handler handler = new Handler(Looper.getMainLooper());

    public AppChecker() {
        this.detector = Utils.postLollipop() ? new LollipopDetector() : new PreLollipopDetector();
    }

    public AppChecker timeout(int timeout) {
        this.timeout = timeout;
        return this;
    }

    public AppChecker when(String packageName, Listener listener) {
        this.listeners.put(packageName, listener);
        return this;
    }

    public AppChecker other(Listener listener) {
        this.defaultListener = listener;
        return this;
    }

    public void start(Context context) {
        this.service = new ScheduledThreadPoolExecutor(1);
        this.runnable = this.createRunnable(context.getApplicationContext());
        this.service.schedule(this.runnable, (long)this.timeout, TimeUnit.MILLISECONDS);
    }

    public void stop() {
        this.service.shutdownNow();
        this.runnable = null;
        this.service = null;
    }

    private Runnable createRunnable(final Context context) {
        return new Runnable(){

            @Override
            public void run() {
                AppChecker.this.getForegroundAppAndNotify(context);
                AppChecker.this.service.schedule(AppChecker.this.createRunnable(context), (long)AppChecker.this.timeout, TimeUnit.MILLISECONDS);
            }
        };
    }

    private void getForegroundAppAndNotify(Context context) {
        final String foregroundApp = this.getForegroundApp(context);
        if (foregroundApp != null) {
            for (String packageName : this.listeners.keySet()) {
                if (!packageName.toLowerCase().equals(foregroundApp)) continue;
                this.handler.post(new Runnable(){

                    @Override
                    public void run() {
                        AppChecker.this.listeners.get(foregroundApp).onForeground(foregroundApp);
                    }
                });
                return;
            }
        }
        if (this.defaultListener != null) {
            this.handler.post(new Runnable(){

                @Override
                public void run() {
                    AppChecker.this.defaultListener.onForeground(foregroundApp);
                }
            });
        }
    }

    public String getForegroundApp(Context context) {
        return this.detector.getForegroundApp(context);
    }

    public static interface Listener {
        public void onForeground(String var1);
    }
}

