/*
 * Decompiled with CFR 0.152.
 */
package com.runningmessage.kotlinx.widget;

import android.support.annotation.IntRange;
import android.support.annotation.RestrictTo;
import android.text.TextUtils;
import java.util.Arrays;
import java.util.Collection;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u0014\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0004\n\u0002\u0010\u001e\n\u0002\b\f\n\u0002\u0010\r\n\u0002\b\u0004\b\u00c7\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u0016\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0001J\u0016\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\fJ&\u0010\r\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\fJ&\u0010\r\u001a\u00020\u00102\u0006\u0010\n\u001a\u00020\u00102\u0006\u0010\u000e\u001a\u00020\u00102\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u000b\u001a\u00020\fJ&\u0010\r\u001a\u00020\u00112\u0006\u0010\n\u001a\u00020\u00112\u0006\u0010\u000e\u001a\u00020\u00112\u0006\u0010\u000f\u001a\u00020\u00112\u0006\u0010\u000b\u001a\u00020\fJ\u0010\u0010\u0012\u001a\u00020\u00102\u0006\u0010\n\u001a\u00020\u0010H\u0007J\u0018\u0010\u0012\u001a\u00020\u00102\u0006\u0010\n\u001a\u00020\u00102\u0006\u0010\u0007\u001a\u00020\fH\u0007J\u000e\u0010\u0012\u001a\u00020\u00112\u0006\u0010\n\u001a\u00020\u0011J\u0016\u0010\u0012\u001a\u00020\u00112\u0006\u0010\n\u001a\u00020\u00112\u0006\u0010\u0007\u001a\u00020\fJ\u0016\u0010\u0013\u001a\u00020\u00102\u0006\u0010\n\u001a\u00020\u00102\u0006\u0010\u0007\u001a\u00020\fJ&\u0010\u0014\u001a\u00020\u00152\u0006\u0010\n\u001a\u00020\u00152\u0006\u0010\u000e\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\fJ/\u0010\u0016\u001a\b\u0012\u0004\u0012\u0002H\u00180\u0017\"\u0004\b\u0000\u0010\u00182\u000e\u0010\n\u001a\n\u0012\u0004\u0012\u0002H\u0018\u0018\u00010\u00172\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\u0019J3\u0010\u001a\u001a\u0002H\u001b\"\u000e\b\u0000\u0010\u001b*\b\u0012\u0004\u0012\u0002H\u00180\u001c\"\u0004\b\u0001\u0010\u00182\b\u0010\n\u001a\u0004\u0018\u0001H\u001b2\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\u001dJ*\u0010\u001e\u001a\b\u0012\u0004\u0012\u0002H\u00180\u001c\"\u0004\b\u0000\u0010\u00182\u000e\u0010\n\u001a\n\u0012\u0004\u0012\u0002H\u0018\u0018\u00010\u001c2\u0006\u0010\u000b\u001a\u00020\fJ\u0016\u0010\u001f\u001a\u00020\u00102\u0006\u0010 \u001a\u00020\u00102\u0006\u0010!\u001a\u00020\u0010J\u001b\u0010\"\u001a\u0002H\u0018\"\u0004\b\u0000\u0010\u00182\b\u0010#\u001a\u0004\u0018\u0001H\u0018\u00a2\u0006\u0002\u0010$J#\u0010\"\u001a\u0002H\u0018\"\u0004\b\u0000\u0010\u00182\b\u0010#\u001a\u0004\u0018\u0001H\u00182\u0006\u0010\u0007\u001a\u00020\u0001\u00a2\u0006\u0002\u0010%J\u001c\u0010&\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\n\b\u0002\u0010'\u001a\u0004\u0018\u00010\fH\u0007J\u001d\u0010(\u001a\u0002H\u0018\"\b\b\u0000\u0010\u0018*\u00020)2\u0006\u0010*\u001a\u0002H\u0018\u00a2\u0006\u0002\u0010+J%\u0010(\u001a\u0002H\u0018\"\b\b\u0000\u0010\u0018*\u00020)2\u0006\u0010*\u001a\u0002H\u00182\u0006\u0010\u0007\u001a\u00020\u0001\u00a2\u0006\u0002\u0010,\u00a8\u0006-"}, d2={"Lcom/runningmessage/kotlinx/widget/Preconditions;", "", "()V", "checkArgument", "", "expression", "", "errorMessage", "checkArgumentFinite", "", "value", "valueName", "", "checkArgumentInRange", "lower", "upper", "", "", "checkArgumentNonnegative", "checkArgumentPositive", "checkArrayElementsInRange", "", "checkArrayElementsNotNull", "", "T", "([Ljava/lang/Object;Ljava/lang/String;)[Ljava/lang/Object;", "checkCollectionElementsNotNull", "C", "", "(Ljava/util/Collection;Ljava/lang/String;)Ljava/util/Collection;", "checkCollectionNotEmpty", "checkFlagsArgument", "requestedFlags", "allowedFlags", "checkNotNull", "reference", "(Ljava/lang/Object;)Ljava/lang/Object;", "(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;", "checkState", "message", "checkStringNotEmpty", "", "string", "(Ljava/lang/CharSequence;)Ljava/lang/CharSequence;", "(Ljava/lang/CharSequence;Ljava/lang/Object;)Ljava/lang/CharSequence;", "kotlinx-widget_release"})
@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public final class Preconditions {
    public static final Preconditions INSTANCE;

    public final void checkArgument(boolean expression) {
        if (!expression) {
            throw (Throwable)new IllegalArgumentException();
        }
    }

    public final void checkArgument(boolean expression, @NotNull Object errorMessage) {
        Intrinsics.checkParameterIsNotNull((Object)errorMessage, (String)"errorMessage");
        if (!expression) {
            throw (Throwable)new IllegalArgumentException(errorMessage.toString());
        }
    }

    @NotNull
    public final <T extends CharSequence> T checkStringNotEmpty(@NotNull T string) {
        Intrinsics.checkParameterIsNotNull(string, (String)"string");
        if (TextUtils.isEmpty(string)) {
            throw (Throwable)new IllegalArgumentException();
        }
        return string;
    }

    @NotNull
    public final <T extends CharSequence> T checkStringNotEmpty(@NotNull T string, @NotNull Object errorMessage) {
        Intrinsics.checkParameterIsNotNull(string, (String)"string");
        Intrinsics.checkParameterIsNotNull((Object)errorMessage, (String)"errorMessage");
        if (TextUtils.isEmpty(string)) {
            throw (Throwable)new IllegalArgumentException(errorMessage.toString());
        }
        return string;
    }

    public final <T> T checkNotNull(@Nullable T reference) {
        if (reference == null) {
            throw (Throwable)new NullPointerException();
        }
        return reference;
    }

    public final <T> T checkNotNull(@Nullable T reference, @NotNull Object errorMessage) {
        Intrinsics.checkParameterIsNotNull((Object)errorMessage, (String)"errorMessage");
        if (reference == null) {
            throw (Throwable)new NullPointerException(errorMessage.toString());
        }
        return reference;
    }

    @JvmOverloads
    public final void checkState(boolean expression, @Nullable String message) {
        if (!expression) {
            throw (Throwable)new IllegalStateException(message);
        }
    }

    @JvmOverloads
    public static /* synthetic */ void checkState$default(Preconditions preconditions, boolean bl, String string, int n, Object object) {
        if ((n & 2) != 0) {
            string = null;
        }
        preconditions.checkState(bl, string);
    }

    @JvmOverloads
    public final void checkState(boolean expression) {
        Preconditions.checkState$default(this, expression, null, 2, null);
    }

    public final int checkFlagsArgument(int requestedFlags, int allowedFlags) {
        if ((requestedFlags & allowedFlags) != requestedFlags) {
            throw (Throwable)new IllegalArgumentException("Requested flags 0x" + Integer.toHexString(requestedFlags) + ", but only 0x" + Integer.toHexString(allowedFlags) + " are allowed");
        }
        return requestedFlags;
    }

    @IntRange(from=0L)
    public final int checkArgumentNonnegative(int value, @NotNull String errorMessage) {
        Intrinsics.checkParameterIsNotNull((Object)errorMessage, (String)"errorMessage");
        if (value < 0) {
            throw (Throwable)new IllegalArgumentException(errorMessage);
        }
        return value;
    }

    @IntRange(from=0L)
    public final int checkArgumentNonnegative(int value) {
        if (value < 0) {
            throw (Throwable)new IllegalArgumentException();
        }
        return value;
    }

    public final long checkArgumentNonnegative(long value) {
        if (value < 0L) {
            throw (Throwable)new IllegalArgumentException();
        }
        return value;
    }

    public final long checkArgumentNonnegative(long value, @NotNull String errorMessage) {
        Intrinsics.checkParameterIsNotNull((Object)errorMessage, (String)"errorMessage");
        if (value < 0L) {
            throw (Throwable)new IllegalArgumentException(errorMessage);
        }
        return value;
    }

    public final int checkArgumentPositive(int value, @NotNull String errorMessage) {
        Intrinsics.checkParameterIsNotNull((Object)errorMessage, (String)"errorMessage");
        if (value <= 0) {
            throw (Throwable)new IllegalArgumentException(errorMessage);
        }
        return value;
    }

    public final float checkArgumentFinite(float value, @NotNull String valueName) {
        Intrinsics.checkParameterIsNotNull((Object)valueName, (String)"valueName");
        if (Float.isNaN(value)) {
            throw (Throwable)new IllegalArgumentException(valueName + " must not be NaN");
        }
        if (Float.isInfinite(value)) {
            throw (Throwable)new IllegalArgumentException(valueName + " must not be infinite");
        }
        return value;
    }

    public final float checkArgumentInRange(float value, float lower, float upper, @NotNull String valueName) {
        Intrinsics.checkParameterIsNotNull((Object)valueName, (String)"valueName");
        if (Float.isNaN(value)) {
            throw (Throwable)new IllegalArgumentException(valueName + " must not be NaN");
        }
        if (value < lower) {
            String string;
            StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
            Locale locale = Locale.US;
            Intrinsics.checkExpressionValueIsNotNull((Object)locale, (String)"Locale.US");
            Locale locale2 = locale;
            String string2 = "%s is out of range of [%f, %f] (too low)";
            Object[] objectArray = new Object[]{valueName, Float.valueOf(lower), Float.valueOf(upper)};
            String string3 = String.format(locale2, string2, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"java.lang.String.format(locale, format, *args)");
            String string4 = string = string3;
            throw (Throwable)new IllegalArgumentException(string4);
        }
        if (value > upper) {
            String string;
            StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
            Locale locale = Locale.US;
            Intrinsics.checkExpressionValueIsNotNull((Object)locale, (String)"Locale.US");
            Locale locale3 = locale;
            String string5 = "%s is out of range of [%f, %f] (too high)";
            Object[] objectArray = new Object[]{valueName, Float.valueOf(lower), Float.valueOf(upper)};
            String string6 = String.format(locale3, string5, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkExpressionValueIsNotNull((Object)string6, (String)"java.lang.String.format(locale, format, *args)");
            String string7 = string = string6;
            throw (Throwable)new IllegalArgumentException(string7);
        }
        return value;
    }

    public final int checkArgumentInRange(int value, int lower, int upper, @NotNull String valueName) {
        Intrinsics.checkParameterIsNotNull((Object)valueName, (String)"valueName");
        if (value < lower) {
            String string;
            StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
            Locale locale = Locale.US;
            Intrinsics.checkExpressionValueIsNotNull((Object)locale, (String)"Locale.US");
            Locale locale2 = locale;
            String string2 = "%s is out of range of [%d, %d] (too low)";
            Object[] objectArray = new Object[]{valueName, lower, upper};
            String string3 = String.format(locale2, string2, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"java.lang.String.format(locale, format, *args)");
            String string4 = string = string3;
            throw (Throwable)new IllegalArgumentException(string4);
        }
        if (value > upper) {
            String string;
            StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
            Locale locale = Locale.US;
            Intrinsics.checkExpressionValueIsNotNull((Object)locale, (String)"Locale.US");
            Locale locale3 = locale;
            String string5 = "%s is out of range of [%d, %d] (too high)";
            Object[] objectArray = new Object[]{valueName, lower, upper};
            String string6 = String.format(locale3, string5, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkExpressionValueIsNotNull((Object)string6, (String)"java.lang.String.format(locale, format, *args)");
            String string7 = string = string6;
            throw (Throwable)new IllegalArgumentException(string7);
        }
        return value;
    }

    public final long checkArgumentInRange(long value, long lower, long upper, @NotNull String valueName) {
        Intrinsics.checkParameterIsNotNull((Object)valueName, (String)"valueName");
        if (value < lower) {
            String string;
            StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
            Locale locale = Locale.US;
            Intrinsics.checkExpressionValueIsNotNull((Object)locale, (String)"Locale.US");
            Locale locale2 = locale;
            String string2 = "%s is out of range of [%d, %d] (too low)";
            Object[] objectArray = new Object[]{valueName, lower, upper};
            String string3 = String.format(locale2, string2, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"java.lang.String.format(locale, format, *args)");
            String string4 = string = string3;
            throw (Throwable)new IllegalArgumentException(string4);
        }
        if (value > upper) {
            String string;
            StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
            Locale locale = Locale.US;
            Intrinsics.checkExpressionValueIsNotNull((Object)locale, (String)"Locale.US");
            Locale locale3 = locale;
            String string5 = "%s is out of range of [%d, %d] (too high)";
            Object[] objectArray = new Object[]{valueName, lower, upper};
            String string6 = String.format(locale3, string5, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkExpressionValueIsNotNull((Object)string6, (String)"java.lang.String.format(locale, format, *args)");
            String string7 = string = string6;
            throw (Throwable)new IllegalArgumentException(string7);
        }
        return value;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final <T> T[] checkArrayElementsNotNull(@Nullable T[] value, @NotNull String valueName) {
        Intrinsics.checkParameterIsNotNull((Object)valueName, (String)"valueName");
        if (value == null) {
            throw (Throwable)new NullPointerException(valueName + " must not be null");
        }
        int n = 0;
        int n2 = value.length;
        while (n < n2) {
            void i;
            if (value[i] == null) {
                String string;
                StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
                Locale locale = Locale.US;
                Intrinsics.checkExpressionValueIsNotNull((Object)locale, (String)"Locale.US");
                Locale locale2 = locale;
                String string2 = "%s[%d] must not be null";
                Object[] objectArray = new Object[]{valueName, (int)i};
                String string3 = String.format(locale2, string2, Arrays.copyOf(objectArray, objectArray.length));
                Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"java.lang.String.format(locale, format, *args)");
                String string4 = string = string3;
                throw (Throwable)new NullPointerException(string4);
            }
            ++i;
        }
        return value;
    }

    @NotNull
    public final <C extends Collection<? extends T>, T> C checkCollectionElementsNotNull(@Nullable C value, @NotNull String valueName) {
        Intrinsics.checkParameterIsNotNull((Object)valueName, (String)"valueName");
        if (value == null) {
            throw (Throwable)new NullPointerException(valueName + " must not be null");
        }
        long ctr = 0L;
        for (T elem : value) {
            if (elem == null) {
                String string;
                StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
                Locale locale = Locale.US;
                Intrinsics.checkExpressionValueIsNotNull((Object)locale, (String)"Locale.US");
                Locale locale2 = locale;
                String string2 = "%s[%d] must not be null";
                Object[] objectArray = new Object[]{valueName, ctr};
                String string3 = String.format(locale2, string2, Arrays.copyOf(objectArray, objectArray.length));
                Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"java.lang.String.format(locale, format, *args)");
                String string4 = string = string3;
                throw (Throwable)new NullPointerException(string4);
            }
            ++ctr;
        }
        return value;
    }

    @NotNull
    public final <T> Collection<T> checkCollectionNotEmpty(@Nullable Collection<? extends T> value, @NotNull String valueName) {
        Intrinsics.checkParameterIsNotNull((Object)valueName, (String)"valueName");
        if (value == null) {
            throw (Throwable)new NullPointerException(valueName + " must not be null");
        }
        if (value.isEmpty()) {
            throw (Throwable)new IllegalArgumentException(valueName + " is empty");
        }
        return value;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final float[] checkArrayElementsInRange(@NotNull float[] value, float lower, float upper, @NotNull String valueName) {
        Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
        Intrinsics.checkParameterIsNotNull((Object)valueName, (String)"valueName");
        this.checkNotNull(value, valueName + " must not be null");
        int n = 0;
        int n2 = value.length;
        while (n < n2) {
            void i;
            float v = value[i];
            if (Float.isNaN(v)) {
                throw (Throwable)new IllegalArgumentException(valueName + '[' + (int)i + "] must not be NaN");
            }
            if (v < lower) {
                String string;
                StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
                Locale locale = Locale.US;
                Intrinsics.checkExpressionValueIsNotNull((Object)locale, (String)"Locale.US");
                Locale locale2 = locale;
                String string2 = "%s[%d] is out of range of [%f, %f] (too low)";
                Object[] objectArray = new Object[]{valueName, (int)i, Float.valueOf(lower), Float.valueOf(upper)};
                String string3 = String.format(locale2, string2, Arrays.copyOf(objectArray, objectArray.length));
                Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"java.lang.String.format(locale, format, *args)");
                String string4 = string = string3;
                throw (Throwable)new IllegalArgumentException(string4);
            }
            if (v > upper) {
                String string;
                StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
                Locale locale = Locale.US;
                Intrinsics.checkExpressionValueIsNotNull((Object)locale, (String)"Locale.US");
                Locale locale3 = locale;
                String string5 = "%s[%d] is out of range of [%f, %f] (too high)";
                Object[] objectArray = new Object[]{valueName, (int)i, Float.valueOf(lower), Float.valueOf(upper)};
                String string6 = String.format(locale3, string5, Arrays.copyOf(objectArray, objectArray.length));
                Intrinsics.checkExpressionValueIsNotNull((Object)string6, (String)"java.lang.String.format(locale, format, *args)");
                String string7 = string = string6;
                throw (Throwable)new IllegalArgumentException(string7);
            }
            ++i;
        }
        return value;
    }

    private Preconditions() {
    }

    static {
        Preconditions preconditions;
        INSTANCE = preconditions = new Preconditions();
    }
}

