/*
 * Decompiled with CFR 0.152.
 */
package com.runningmessage.kotlinx.widget;

import android.animation.Animator;
import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.content.Context;
import android.content.res.Resources;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.drawable.Animatable;
import android.graphics.drawable.Drawable;
import android.support.annotation.RestrictTo;
import android.support.v4.view.animation.FastOutSlowInInterpolator;
import android.util.DisplayMetrics;
import android.view.animation.LinearInterpolator;
import com.runningmessage.kotlinx.widget.Preconditions;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\u0007\n\u0002\b\n\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0010\u0015\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\t\n\u0002\b\u0007\u0018\u0000 c2\u00020\u00012\u00020\u0002:\u0003cdeB\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0018\u0010?\u001a\u00020@2\u0006\u0010A\u001a\u00020\u000e2\u0006\u0010B\u001a\u00020.H\u0002J \u0010C\u001a\u00020@2\u0006\u0010A\u001a\u00020\u000e2\u0006\u0010B\u001a\u00020.2\u0006\u0010D\u001a\u00020\u0007H\u0002J\u0010\u0010E\u001a\u00020@2\u0006\u0010F\u001a\u00020GH\u0016J \u0010H\u001a\u00020\u00192\u0006\u0010I\u001a\u00020\u000e2\u0006\u0010J\u001a\u00020\u00192\u0006\u0010K\u001a\u00020\u0019H\u0002J\b\u0010L\u001a\u00020\u0019H\u0016J\b\u0010M\u001a\u00020\u0019H\u0016J\b\u0010N\u001a\u00020\u0007H\u0016J\u0010\u0010O\u001a\u00020@2\u0006\u0010P\u001a\u00020\u0019H\u0016J\u0016\u0010Q\u001a\u00020@2\u0006\u0010R\u001a\u00020\u000e2\u0006\u0010S\u001a\u00020\u000eJ\u0012\u0010T\u001a\u00020@2\b\u0010U\u001a\u0004\u0018\u00010VH\u0016J\u0012\u0010W\u001a\u00020@2\n\u0010X\u001a\u00020#\"\u00020\u0019J(\u0010Y\u001a\u00020@2\u0006\u0010\u001f\u001a\u00020\u000e2\u0006\u0010<\u001a\u00020\u000e2\u0006\u0010\u0016\u001a\u00020\u000e2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0016\u0010Z\u001a\u00020@2\u0006\u0010[\u001a\u00020\u000e2\u0006\u0010\\\u001a\u00020\u000eJ\u0010\u0010]\u001a\u00020@2\b\b\u0001\u0010^\u001a\u00020_J\b\u0010`\u001a\u00020@H\u0002J\b\u0010[\u001a\u00020@H\u0016J\b\u0010a\u001a\u00020@H\u0016J\u0018\u0010b\u001a\u00020@2\u0006\u0010A\u001a\u00020\u000e2\u0006\u0010B\u001a\u00020.H\u0002R$\u0010\b\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\u00078F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u0011\u0010\r\u001a\u00020\u000e8F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R$\u0010\u0012\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u000e8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u0013\u0010\u0010\"\u0004\b\u0014\u0010\u0015R\u0011\u0010\u0016\u001a\u00020\u000e8F\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0010R$\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u0018\u001a\u00020\u00198F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u001b\u0010\u001c\"\u0004\b\u001d\u0010\u001eR$\u0010\u001f\u001a\u00020\u000e2\u0006\u0010\u001f\u001a\u00020\u000e8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b \u0010\u0010\"\u0004\b!\u0010\u0015R\u0011\u0010\"\u001a\u00020#8F\u00a2\u0006\u0006\u001a\u0004\b$\u0010%R\u0011\u0010&\u001a\u00020\u000e8F\u00a2\u0006\u0006\u001a\u0004\b'\u0010\u0010R\u0010\u0010(\u001a\u0004\u0018\u00010)X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010*\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010+\u001a\u00020,X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010-\u001a\u00020.X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010/\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R$\u00101\u001a\u00020\u000e2\u0006\u00100\u001a\u00020\u000e8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b2\u0010\u0010\"\u0004\b3\u0010\u0015R\u000e\u00100\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u00104\u001a\u00020\u000e8F\u00a2\u0006\u0006\u001a\u0004\b5\u0010\u0010R$\u00106\u001a\u0002072\u0006\u00106\u001a\u0002078F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b8\u00109\"\u0004\b:\u0010;R$\u0010<\u001a\u00020\u000e2\u0006\u0010<\u001a\u00020\u000e8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b=\u0010\u0010\"\u0004\b>\u0010\u0015\u00a8\u0006f"}, d2={"Lcom/runningmessage/kotlinx/widget/CircularProgressDrawable;", "Landroid/graphics/drawable/Drawable;", "Landroid/graphics/drawable/Animatable;", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "show", "", "arrowEnabled", "getArrowEnabled", "()Z", "setArrowEnabled", "(Z)V", "arrowHeight", "", "getArrowHeight", "()F", "scale", "arrowScale", "getArrowScale", "setArrowScale", "(F)V", "arrowWidth", "getArrowWidth", "color", "", "backgroundColor", "getBackgroundColor", "()I", "setBackgroundColor", "(I)V", "centerRadius", "getCenterRadius", "setCenterRadius", "colorSchemeColors", "", "getColorSchemeColors", "()[I", "endTrim", "getEndTrim", "mAnimator", "Landroid/animation/Animator;", "mFinishing", "mResources", "Landroid/content/res/Resources;", "mRing", "Lcom/runningmessage/kotlinx/widget/CircularProgressDrawable$Ring;", "mRotationCount", "rotation", "progressRotation", "getProgressRotation", "setProgressRotation", "startTrim", "getStartTrim", "strokeCap", "Landroid/graphics/Paint$Cap;", "getStrokeCap", "()Landroid/graphics/Paint$Cap;", "setStrokeCap", "(Landroid/graphics/Paint$Cap;)V", "strokeWidth", "getStrokeWidth", "setStrokeWidth", "applyFinishTranslation", "", "interpolatedTime", "ring", "applyTransformation", "lastFrame", "draw", "canvas", "Landroid/graphics/Canvas;", "evaluateColorChange", "fraction", "startValue", "endValue", "getAlpha", "getOpacity", "isRunning", "setAlpha", "alpha", "setArrowDimensions", "width", "height", "setColorFilter", "colorFilter", "Landroid/graphics/ColorFilter;", "setColorSchemeColors", "colors", "setSizeParameters", "setStartEndTrim", "start", "end", "setStyle", "size", "", "setupAnimators", "stop", "updateRingColor", "Companion", "ProgressDrawableSize", "Ring", "kotlinx-widget_release"})
public final class CircularProgressDrawable
extends Drawable
implements Animatable {
    private final Ring mRing;
    private float rotation;
    private final Resources mResources;
    private Animator mAnimator;
    private float mRotationCount;
    private boolean mFinishing;
    private static final LinearInterpolator LINEAR_INTERPOLATOR;
    private static final FastOutSlowInInterpolator MATERIAL_INTERPOLATOR;
    public static final long LARGE = 1L;
    private static final float CENTER_RADIUS_LARGE = 11.0f;
    private static final float STROKE_WIDTH_LARGE = 3.0f;
    private static final int ARROW_WIDTH_LARGE = 12;
    private static final int ARROW_HEIGHT_LARGE = 6;
    public static final long DEFAULT = 0L;
    private static final float CENTER_RADIUS = 7.5f;
    private static final float STROKE_WIDTH = 2.5f;
    private static final int ARROW_WIDTH = 10;
    private static final int ARROW_HEIGHT = 5;
    private static final int[] COLORS;
    private static final float COLOR_CHANGE_OFFSET = 0.75f;
    private static final float SHRINK_OFFSET = 0.5f;
    private static final int ANIMATION_DURATION = 1332;
    private static final float GROUP_FULL_ROTATION = 216.0f;
    private static final float MAX_PROGRESS_ARC = 0.8f;
    private static final float MIN_PROGRESS_ARC = 0.01f;
    private static final float RING_ROTATION = 0.20999998f;
    public static final Companion Companion;

    public final float getStrokeWidth() {
        return this.mRing.getStrokeWidth$kotlinx_widget_release();
    }

    public final void setStrokeWidth(float strokeWidth) {
        this.mRing.setStrokeWidth$kotlinx_widget_release(strokeWidth);
        this.invalidateSelf();
    }

    public final float getCenterRadius() {
        return this.mRing.getCenterRadius$kotlinx_widget_release();
    }

    public final void setCenterRadius(float centerRadius) {
        this.mRing.setCenterRadius$kotlinx_widget_release(centerRadius);
        this.invalidateSelf();
    }

    @NotNull
    public final Paint.Cap getStrokeCap() {
        return this.mRing.getStrokeCap$kotlinx_widget_release();
    }

    public final void setStrokeCap(@NotNull Paint.Cap strokeCap) {
        Intrinsics.checkParameterIsNotNull((Object)strokeCap, (String)"strokeCap");
        this.mRing.setStrokeCap$kotlinx_widget_release(strokeCap);
        this.invalidateSelf();
    }

    public final float getArrowWidth() {
        return this.mRing.getArrowWidth$kotlinx_widget_release();
    }

    public final float getArrowHeight() {
        return this.mRing.getArrowHeight$kotlinx_widget_release();
    }

    public final boolean getArrowEnabled() {
        return this.mRing.getShowArrow$kotlinx_widget_release();
    }

    public final void setArrowEnabled(boolean show) {
        this.mRing.setShowArrow$kotlinx_widget_release(show);
        this.invalidateSelf();
    }

    public final float getArrowScale() {
        return this.mRing.getArrowScale$kotlinx_widget_release();
    }

    public final void setArrowScale(float scale) {
        this.mRing.setArrowScale$kotlinx_widget_release(scale);
        this.invalidateSelf();
    }

    public final float getStartTrim() {
        return this.mRing.getStartTrim$kotlinx_widget_release();
    }

    public final float getEndTrim() {
        return this.mRing.getEndTrim$kotlinx_widget_release();
    }

    public final float getProgressRotation() {
        return this.mRing.getRotation$kotlinx_widget_release();
    }

    public final void setProgressRotation(float rotation) {
        this.mRing.setRotation$kotlinx_widget_release(rotation);
        this.invalidateSelf();
    }

    public final int getBackgroundColor() {
        return this.mRing.getBackgroundColor$kotlinx_widget_release();
    }

    public final void setBackgroundColor(int color) {
        this.mRing.setBackgroundColor$kotlinx_widget_release(color);
        this.invalidateSelf();
    }

    @NotNull
    public final int[] getColorSchemeColors() {
        return this.mRing.getColors$kotlinx_widget_release();
    }

    private final void setSizeParameters(float centerRadius, float strokeWidth, float arrowWidth, float arrowHeight) {
        Ring ring = this.mRing;
        DisplayMetrics metrics = this.mResources.getDisplayMetrics();
        float screenDensity = metrics.density;
        ring.setStrokeWidth$kotlinx_widget_release(strokeWidth * screenDensity);
        ring.setCenterRadius$kotlinx_widget_release(centerRadius * screenDensity);
        ring.setColorIndex$kotlinx_widget_release(0);
        ring.setArrowDimensions$kotlinx_widget_release(arrowWidth * screenDensity, arrowHeight * screenDensity);
    }

    public final void setStyle(long size) {
        if (size == 1L) {
            this.setSizeParameters(CENTER_RADIUS_LARGE, STROKE_WIDTH_LARGE, ARROW_WIDTH_LARGE, ARROW_HEIGHT_LARGE);
        } else {
            this.setSizeParameters(CENTER_RADIUS, STROKE_WIDTH, ARROW_WIDTH, ARROW_HEIGHT);
        }
        this.invalidateSelf();
    }

    public final void setArrowDimensions(float width, float height) {
        this.mRing.setArrowDimensions$kotlinx_widget_release(width, height);
        this.invalidateSelf();
    }

    public final void setStartEndTrim(float start, float end) {
        this.mRing.setStartTrim$kotlinx_widget_release(start);
        this.mRing.setEndTrim$kotlinx_widget_release(end);
        this.invalidateSelf();
    }

    public final void setColorSchemeColors(int ... colors) {
        Intrinsics.checkParameterIsNotNull((Object)colors, (String)"colors");
        this.mRing.setColors$kotlinx_widget_release(colors);
        this.mRing.setColorIndex$kotlinx_widget_release(0);
        this.invalidateSelf();
    }

    public void draw(@NotNull Canvas canvas) {
        Intrinsics.checkParameterIsNotNull((Object)canvas, (String)"canvas");
        Rect bounds = this.getBounds();
        canvas.save();
        canvas.rotate(this.rotation, bounds.exactCenterX(), bounds.exactCenterY());
        Rect rect = bounds;
        Intrinsics.checkExpressionValueIsNotNull((Object)rect, (String)"bounds");
        this.mRing.draw$kotlinx_widget_release(canvas, rect);
        canvas.restore();
    }

    public void setAlpha(int alpha2) {
        this.mRing.setAlpha$kotlinx_widget_release(alpha2);
        this.invalidateSelf();
    }

    public int getAlpha() {
        return this.mRing.getAlpha$kotlinx_widget_release();
    }

    public void setColorFilter(@Nullable ColorFilter colorFilter) {
        this.mRing.setColorFilter$kotlinx_widget_release(colorFilter);
        this.invalidateSelf();
    }

    public int getOpacity() {
        return -3;
    }

    public boolean isRunning() {
        Animator animator = this.mAnimator;
        if (animator == null) {
            Intrinsics.throwNpe();
        }
        return animator.isRunning();
    }

    public void start() {
        Animator animator = this.mAnimator;
        if (animator == null) {
            Intrinsics.throwNpe();
        }
        animator.cancel();
        this.mRing.storeOriginals$kotlinx_widget_release();
        if (this.mRing.getEndTrim$kotlinx_widget_release() != this.mRing.getStartTrim$kotlinx_widget_release()) {
            this.mFinishing = true;
            Animator animator2 = this.mAnimator;
            if (animator2 == null) {
                Intrinsics.throwNpe();
            }
            animator2.setDuration((long)(ANIMATION_DURATION / 2));
            Animator animator3 = this.mAnimator;
            if (animator3 == null) {
                Intrinsics.throwNpe();
            }
            animator3.start();
        } else {
            this.mRing.setColorIndex$kotlinx_widget_release(0);
            this.mRing.resetOriginals$kotlinx_widget_release();
            Animator animator4 = this.mAnimator;
            if (animator4 == null) {
                Intrinsics.throwNpe();
            }
            animator4.setDuration((long)ANIMATION_DURATION);
            Animator animator5 = this.mAnimator;
            if (animator5 == null) {
                Intrinsics.throwNpe();
            }
            animator5.start();
        }
    }

    public void stop() {
        Animator animator = this.mAnimator;
        if (animator == null) {
            Intrinsics.throwNpe();
        }
        animator.cancel();
        this.rotation = 0.0f;
        this.mRing.setShowArrow$kotlinx_widget_release(false);
        this.mRing.setColorIndex$kotlinx_widget_release(0);
        this.mRing.resetOriginals$kotlinx_widget_release();
        this.invalidateSelf();
    }

    private final int evaluateColorChange(float fraction, int startValue, int endValue) {
        int startA = startValue >> 24 & 0xFF;
        int startR = startValue >> 16 & 0xFF;
        int startG = startValue >> 8 & 0xFF;
        int startB = startValue & 0xFF;
        int endA = endValue >> 24 & 0xFF;
        int endR = endValue >> 16 & 0xFF;
        int endG = endValue >> 8 & 0xFF;
        int endB = endValue & 0xFF;
        return startA + (int)(fraction * (float)(endA - startA)) << 24 | startR + (int)(fraction * (float)(endR - startR)) << 16 | startG + (int)(fraction * (float)(endG - startG)) << 8 | startB + (int)(fraction * (float)(endB - startB));
    }

    private final void updateRingColor(float interpolatedTime, Ring ring) {
        if (interpolatedTime > COLOR_CHANGE_OFFSET) {
            ring.setColor$kotlinx_widget_release(this.evaluateColorChange((interpolatedTime - COLOR_CHANGE_OFFSET) / (1.0f - COLOR_CHANGE_OFFSET), ring.getStartingColor$kotlinx_widget_release(), ring.getNextColor$kotlinx_widget_release()));
        } else {
            ring.setColor$kotlinx_widget_release(ring.getStartingColor$kotlinx_widget_release());
        }
    }

    private final void applyFinishTranslation(float interpolatedTime, Ring ring) {
        this.updateRingColor(interpolatedTime, ring);
        float targetRotation = (float)(Math.floor(ring.getStartingRotation$kotlinx_widget_release() / MAX_PROGRESS_ARC) + (double)1.0f);
        float startTrim = ring.getStartingStartTrim$kotlinx_widget_release() + (ring.getStartingEndTrim$kotlinx_widget_release() - MIN_PROGRESS_ARC - ring.getStartingStartTrim$kotlinx_widget_release()) * interpolatedTime;
        ring.setStartTrim$kotlinx_widget_release(startTrim);
        ring.setEndTrim$kotlinx_widget_release(ring.getStartingEndTrim$kotlinx_widget_release());
        float rotation = ring.getStartingRotation$kotlinx_widget_release() + (targetRotation - ring.getStartingRotation$kotlinx_widget_release()) * interpolatedTime;
        ring.setRotation$kotlinx_widget_release(rotation);
    }

    private final void applyTransformation(float interpolatedTime, Ring ring, boolean lastFrame) {
        if (this.mFinishing) {
            this.applyFinishTranslation(interpolatedTime, ring);
        } else if (interpolatedTime != 1.0f || lastFrame) {
            float endTrim;
            float startTrim;
            float scaledTime;
            float startingRotation = ring.getStartingRotation$kotlinx_widget_release();
            if (interpolatedTime < SHRINK_OFFSET) {
                scaledTime = interpolatedTime / SHRINK_OFFSET;
                startTrim = ring.getStartingStartTrim$kotlinx_widget_release();
                endTrim = startTrim + ((MAX_PROGRESS_ARC - MIN_PROGRESS_ARC) * MATERIAL_INTERPOLATOR.getInterpolation(scaledTime) + MIN_PROGRESS_ARC);
            } else {
                scaledTime = (interpolatedTime - SHRINK_OFFSET) / (1.0f - SHRINK_OFFSET);
                endTrim = ring.getStartingStartTrim$kotlinx_widget_release() + (MAX_PROGRESS_ARC - MIN_PROGRESS_ARC);
                startTrim = endTrim - ((MAX_PROGRESS_ARC - MIN_PROGRESS_ARC) * (1.0f - MATERIAL_INTERPOLATOR.getInterpolation(scaledTime)) + MIN_PROGRESS_ARC);
            }
            float rotation = startingRotation + RING_ROTATION * interpolatedTime;
            float groupRotation = GROUP_FULL_ROTATION * (interpolatedTime + this.mRotationCount);
            ring.setStartTrim$kotlinx_widget_release(startTrim);
            ring.setEndTrim$kotlinx_widget_release(endTrim);
            ring.setRotation$kotlinx_widget_release(rotation);
            rotation = groupRotation;
        }
    }

    private final void setupAnimators() {
        Ring ring = this.mRing;
        ValueAnimator animator = ValueAnimator.ofFloat((float[])new float[]{0.0f, 1.0f});
        animator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(this, ring){
            final /* synthetic */ CircularProgressDrawable this$0;
            final /* synthetic */ Ring $ring;

            public final void onAnimationUpdate(ValueAnimator animation) {
                ValueAnimator valueAnimator = animation;
                Intrinsics.checkExpressionValueIsNotNull((Object)valueAnimator, (String)"animation");
                Object object = valueAnimator.getAnimatedValue();
                if (object == null) {
                    throw new TypeCastException("null cannot be cast to non-null type kotlin.Float");
                }
                float interpolatedTime = ((Float)object).floatValue();
                CircularProgressDrawable.access$updateRingColor(this.this$0, interpolatedTime, this.$ring);
                CircularProgressDrawable.access$applyTransformation(this.this$0, interpolatedTime, this.$ring, false);
                this.this$0.invalidateSelf();
            }
            {
                this.this$0 = circularProgressDrawable;
                this.$ring = ring;
            }
        });
        ValueAnimator valueAnimator = animator;
        Intrinsics.checkExpressionValueIsNotNull((Object)valueAnimator, (String)"animator");
        valueAnimator.setRepeatCount(-1);
        animator.setRepeatMode(1);
        animator.setInterpolator((TimeInterpolator)LINEAR_INTERPOLATOR);
        animator.addListener(new Animator.AnimatorListener(this, ring){
            final /* synthetic */ CircularProgressDrawable this$0;
            final /* synthetic */ Ring $ring;

            public void onAnimationStart(@NotNull Animator animator) {
                Intrinsics.checkParameterIsNotNull((Object)animator, (String)"animator");
                CircularProgressDrawable.access$setMRotationCount$p(this.this$0, 0.0f);
            }

            public void onAnimationEnd(@NotNull Animator animator) {
                Intrinsics.checkParameterIsNotNull((Object)animator, (String)"animator");
            }

            public void onAnimationCancel(@NotNull Animator animation) {
                Intrinsics.checkParameterIsNotNull((Object)animation, (String)"animation");
            }

            public void onAnimationRepeat(@NotNull Animator animator) {
                Intrinsics.checkParameterIsNotNull((Object)animator, (String)"animator");
                CircularProgressDrawable.access$applyTransformation(this.this$0, 1.0f, this.$ring, true);
                this.$ring.storeOriginals$kotlinx_widget_release();
                this.$ring.goToNextColor$kotlinx_widget_release();
                if (CircularProgressDrawable.access$getMFinishing$p(this.this$0)) {
                    CircularProgressDrawable.access$setMFinishing$p(this.this$0, false);
                    animator.cancel();
                    animator.setDuration((long)CircularProgressDrawable.access$getANIMATION_DURATION$cp());
                    animator.start();
                    this.$ring.setShowArrow$kotlinx_widget_release(false);
                } else {
                    CircularProgressDrawable.access$setMRotationCount$p(this.this$0, CircularProgressDrawable.access$getMRotationCount$p(this.this$0) + 1.0f);
                }
            }
            {
                this.this$0 = $outer;
                this.$ring = $captured_local_variable$1;
            }
        });
        this.mAnimator = (Animator)animator;
    }

    public CircularProgressDrawable(@NotNull Context context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Resources resources = Preconditions.INSTANCE.checkNotNull(context).getResources();
        Intrinsics.checkExpressionValueIsNotNull((Object)resources, (String)"Preconditions.checkNotNull(context).resources");
        this.mResources = resources;
        this.mRing = new Ring();
        this.mRing.setColors$kotlinx_widget_release(COLORS);
        this.setStrokeWidth(STROKE_WIDTH);
        this.setupAnimators();
    }

    static {
        Companion = new Companion(null);
        LINEAR_INTERPOLATOR = new LinearInterpolator();
        MATERIAL_INTERPOLATOR = new FastOutSlowInInterpolator();
        CENTER_RADIUS_LARGE = 11.0f;
        STROKE_WIDTH_LARGE = 3.0f;
        ARROW_WIDTH_LARGE = 12;
        ARROW_HEIGHT_LARGE = 6;
        CENTER_RADIUS = 7.5f;
        STROKE_WIDTH = 2.5f;
        ARROW_WIDTH = 10;
        ARROW_HEIGHT = 5;
        COLORS = new int[]{-16777216};
        COLOR_CHANGE_OFFSET = 0.75f;
        SHRINK_OFFSET = 0.5f;
        ANIMATION_DURATION = 1332;
        GROUP_FULL_ROTATION = 216.0f;
        MAX_PROGRESS_ARC = 0.8f;
        MIN_PROGRESS_ARC = 0.01f;
        RING_ROTATION = 1.0f - (MAX_PROGRESS_ARC - MIN_PROGRESS_ARC);
    }

    public static final /* synthetic */ void access$updateRingColor(CircularProgressDrawable $this, float interpolatedTime, @NotNull Ring ring) {
        $this.updateRingColor(interpolatedTime, ring);
    }

    public static final /* synthetic */ void access$applyTransformation(CircularProgressDrawable $this, float interpolatedTime, @NotNull Ring ring, boolean lastFrame) {
        $this.applyTransformation(interpolatedTime, ring, lastFrame);
    }

    public static final /* synthetic */ float access$getMRotationCount$p(CircularProgressDrawable $this) {
        return $this.mRotationCount;
    }

    public static final /* synthetic */ void access$setMRotationCount$p(CircularProgressDrawable $this, float f) {
        $this.mRotationCount = f;
    }

    public static final /* synthetic */ boolean access$getMFinishing$p(CircularProgressDrawable $this) {
        return $this.mFinishing;
    }

    public static final /* synthetic */ void access$setMFinishing$p(CircularProgressDrawable $this, boolean bl) {
        $this.mFinishing = bl;
    }

    public static final /* synthetic */ int access$getANIMATION_DURATION$cp() {
        return ANIMATION_DURATION;
    }

    @Retention(value=RetentionPolicy.SOURCE)
    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\n\n\u0002\u0018\u0002\n\u0002\u0010\u001b\n\u0000\b\u0087\u0002\u0018\u00002\u00020\u0001B\u0000\u00a8\u0006\u0002"}, d2={"Lcom/runningmessage/kotlinx/widget/CircularProgressDrawable$ProgressDrawableSize;", "", "kotlinx-widget_release"})
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static @interface ProgressDrawableSize {
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0007\n\u0002\b\u0011\n\u0002\u0010\u0015\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0016\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u001c\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0011\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0000\u00a2\u0006\u0002\u0010\u0002J\u001d\u0010s\u001a\u00020t2\u0006\u0010u\u001a\u00020v2\u0006\u0010w\u001a\u00020xH\u0000\u00a2\u0006\u0002\byJ-\u0010z\u001a\u00020t2\u0006\u0010u\u001a\u00020v2\u0006\u0010{\u001a\u00020\n2\u0006\u0010|\u001a\u00020\n2\u0006\u0010w\u001a\u00020NH\u0000\u00a2\u0006\u0002\b}J\r\u0010~\u001a\u00020tH\u0000\u00a2\u0006\u0002\b\u007fJ\u000f\u0010\u0080\u0001\u001a\u00020tH\u0000\u00a2\u0006\u0003\b\u0081\u0001J!\u0010\u0082\u0001\u001a\u00020t2\u0007\u0010\u0083\u0001\u001a\u00020\n2\u0007\u0010\u0084\u0001\u001a\u00020\nH\u0000\u00a2\u0006\u0003\b\u0085\u0001J\u0017\u0010\u0086\u0001\u001a\u00020t2\u0006\u0010\u0014\u001a\u00020\u0004H\u0000\u00a2\u0006\u0003\b\u0087\u0001J\u001b\u0010\u0088\u0001\u001a\u00020t2\n\u0010\u0089\u0001\u001a\u0005\u0018\u00010\u008a\u0001H\u0000\u00a2\u0006\u0003\b\u008b\u0001J\u0018\u0010\u008c\u0001\u001a\u00020t2\u0007\u0010\u008d\u0001\u001a\u00020\u0004H\u0000\u00a2\u0006\u0003\b\u008e\u0001J\u000f\u0010\u008f\u0001\u001a\u00020tH\u0000\u00a2\u0006\u0003\b\u0090\u0001R\u001a\u0010\u0003\u001a\u00020\u0004X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\n8@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR$\u0010\u000e\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\n8@@@X\u0080\u000e\u00a2\u0006\f\u001a\u0004\b\u000f\u0010\f\"\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0012\u001a\u00020\n8@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\fR$\u0010\u0015\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\u00048@@@X\u0080\u000e\u00a2\u0006\f\u001a\u0004\b\u0016\u0010\u0006\"\u0004\b\u0017\u0010\bR\u001a\u0010\u0018\u001a\u00020\nX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\f\"\u0004\b\u001a\u0010\u0011R$\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001b\u001a\u00020\u001c8@@@X\u0080\u000e\u00a2\u0006\f\u001a\u0004\b\u001d\u0010\u001e\"\u0004\b\u001f\u0010 R\u001a\u0010!\u001a\u00020\nX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\"\u0010\f\"\u0004\b#\u0010\u0011R\u001c\u0010$\u001a\u0004\u0018\u00010%X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b&\u0010'\"\u0004\b(\u0010)R\u001a\u0010*\u001a\u00020\u0004X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b+\u0010\u0006\"\u0004\b,\u0010\bR\u0014\u0010-\u001a\u00020.X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b/\u00100R\u001a\u00101\u001a\u00020\nX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b2\u0010\f\"\u0004\b3\u0010\u0011R\u001a\u00104\u001a\u00020\u0004X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b5\u0010\u0006\"\u0004\b6\u0010\bR\u0014\u00107\u001a\u00020.X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b8\u00100R\u001a\u00109\u001a\u00020\u0004X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b:\u0010\u0006\"\u0004\b;\u0010\bR\u001a\u0010<\u001a\u00020\u001cX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b=\u0010\u001e\"\u0004\b>\u0010 R\u001a\u0010?\u001a\u00020\u0004X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b@\u0010\u0006\"\u0004\bA\u0010\bR\u0014\u0010B\u001a\u00020.X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\bC\u00100R\u001a\u0010D\u001a\u00020EX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bF\u0010G\"\u0004\bH\u0010IR\u001a\u0010J\u001a\u00020\nX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bK\u0010\f\"\u0004\bL\u0010\u0011R\u0014\u0010M\u001a\u00020NX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\bO\u0010PR\u0014\u0010Q\u001a\u00020\u00048@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\bR\u0010\u0006R\u0014\u0010S\u001a\u00020\u00048@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\bT\u0010\u0006R\u001a\u0010U\u001a\u00020\nX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bV\u0010\f\"\u0004\bW\u0010\u0011R$\u0010Y\u001a\u00020E2\u0006\u0010X\u001a\u00020E8@@@X\u0080\u000e\u00a2\u0006\f\u001a\u0004\bZ\u0010G\"\u0004\b[\u0010IR\u001a\u0010\\\u001a\u00020\nX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b]\u0010\f\"\u0004\b^\u0010\u0011R\u0014\u0010_\u001a\u00020\u00048@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b`\u0010\u0006R\u001a\u0010a\u001a\u00020\nX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bb\u0010\f\"\u0004\bc\u0010\u0011R\u001a\u0010d\u001a\u00020\nX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\be\u0010\f\"\u0004\bf\u0010\u0011R\u001a\u0010g\u001a\u00020\nX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bh\u0010\f\"\u0004\bi\u0010\u0011R$\u0010j\u001a\u00020k2\u0006\u0010j\u001a\u00020k8@@@X\u0080\u000e\u00a2\u0006\f\u001a\u0004\bl\u0010m\"\u0004\bn\u0010oR$\u0010p\u001a\u00020\n2\u0006\u0010p\u001a\u00020\n8@@@X\u0080\u000e\u00a2\u0006\f\u001a\u0004\bq\u0010\f\"\u0004\br\u0010\u0011\u00a8\u0006\u0091\u0001"}, d2={"Lcom/runningmessage/kotlinx/widget/CircularProgressDrawable$Ring;", "", "()V", "alpha", "", "getAlpha$kotlinx_widget_release", "()I", "setAlpha$kotlinx_widget_release", "(I)V", "arrowHeight", "", "getArrowHeight$kotlinx_widget_release", "()F", "scale", "arrowScale", "getArrowScale$kotlinx_widget_release", "setArrowScale$kotlinx_widget_release", "(F)V", "arrowWidth", "getArrowWidth$kotlinx_widget_release", "color", "backgroundColor", "getBackgroundColor$kotlinx_widget_release", "setBackgroundColor$kotlinx_widget_release", "centerRadius", "getCenterRadius$kotlinx_widget_release", "setCenterRadius$kotlinx_widget_release", "colors", "", "getColors$kotlinx_widget_release", "()[I", "setColors$kotlinx_widget_release", "([I)V", "endTrim", "getEndTrim$kotlinx_widget_release", "setEndTrim$kotlinx_widget_release", "mArrow", "Landroid/graphics/Path;", "getMArrow$kotlinx_widget_release", "()Landroid/graphics/Path;", "setMArrow$kotlinx_widget_release", "(Landroid/graphics/Path;)V", "mArrowHeight", "getMArrowHeight$kotlinx_widget_release", "setMArrowHeight$kotlinx_widget_release", "mArrowPaint", "Landroid/graphics/Paint;", "getMArrowPaint$kotlinx_widget_release", "()Landroid/graphics/Paint;", "mArrowScale", "getMArrowScale$kotlinx_widget_release", "setMArrowScale$kotlinx_widget_release", "mArrowWidth", "getMArrowWidth$kotlinx_widget_release", "setMArrowWidth$kotlinx_widget_release", "mCirclePaint", "getMCirclePaint$kotlinx_widget_release", "mColorIndex", "getMColorIndex$kotlinx_widget_release", "setMColorIndex$kotlinx_widget_release", "mColors", "getMColors$kotlinx_widget_release", "setMColors$kotlinx_widget_release", "mCurrentColor", "getMCurrentColor$kotlinx_widget_release", "setMCurrentColor$kotlinx_widget_release", "mPaint", "getMPaint$kotlinx_widget_release", "mShowArrow", "", "getMShowArrow$kotlinx_widget_release", "()Z", "setMShowArrow$kotlinx_widget_release", "(Z)V", "mStrokeWidth", "getMStrokeWidth$kotlinx_widget_release", "setMStrokeWidth$kotlinx_widget_release", "mTempBounds", "Landroid/graphics/RectF;", "getMTempBounds$kotlinx_widget_release", "()Landroid/graphics/RectF;", "nextColor", "getNextColor$kotlinx_widget_release", "nextColorIndex", "getNextColorIndex$kotlinx_widget_release", "rotation", "getRotation$kotlinx_widget_release", "setRotation$kotlinx_widget_release", "show", "showArrow", "getShowArrow$kotlinx_widget_release", "setShowArrow$kotlinx_widget_release", "startTrim", "getStartTrim$kotlinx_widget_release", "setStartTrim$kotlinx_widget_release", "startingColor", "getStartingColor$kotlinx_widget_release", "startingEndTrim", "getStartingEndTrim$kotlinx_widget_release", "setStartingEndTrim$kotlinx_widget_release", "startingRotation", "getStartingRotation$kotlinx_widget_release", "setStartingRotation$kotlinx_widget_release", "startingStartTrim", "getStartingStartTrim$kotlinx_widget_release", "setStartingStartTrim$kotlinx_widget_release", "strokeCap", "Landroid/graphics/Paint$Cap;", "getStrokeCap$kotlinx_widget_release", "()Landroid/graphics/Paint$Cap;", "setStrokeCap$kotlinx_widget_release", "(Landroid/graphics/Paint$Cap;)V", "strokeWidth", "getStrokeWidth$kotlinx_widget_release", "setStrokeWidth$kotlinx_widget_release", "draw", "", "c", "Landroid/graphics/Canvas;", "bounds", "Landroid/graphics/Rect;", "draw$kotlinx_widget_release", "drawTriangle", "startAngle", "sweepAngle", "drawTriangle$kotlinx_widget_release", "goToNextColor", "goToNextColor$kotlinx_widget_release", "resetOriginals", "resetOriginals$kotlinx_widget_release", "setArrowDimensions", "width", "height", "setArrowDimensions$kotlinx_widget_release", "setColor", "setColor$kotlinx_widget_release", "setColorFilter", "filter", "Landroid/graphics/ColorFilter;", "setColorFilter$kotlinx_widget_release", "setColorIndex", "index", "setColorIndex$kotlinx_widget_release", "storeOriginals", "storeOriginals$kotlinx_widget_release", "kotlinx-widget_release"})
    private static final class Ring {
        @NotNull
        private final RectF mTempBounds = new RectF();
        @NotNull
        private final Paint mPaint = new Paint();
        @NotNull
        private final Paint mArrowPaint = new Paint();
        @NotNull
        private final Paint mCirclePaint = new Paint();
        private float startTrim;
        private float endTrim;
        private float rotation;
        private float mStrokeWidth = 5.0f;
        @NotNull
        private int[] mColors = new int[0];
        private int mColorIndex;
        private float startingStartTrim;
        private float startingEndTrim;
        private float startingRotation;
        private boolean mShowArrow;
        @Nullable
        private Path mArrow;
        private float mArrowScale = 1.0f;
        private float centerRadius;
        private int mArrowWidth;
        private int mArrowHeight;
        private int alpha = 255;
        private int mCurrentColor;

        @NotNull
        public final RectF getMTempBounds$kotlinx_widget_release() {
            return this.mTempBounds;
        }

        @NotNull
        public final Paint getMPaint$kotlinx_widget_release() {
            return this.mPaint;
        }

        @NotNull
        public final Paint getMArrowPaint$kotlinx_widget_release() {
            return this.mArrowPaint;
        }

        @NotNull
        public final Paint getMCirclePaint$kotlinx_widget_release() {
            return this.mCirclePaint;
        }

        public final float getStartTrim$kotlinx_widget_release() {
            return this.startTrim;
        }

        public final void setStartTrim$kotlinx_widget_release(float f) {
            this.startTrim = f;
        }

        public final float getEndTrim$kotlinx_widget_release() {
            return this.endTrim;
        }

        public final void setEndTrim$kotlinx_widget_release(float f) {
            this.endTrim = f;
        }

        public final float getRotation$kotlinx_widget_release() {
            return this.rotation;
        }

        public final void setRotation$kotlinx_widget_release(float f) {
            this.rotation = f;
        }

        public final float getMStrokeWidth$kotlinx_widget_release() {
            return this.mStrokeWidth;
        }

        public final void setMStrokeWidth$kotlinx_widget_release(float f) {
            this.mStrokeWidth = f;
        }

        @NotNull
        public final int[] getMColors$kotlinx_widget_release() {
            return this.mColors;
        }

        public final void setMColors$kotlinx_widget_release(@NotNull int[] nArray) {
            Intrinsics.checkParameterIsNotNull((Object)nArray, (String)"<set-?>");
            this.mColors = nArray;
        }

        public final int getMColorIndex$kotlinx_widget_release() {
            return this.mColorIndex;
        }

        public final void setMColorIndex$kotlinx_widget_release(int n) {
            this.mColorIndex = n;
        }

        public final float getStartingStartTrim$kotlinx_widget_release() {
            return this.startingStartTrim;
        }

        public final void setStartingStartTrim$kotlinx_widget_release(float f) {
            this.startingStartTrim = f;
        }

        public final float getStartingEndTrim$kotlinx_widget_release() {
            return this.startingEndTrim;
        }

        public final void setStartingEndTrim$kotlinx_widget_release(float f) {
            this.startingEndTrim = f;
        }

        public final float getStartingRotation$kotlinx_widget_release() {
            return this.startingRotation;
        }

        public final void setStartingRotation$kotlinx_widget_release(float f) {
            this.startingRotation = f;
        }

        public final boolean getMShowArrow$kotlinx_widget_release() {
            return this.mShowArrow;
        }

        public final void setMShowArrow$kotlinx_widget_release(boolean bl) {
            this.mShowArrow = bl;
        }

        @Nullable
        public final Path getMArrow$kotlinx_widget_release() {
            return this.mArrow;
        }

        public final void setMArrow$kotlinx_widget_release(@Nullable Path path) {
            this.mArrow = path;
        }

        public final float getMArrowScale$kotlinx_widget_release() {
            return this.mArrowScale;
        }

        public final void setMArrowScale$kotlinx_widget_release(float f) {
            this.mArrowScale = f;
        }

        public final float getCenterRadius$kotlinx_widget_release() {
            return this.centerRadius;
        }

        public final void setCenterRadius$kotlinx_widget_release(float f) {
            this.centerRadius = f;
        }

        public final int getMArrowWidth$kotlinx_widget_release() {
            return this.mArrowWidth;
        }

        public final void setMArrowWidth$kotlinx_widget_release(int n) {
            this.mArrowWidth = n;
        }

        public final int getMArrowHeight$kotlinx_widget_release() {
            return this.mArrowHeight;
        }

        public final void setMArrowHeight$kotlinx_widget_release(int n) {
            this.mArrowHeight = n;
        }

        public final int getAlpha$kotlinx_widget_release() {
            return this.alpha;
        }

        public final void setAlpha$kotlinx_widget_release(int n) {
            this.alpha = n;
        }

        public final int getMCurrentColor$kotlinx_widget_release() {
            return this.mCurrentColor;
        }

        public final void setMCurrentColor$kotlinx_widget_release(int n) {
            this.mCurrentColor = n;
        }

        @NotNull
        public final Paint.Cap getStrokeCap$kotlinx_widget_release() {
            Paint.Cap cap = this.mPaint.getStrokeCap();
            Intrinsics.checkExpressionValueIsNotNull((Object)cap, (String)"mPaint.strokeCap");
            return cap;
        }

        public final void setStrokeCap$kotlinx_widget_release(@NotNull Paint.Cap strokeCap) {
            Intrinsics.checkParameterIsNotNull((Object)strokeCap, (String)"strokeCap");
            this.mPaint.setStrokeCap(strokeCap);
        }

        public final float getArrowWidth$kotlinx_widget_release() {
            return this.mArrowWidth;
        }

        public final float getArrowHeight$kotlinx_widget_release() {
            return this.mArrowHeight;
        }

        @NotNull
        public final int[] getColors$kotlinx_widget_release() {
            return this.mColors;
        }

        public final void setColors$kotlinx_widget_release(@NotNull int[] colors) {
            Intrinsics.checkParameterIsNotNull((Object)colors, (String)"colors");
            this.mColors = colors;
            this.setColorIndex$kotlinx_widget_release(0);
        }

        public final int getBackgroundColor$kotlinx_widget_release() {
            return this.mCirclePaint.getColor();
        }

        public final void setBackgroundColor$kotlinx_widget_release(int color) {
            this.mCirclePaint.setColor(color);
        }

        public final int getNextColor$kotlinx_widget_release() {
            return this.mColors[this.getNextColorIndex$kotlinx_widget_release()];
        }

        public final int getNextColorIndex$kotlinx_widget_release() {
            return (this.mColorIndex + 1) % this.mColors.length;
        }

        public final float getStrokeWidth$kotlinx_widget_release() {
            return this.mStrokeWidth;
        }

        public final void setStrokeWidth$kotlinx_widget_release(float strokeWidth) {
            this.mStrokeWidth = strokeWidth;
            this.mPaint.setStrokeWidth(strokeWidth);
        }

        public final int getStartingColor$kotlinx_widget_release() {
            return this.mColors[this.mColorIndex];
        }

        public final boolean getShowArrow$kotlinx_widget_release() {
            return this.mShowArrow;
        }

        public final void setShowArrow$kotlinx_widget_release(boolean show) {
            if (this.mShowArrow != show) {
                this.mShowArrow = show;
            }
        }

        public final float getArrowScale$kotlinx_widget_release() {
            return this.mArrowScale;
        }

        public final void setArrowScale$kotlinx_widget_release(float scale) {
            if (scale != this.mArrowScale) {
                this.mArrowScale = scale;
            }
        }

        public final void setArrowDimensions$kotlinx_widget_release(float width, float height) {
            this.mArrowWidth = (int)width;
            this.mArrowHeight = (int)height;
        }

        public final void draw$kotlinx_widget_release(@NotNull Canvas c, @NotNull Rect bounds) {
            Intrinsics.checkParameterIsNotNull((Object)c, (String)"c");
            Intrinsics.checkParameterIsNotNull((Object)bounds, (String)"bounds");
            RectF arcBounds = this.mTempBounds;
            float arcRadius = this.centerRadius + this.mStrokeWidth / 2.0f;
            if (this.centerRadius <= 0.0f) {
                arcRadius = (float)Math.min(bounds.width(), bounds.height()) / 2.0f - Math.max((float)this.mArrowWidth * this.mArrowScale / 2.0f, this.mStrokeWidth / 2.0f);
            }
            arcBounds.set((float)bounds.centerX() - arcRadius, (float)bounds.centerY() - arcRadius, (float)bounds.centerX() + arcRadius, (float)bounds.centerY() + arcRadius);
            float startAngle = (this.startTrim + this.rotation) * (float)360;
            float endAngle = (this.endTrim + this.rotation) * (float)360;
            float sweepAngle = endAngle - startAngle;
            this.mPaint.setColor(this.mCurrentColor);
            this.mPaint.setAlpha(this.alpha);
            float inset = this.mStrokeWidth / 2.0f;
            arcBounds.inset(inset, inset);
            c.drawCircle(arcBounds.centerX(), arcBounds.centerY(), arcBounds.width() / 2.0f, this.mCirclePaint);
            arcBounds.inset(-inset, -inset);
            c.drawArc(arcBounds, startAngle, sweepAngle, false, this.mPaint);
            this.drawTriangle$kotlinx_widget_release(c, startAngle, sweepAngle, arcBounds);
        }

        public final void drawTriangle$kotlinx_widget_release(@NotNull Canvas c, float startAngle, float sweepAngle, @NotNull RectF bounds) {
            Intrinsics.checkParameterIsNotNull((Object)c, (String)"c");
            Intrinsics.checkParameterIsNotNull((Object)bounds, (String)"bounds");
            if (this.mShowArrow) {
                if (this.mArrow == null) {
                    Path path = this.mArrow = new Path();
                    if (path == null) {
                        Intrinsics.throwNpe();
                    }
                    path.setFillType(Path.FillType.EVEN_ODD);
                } else {
                    Path path = this.mArrow;
                    if (path == null) {
                        Intrinsics.throwNpe();
                    }
                    path.reset();
                }
                float centerRadius = Math.min(bounds.width(), bounds.height()) / 2.0f;
                float inset = (float)this.mArrowWidth * this.mArrowScale / 2.0f;
                Path path = this.mArrow;
                if (path == null) {
                    Intrinsics.throwNpe();
                }
                path.moveTo(0.0f, 0.0f);
                Path path2 = this.mArrow;
                if (path2 == null) {
                    Intrinsics.throwNpe();
                }
                path2.lineTo((float)this.mArrowWidth * this.mArrowScale, 0.0f);
                Path path3 = this.mArrow;
                if (path3 == null) {
                    Intrinsics.throwNpe();
                }
                path3.lineTo((float)this.mArrowWidth * this.mArrowScale / (float)2, (float)this.mArrowHeight * this.mArrowScale);
                Path path4 = this.mArrow;
                if (path4 == null) {
                    Intrinsics.throwNpe();
                }
                path4.offset(centerRadius + bounds.centerX() - inset, bounds.centerY() + this.mStrokeWidth / 2.0f);
                Path path5 = this.mArrow;
                if (path5 == null) {
                    Intrinsics.throwNpe();
                }
                path5.close();
                this.mArrowPaint.setColor(this.mCurrentColor);
                this.mArrowPaint.setAlpha(this.alpha);
                c.save();
                c.rotate(startAngle + sweepAngle, bounds.centerX(), bounds.centerY());
                Path path6 = this.mArrow;
                if (path6 == null) {
                    Intrinsics.throwNpe();
                }
                c.drawPath(path6, this.mArrowPaint);
                c.restore();
            }
        }

        public final void setColor$kotlinx_widget_release(int color) {
            this.mCurrentColor = color;
        }

        public final void setColorIndex$kotlinx_widget_release(int index) {
            this.mColorIndex = index;
            this.mCurrentColor = this.mColors[this.mColorIndex];
        }

        public final void goToNextColor$kotlinx_widget_release() {
            this.setColorIndex$kotlinx_widget_release(this.getNextColorIndex$kotlinx_widget_release());
        }

        public final void setColorFilter$kotlinx_widget_release(@Nullable ColorFilter filter) {
            this.mPaint.setColorFilter(filter);
        }

        public final void storeOriginals$kotlinx_widget_release() {
            this.startingStartTrim = this.startTrim;
            this.startingEndTrim = this.endTrim;
            this.startingRotation = this.rotation;
        }

        public final void resetOriginals$kotlinx_widget_release() {
            this.startingStartTrim = 0.0f;
            this.startingEndTrim = 0.0f;
            this.startingRotation = 0.0f;
            this.startTrim = 0.0f;
            this.endTrim = 0.0f;
            this.rotation = 0.0f;
        }

        public Ring() {
            this.mPaint.setStrokeCap(Paint.Cap.SQUARE);
            this.mPaint.setAntiAlias(true);
            this.mPaint.setStyle(Paint.Style.STROKE);
            this.mArrowPaint.setStyle(Paint.Style.FILL);
            this.mArrowPaint.setAntiAlias(true);
            this.mCirclePaint.setColor(0);
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\u0015\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\nX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\nX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\nX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0010X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\nX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\nX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\nX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\nX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\nX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\nX\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcom/runningmessage/kotlinx/widget/CircularProgressDrawable$Companion;", "", "()V", "ANIMATION_DURATION", "", "ARROW_HEIGHT", "ARROW_HEIGHT_LARGE", "ARROW_WIDTH", "ARROW_WIDTH_LARGE", "CENTER_RADIUS", "", "CENTER_RADIUS_LARGE", "COLORS", "", "COLOR_CHANGE_OFFSET", "DEFAULT", "", "GROUP_FULL_ROTATION", "LARGE", "LINEAR_INTERPOLATOR", "Landroid/view/animation/LinearInterpolator;", "MATERIAL_INTERPOLATOR", "Landroid/support/v4/view/animation/FastOutSlowInInterpolator;", "MAX_PROGRESS_ARC", "MIN_PROGRESS_ARC", "RING_ROTATION", "SHRINK_OFFSET", "STROKE_WIDTH", "STROKE_WIDTH_LARGE", "kotlinx-widget_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

