/*
 * Decompiled with CFR 0.152.
 */
package com.runningmessage.kotlinx.widget;

import android.content.Context;
import android.content.res.Resources;
import android.util.DisplayMetrics;
import android.view.WindowManager;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=2, d1={"\u0000\u0018\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\u001a\u0018\u0010\u0003\u001a\u00020\u00012\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0000\u001a\u0010\u0010\b\u001a\u00020\u00012\u0006\u0010\u0004\u001a\u00020\u0005H\u0000\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u000e\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"heightPixels", "", "widthPixels", "dip2px", "context", "Landroid/content/Context;", "dpValue", "", "getScreenWidth", "kotlinx-widget_release"})
public final class DisplayKt {
    private static int heightPixels;
    private static int widthPixels;

    public static final int dip2px(@NotNull Context context, float dpValue) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Resources resources = context.getResources();
        Intrinsics.checkExpressionValueIsNotNull((Object)resources, (String)"context.resources");
        float scale = resources.getDisplayMetrics().density;
        return (int)(dpValue * scale + 0.5f);
    }

    public static final int getScreenWidth(@NotNull Context context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        if (widthPixels == 0 || heightPixels == 0) {
            try {
                DisplayMetrics dm = new DisplayMetrics();
                Object object = context.getSystemService("window");
                if (object == null) {
                    throw new TypeCastException("null cannot be cast to non-null type android.view.WindowManager");
                }
                WindowManager wm = (WindowManager)object;
                wm.getDefaultDisplay().getMetrics(dm);
                widthPixels = dm.widthPixels;
                heightPixels = dm.heightPixels;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        Resources resources = context.getResources();
        Intrinsics.checkExpressionValueIsNotNull((Object)resources, (String)"context.resources");
        return resources.getConfiguration().orientation == 1 ? (widthPixels < heightPixels ? widthPixels : heightPixels) : (widthPixels > heightPixels ? widthPixels : heightPixels);
    }
}

