/*
 * Decompiled with CFR 0.152.
 */
package com.runningmessage.kotlinx.widget;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.RadialGradient;
import android.graphics.Shader;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.ShapeDrawable;
import android.graphics.drawable.shapes.OvalShape;
import android.graphics.drawable.shapes.Shape;
import android.os.Build;
import android.support.annotation.VisibleForTesting;
import android.support.v4.content.ContextCompat;
import android.support.v4.view.ViewCompat;
import android.support.v7.widget.AppCompatImageView;
import android.util.DisplayMetrics;
import android.view.View;
import android.view.animation.Animation;
import android.view.animation.Transformation;
import com.runningmessage.kotlinx.widget.CircularProgressDrawable;
import com.runningmessage.kotlinx.widget.SwipeRefreshProgress;
import com.runningmessage.kotlinx.widget.SwipeRefreshProgressKt;
import java.util.HashMap;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0014\n\u0002\u0010\t\n\u0002\b\u000b\u0018\u0000 C2\u00020\u00012\u00020\u0002:\u0002CDB\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0012\u0010\u001e\u001a\u00020\u001f2\b\u0010 \u001a\u0004\u0018\u00010\fH\u0016J\b\u0010!\u001a\u00020\"H\u0002J\u0018\u0010#\u001a\u00020\u001f2\u0006\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020%H\u0016J\u0012\u0010'\u001a\u00020\"2\b\u0010(\u001a\u0004\u0018\u00010\tH\u0002J0\u0010)\u001a\u00020\u001f2\u0006\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020%2\u0006\u0010*\u001a\u00020%2\u0006\u0010+\u001a\u00020%2\u0006\u0010,\u001a\u00020\u0006H\u0016J\b\u0010-\u001a\u00020\u001fH\u0016J\b\u0010.\u001a\u00020\u001fH\u0016J\u0018\u0010/\u001a\u00020\u001f2\u0006\u00100\u001a\u00020\u00062\u0006\u00101\u001a\u00020\u0006H\u0014J\u0010\u00102\u001a\u00020\u001f2\u0006\u00103\u001a\u00020%H\u0016J\u0012\u00104\u001a\u00020\u001f2\b\u0010 \u001a\u0004\u0018\u00010\fH\u0016J\u0010\u00105\u001a\u00020\u001f2\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u000e\u00106\u001a\u00020\u001f2\u0006\u00107\u001a\u00020\u0006J\u0010\u00108\u001a\u00020\u001f2\u0006\u00109\u001a\u00020:H\u0016J\u0018\u0010;\u001a\u00020\t2\u0006\u0010<\u001a\u00020\u00062\u0006\u0010=\u001a\u00020\u0006H\u0002J\b\u0010>\u001a\u00020\u001fH\u0016J\b\u0010?\u001a\u00020\u001fH\u0016J\b\u0010@\u001a\u00020\u001fH\u0002J\b\u0010A\u001a\u00020\u001fH\u0002J\b\u0010B\u001a\u00020\u001fH\u0016R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0010\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0011\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R$\u0010\u0017\u001a\u00020\u00062\u0006\u0010\u0016\u001a\u00020\u0006@BX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0013\"\u0004\b\u0019\u0010\u0015R\u0014\u0010\u001a\u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u0013R\u0014\u0010\u001c\u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u0013\u00a8\u0006E"}, d2={"Lcom/runningmessage/kotlinx/widget/CircleImageView;", "Landroid/support/v7/widget/AppCompatImageView;", "Lcom/runningmessage/kotlinx/widget/SwipeRefreshProgress;", "context", "Landroid/content/Context;", "color", "", "(Landroid/content/Context;I)V", "mAlphaMaxAnimation", "Landroid/view/animation/Animation;", "mAlphaStartAnimation", "mListener", "Landroid/view/animation/Animation$AnimationListener;", "mMediumAnimationDuration", "mProgress", "Lcom/runningmessage/kotlinx/widget/CircularProgressDrawable;", "mScaleAnimation", "mShadowRadius", "getMShadowRadius", "()I", "setMShadowRadius", "(I)V", "<set-?>", "progressCircleDiameter", "getProgressCircleDiameter", "setProgressCircleDiameter", "viewHeight", "getViewHeight", "viewWidth", "getViewWidth", "autoToAnimRefreshing", "", "listener", "elevationSupported", "", "finishSpinner", "overscrollTop", "", "totalDragDistance", "isAnimationRunning", "animation", "moveSpinner", "adjustedPercent", "tensionPercent", "targetY", "onAnimationEnd", "onAnimationStart", "onMeasure", "widthMeasureSpec", "heightMeasureSpec", "releaseToAnimRefreshing", "interpolatedTime", "setAnimationListener", "setBackgroundColor", "setBackgroundColorRes", "colorRes", "setStyle", "style", "", "startAlphaAnimation", "startingAlpha", "endingAlpha", "startAnimRefreshing", "startDragging", "startProgressAlphaMaxAnimation", "startProgressAlphaStartAnimation", "stopAnimRefreshing", "Companion", "OvalShadow", "kotlinx-widget_release"})
public final class CircleImageView
extends AppCompatImageView
implements SwipeRefreshProgress {
    private Animation.AnimationListener mListener;
    private int mShadowRadius;
    private CircularProgressDrawable mProgress;
    private Animation mScaleAnimation;
    private Animation mAlphaStartAnimation;
    private Animation mAlphaMaxAnimation;
    private int progressCircleDiameter;
    private final int mMediumAnimationDuration;
    private static final int KEY_SHADOW_COLOR = 0x1E000000;
    private static final int FILL_SHADOW_COLOR = 0x3D000000;
    private static final float X_OFFSET = 0.0f;
    private static final float Y_OFFSET = 1.75f;
    private static final float SHADOW_RADIUS = 3.5f;
    private static final int SHADOW_ELEVATION = 4;
    private static final int CIRCLE_BG_LIGHT = -328966;
    private static final int CIRCLE_DIAMETER = 40;
    private static final int CIRCLE_DIAMETER_LARGE = 56;
    private static final int MAX_ALPHA = 255;
    private static final int STARTING_PROGRESS_ALPHA = 76;
    private static final float MAX_PROGRESS_ANGLE = 0.8f;
    private static final int ALPHA_ANIMATION_DURATION = 300;
    public static final Companion Companion = new Companion(null);
    private HashMap _$_findViewCache;

    public final int getMShadowRadius() {
        return this.mShadowRadius;
    }

    public final void setMShadowRadius(int n) {
        this.mShadowRadius = n;
    }

    private final boolean elevationSupported() {
        return Build.VERSION.SDK_INT >= 21;
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        if (!this.elevationSupported()) {
            this.setMeasuredDimension(this.getMeasuredWidth() + this.mShadowRadius * 2, this.getMeasuredHeight() + this.mShadowRadius * 2);
        }
    }

    @Override
    public void setAnimationListener(@Nullable Animation.AnimationListener listener) {
        this.mListener = listener;
    }

    public void onAnimationStart() {
        block0: {
            super.onAnimationStart();
            Animation.AnimationListener animationListener = this.mListener;
            if (animationListener == null) break block0;
            animationListener.onAnimationStart(this.getAnimation());
        }
    }

    public void onAnimationEnd() {
        block0: {
            super.onAnimationEnd();
            Animation.AnimationListener animationListener = this.mListener;
            if (animationListener == null) break block0;
            animationListener.onAnimationEnd(this.getAnimation());
        }
    }

    public final void setBackgroundColorRes(int colorRes) {
        this.setBackgroundColor(ContextCompat.getColor((Context)this.getContext(), (int)colorRes));
    }

    public void setBackgroundColor(int color) {
        if (this.getBackground() instanceof ShapeDrawable) {
            Drawable drawable = this.getBackground();
            if (drawable == null) {
                throw new TypeCastException("null cannot be cast to non-null type android.graphics.drawable.ShapeDrawable");
            }
            Paint paint = ((ShapeDrawable)drawable).getPaint();
            Intrinsics.checkExpressionValueIsNotNull((Object)paint, (String)"(background as ShapeDrawable).paint");
            paint.setColor(color);
        }
    }

    @Override
    public void setStyle(long style) {
        long[] $receiver$iv;
        for (long element$iv : $receiver$iv = SwipeRefreshProgressKt.parseStyle(style)) {
            long styleItem = element$iv;
            if ((styleItem & 0xFL) == 0L) continue;
            long progressStyle = styleItem == 2L ? 1L : 0L;
            Resources resources = this.getResources();
            Intrinsics.checkExpressionValueIsNotNull((Object)resources, (String)"resources");
            DisplayMetrics metrics = resources.getDisplayMetrics();
            this.progressCircleDiameter = progressStyle == 1L ? (int)((float)CIRCLE_DIAMETER_LARGE * metrics.density) : (int)((float)CIRCLE_DIAMETER * metrics.density);
            this.setImageDrawable(null);
            CircularProgressDrawable circularProgressDrawable = this.mProgress;
            if (circularProgressDrawable != null) {
                circularProgressDrawable.setStyle(progressStyle);
            }
            this.setImageDrawable(this.mProgress);
        }
    }

    public final int getProgressCircleDiameter() {
        return this.progressCircleDiameter;
    }

    private final void setProgressCircleDiameter(int n) {
        this.progressCircleDiameter = n;
    }

    @Override
    public int getViewWidth() {
        return this.progressCircleDiameter;
    }

    @Override
    public int getViewHeight() {
        return this.progressCircleDiameter;
    }

    @Override
    public void autoToAnimRefreshing(@Nullable Animation.AnimationListener listener) {
        this.setVisibility(0);
        this.mProgress.setAlpha(255);
        Animation animation = this.mScaleAnimation = (Animation)new Animation(this){
            final /* synthetic */ CircleImageView this$0;

            public void applyTransformation(float interpolatedTime, @NotNull Transformation t) {
                Intrinsics.checkParameterIsNotNull((Object)t, (String)"t");
                this.this$0.setScaleX(interpolatedTime);
                this.this$0.setScaleY(interpolatedTime);
            }
            {
                this.this$0 = $outer;
            }
        };
        if (animation == null) {
            Intrinsics.throwNpe();
        }
        animation.setDuration((long)this.mMediumAnimationDuration);
        if (listener != null) {
            this.setAnimationListener(listener);
        }
        this.clearAnimation();
        this.startAnimation(this.mScaleAnimation);
    }

    @Override
    public void releaseToAnimRefreshing(float interpolatedTime) {
        this.mProgress.setArrowScale(1.0f - interpolatedTime);
    }

    @Override
    public void startAnimRefreshing() {
        this.mProgress.setAlpha(255);
        this.mProgress.start();
    }

    @Override
    public void stopAnimRefreshing() {
        this.mProgress.stop();
        Drawable drawable = this.getBackground();
        Intrinsics.checkExpressionValueIsNotNull((Object)drawable, (String)"background");
        drawable.setAlpha(255);
        this.mProgress.setAlpha(255);
    }

    @Override
    public void startDragging() {
        this.mProgress.setAlpha(76);
    }

    @Override
    public void moveSpinner(float overscrollTop, float totalDragDistance, float adjustedPercent, float tensionPercent, int targetY) {
        this.mProgress.setArrowEnabled(true);
        if (overscrollTop < totalDragDistance) {
            if (this.mProgress.getAlpha() > 76 && !this.isAnimationRunning(this.mAlphaStartAnimation)) {
                this.startProgressAlphaStartAnimation();
            }
        } else if (this.mProgress.getAlpha() < 255 && !this.isAnimationRunning(this.mAlphaMaxAnimation)) {
            this.startProgressAlphaMaxAnimation();
        }
        float strokeStart = adjustedPercent * 0.8f;
        this.mProgress.setStartEndTrim(0.0f, Math.min(0.8f, strokeStart));
        this.mProgress.setArrowScale(Math.min(1.0f, adjustedPercent));
        float rotation = (-0.25f + 0.4f * adjustedPercent + tensionPercent * (float)2) * 0.5f;
        this.mProgress.setProgressRotation(rotation);
    }

    private final boolean isAnimationRunning(Animation animation) {
        return animation != null && animation.hasStarted() && !animation.hasEnded();
    }

    private final void startProgressAlphaStartAnimation() {
        this.mAlphaStartAnimation = this.startAlphaAnimation(this.mProgress.getAlpha(), 76);
    }

    private final void startProgressAlphaMaxAnimation() {
        this.mAlphaMaxAnimation = this.startAlphaAnimation(this.mProgress.getAlpha(), 255);
    }

    private final Animation startAlphaAnimation(int startingAlpha, int endingAlpha) {
        Animation alpha2 = new Animation(this, startingAlpha, endingAlpha){
            final /* synthetic */ CircleImageView this$0;
            final /* synthetic */ int $startingAlpha;
            final /* synthetic */ int $endingAlpha;

            public void applyTransformation(float interpolatedTime, @NotNull Transformation t) {
                Intrinsics.checkParameterIsNotNull((Object)t, (String)"t");
                CircleImageView.access$getMProgress$p(this.this$0).setAlpha((int)((float)this.$startingAlpha + (float)(this.$endingAlpha - this.$startingAlpha) * interpolatedTime));
            }
            {
                this.this$0 = $outer;
                this.$startingAlpha = $captured_local_variable$1;
                this.$endingAlpha = $captured_local_variable$2;
            }
        };
        alpha2.setDuration((long)300);
        this.setAnimationListener(null);
        this.clearAnimation();
        this.startAnimation(alpha2);
        return alpha2;
    }

    @Override
    public void finishSpinner(float overscrollTop, float totalDragDistance) {
        if (!(overscrollTop > totalDragDistance)) {
            this.mProgress.setStartEndTrim(0.0f, 0.0f);
            this.mProgress.setArrowEnabled(false);
        }
    }

    public CircleImageView(@NotNull Context context, int color) {
        ShapeDrawable circle;
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        super(context);
        Context context2 = this.getContext();
        Intrinsics.checkExpressionValueIsNotNull((Object)context2, (String)"getContext()");
        Resources resources = context2.getResources();
        Intrinsics.checkExpressionValueIsNotNull((Object)resources, (String)"getContext().resources");
        float density = resources.getDisplayMetrics().density;
        int shadowYOffset = (int)(density * 1.75f);
        int shadowXOffset = (int)(density * 0.0f);
        this.mShadowRadius = (int)(density * 3.5f);
        if (this.elevationSupported()) {
            circle = new ShapeDrawable((Shape)new OvalShape());
            ViewCompat.setElevation((View)((View)this), (float)((float)4 * density));
        } else {
            OvalShadow oval = new OvalShadow(this.mShadowRadius);
            circle = new ShapeDrawable((Shape)oval);
            this.setLayerType(1, circle.getPaint());
            circle.getPaint().setShadowLayer((float)this.mShadowRadius, (float)shadowXOffset, (float)shadowYOffset, 0x1E000000);
            int padding = this.mShadowRadius;
            this.setPadding(padding, padding, padding, padding);
        }
        Paint paint = circle.getPaint();
        Intrinsics.checkExpressionValueIsNotNull((Object)paint, (String)"circle.paint");
        paint.setColor(color);
        ViewCompat.setBackground((View)((View)this), (Drawable)((Drawable)circle));
        this.mMediumAnimationDuration = this.getResources().getInteger(0x10E0001);
        Resources resources2 = this.getResources();
        Intrinsics.checkExpressionValueIsNotNull((Object)resources2, (String)"resources");
        DisplayMetrics metrics = resources2.getDisplayMetrics();
        this.progressCircleDiameter = (int)((float)CIRCLE_DIAMETER * metrics.density);
        CircularProgressDrawable circularProgressDrawable = this.mProgress = new CircularProgressDrawable(context);
        if (circularProgressDrawable != null) {
            circularProgressDrawable.setStyle(0L);
        }
        this.setImageDrawable(this.mProgress);
    }

    static {
        CIRCLE_DIAMETER = 40;
        CIRCLE_DIAMETER_LARGE = 56;
    }

    @NotNull
    public static final /* synthetic */ CircularProgressDrawable access$getMProgress$p(CircleImageView $this) {
        return $this.mProgress;
    }

    public static final /* synthetic */ void access$setMProgress$p(CircleImageView $this, @NotNull CircularProgressDrawable circularProgressDrawable) {
        $this.mProgress = circularProgressDrawable;
    }

    public View _$_findCachedViewById(int n) {
        View view;
        if (this._$_findViewCache == null) {
            this._$_findViewCache = new HashMap();
        }
        if ((view = (View)this._$_findViewCache.get(n)) == null) {
            view = this.findViewById(n);
            this._$_findViewCache.put(n, view);
        }
        return view;
    }

    public void _$_clearFindViewByIdCache() {
        if (this._$_findViewCache != null) {
            this._$_findViewCache.clear();
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\u0004\b\u0082\u0004\u0018\u00002\u00020\u0001B\u000f\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\bH\u0016J\u0018\u0010\u000e\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0010H\u0014J\u0010\u0010\u0012\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\u0003H\u0002R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/runningmessage/kotlinx/widget/CircleImageView$OvalShadow;", "Landroid/graphics/drawable/shapes/OvalShape;", "shadowRadius", "", "(Lcom/runningmessage/kotlinx/widget/CircleImageView;I)V", "mRadialGradient", "Landroid/graphics/RadialGradient;", "mShadowPaint", "Landroid/graphics/Paint;", "draw", "", "canvas", "Landroid/graphics/Canvas;", "paint", "onResize", "width", "", "height", "updateRadialGradient", "diameter", "kotlinx-widget_release"})
    private final class OvalShadow
    extends OvalShape {
        private RadialGradient mRadialGradient;
        private final Paint mShadowPaint = new Paint();

        protected void onResize(float width, float height) {
            super.onResize(width, height);
            this.updateRadialGradient((int)width);
        }

        public void draw(@NotNull Canvas canvas, @NotNull Paint paint) {
            Intrinsics.checkParameterIsNotNull((Object)canvas, (String)"canvas");
            Intrinsics.checkParameterIsNotNull((Object)paint, (String)"paint");
            int viewWidth = CircleImageView.this.getWidth();
            int viewHeight = CircleImageView.this.getHeight();
            canvas.drawCircle((float)(viewWidth / 2), (float)(viewHeight / 2), (float)(viewWidth / 2), this.mShadowPaint);
            canvas.drawCircle((float)(viewWidth / 2), (float)(viewHeight / 2), (float)(viewWidth / 2 - CircleImageView.this.getMShadowRadius()), paint);
        }

        private final void updateRadialGradient(int diameter) {
            this.mRadialGradient = new RadialGradient((float)(diameter / 2), (float)(diameter / 2), (float)CircleImageView.this.getMShadowRadius(), new int[]{0x3D000000, 0}, null, Shader.TileMode.CLAMP);
            this.mShadowPaint.setShader((Shader)this.mRadialGradient);
        }

        public OvalShadow(int shadowRadius) {
            CircleImageView.this.setMShadowRadius(shadowRadius);
            this.updateRadialGradient((int)this.rect().width());
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\f\n\u0002\u0010\u0007\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0006\u001a\u00020\u00048\u0000X\u0081D\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0007\u0010\u0002\u001a\u0004\b\b\u0010\tR\u001c\u0010\n\u001a\u00020\u00048\u0000X\u0081D\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u000b\u0010\u0002\u001a\u0004\b\f\u0010\tR\u000e\u0010\r\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0011X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0011X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0011X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/runningmessage/kotlinx/widget/CircleImageView$Companion;", "", "()V", "ALPHA_ANIMATION_DURATION", "", "CIRCLE_BG_LIGHT", "CIRCLE_DIAMETER", "CIRCLE_DIAMETER$annotations", "getCIRCLE_DIAMETER$kotlinx_widget_release", "()I", "CIRCLE_DIAMETER_LARGE", "CIRCLE_DIAMETER_LARGE$annotations", "getCIRCLE_DIAMETER_LARGE$kotlinx_widget_release", "FILL_SHADOW_COLOR", "KEY_SHADOW_COLOR", "MAX_ALPHA", "MAX_PROGRESS_ANGLE", "", "SHADOW_ELEVATION", "SHADOW_RADIUS", "STARTING_PROGRESS_ALPHA", "X_OFFSET", "Y_OFFSET", "create", "Lcom/runningmessage/kotlinx/widget/CircleImageView;", "context", "Landroid/content/Context;", "kotlinx-widget_release"})
    public static final class Companion {
        @VisibleForTesting
        public static /* synthetic */ void CIRCLE_DIAMETER$annotations() {
        }

        public final int getCIRCLE_DIAMETER$kotlinx_widget_release() {
            return CIRCLE_DIAMETER;
        }

        @VisibleForTesting
        public static /* synthetic */ void CIRCLE_DIAMETER_LARGE$annotations() {
        }

        public final int getCIRCLE_DIAMETER_LARGE$kotlinx_widget_release() {
            return CIRCLE_DIAMETER_LARGE;
        }

        @NotNull
        public final CircleImageView create(@NotNull Context context) {
            CircleImageView circleImageView;
            Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
            CircleImageView $receiver = circleImageView = new CircleImageView(context, -328966);
            $receiver.setVisibility(8);
            return circleImageView;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

