/*
 * Decompiled with CFR 0.152.
 */
package com.run.utils.reflect;

import android.util.Log;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;

public class JavaCalls {
    private static final String TAG = "JavaCalls";
    private static final Map<Class<?>, Class<?>> PRIMITIVE_MAP = new HashMap();

    public static <T> T getField(Object targetInstance, String fieldName) {
        try {
            return JavaCalls.getFieldOrThrow(targetInstance, fieldName);
        }
        catch (NoSuchFieldException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        return null;
    }

    public static <T> T getFieldOrThrow(Object targetInstance, String fieldName) throws NoSuchFieldException, IllegalAccessException {
        Class<?> cls = targetInstance.getClass();
        Field f = null;
        while (f == null) {
            try {
                f = cls.getDeclaredField(fieldName);
                f.setAccessible(true);
            }
            catch (NoSuchFieldException e) {
                cls = cls.getSuperclass();
            }
            if (cls != null) continue;
            throw new NoSuchFieldException();
        }
        f.setAccessible(true);
        return (T)f.get(targetInstance);
    }

    public static void setField(Object targetInstance, String fieldName, Object val) {
        try {
            JavaCalls.setFieldOrThrow(targetInstance, fieldName, val);
        }
        catch (NoSuchFieldException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
    }

    public static void setFieldOrThrow(Object targetInstance, String fieldName, Object val) throws NoSuchFieldException, IllegalAccessException {
        Class<?> cls = targetInstance.getClass();
        Field f = null;
        while (f == null) {
            try {
                f = cls.getDeclaredField(fieldName);
            }
            catch (NoSuchFieldException e) {
                cls = cls.getSuperclass();
            }
            if (cls != null) continue;
            throw new NoSuchFieldException();
        }
        f.setAccessible(true);
        f.set(targetInstance, val);
    }

    public static <T> T callMethod(Object targetInstance, String methodName, Object ... args) {
        try {
            return JavaCalls.callMethodOrThrow(targetInstance, methodName, args);
        }
        catch (Exception e) {
            Log.w((String)TAG, (String)("Meet exception when call Method '" + methodName + "' in " + targetInstance), (Throwable)e);
            return null;
        }
    }

    public static <T> T callMethodOrThrow(Object targetInstance, String methodName, Object ... args) throws SecurityException, NoSuchMethodException, IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        Class<?> clazz = targetInstance.getClass();
        Method method = JavaCalls.getDeclaredMethod(clazz, methodName, JavaCalls.getParameterTypes(args));
        Object result = method.invoke(targetInstance, JavaCalls.getParameters(args));
        return (T)result;
    }

    public static <T> T callStaticMethod(String className, String methodName, Object ... args) {
        try {
            Class<?> clazz = Class.forName(className);
            return JavaCalls.callStaticMethodOrThrow(clazz, methodName, args);
        }
        catch (Exception e) {
            Log.w((String)TAG, (String)("Meet exception when call Method '" + methodName + "' in " + className), (Throwable)e);
            return null;
        }
    }

    private static Method getDeclaredMethod(Class<?> clazz, String name, Class<?> ... parameterTypes) throws NoSuchMethodException, SecurityException {
        Method[] methods = clazz.getDeclaredMethods();
        Method method = JavaCalls.findMethodByName(methods, name, parameterTypes);
        if (method == null) {
            if (clazz.getSuperclass() != null) {
                return JavaCalls.getDeclaredMethod(clazz.getSuperclass(), name, parameterTypes);
            }
            throw new NoSuchMethodException();
        }
        method.setAccessible(true);
        return method;
    }

    private static Method findMethodByName(Method[] list, String name, Class<?>[] parameterTypes) {
        if (name == null) {
            throw new NullPointerException("Method name must not be null.");
        }
        for (Method method : list) {
            if (!method.getName().equals(name) || !JavaCalls.compareClassLists(method.getParameterTypes(), parameterTypes)) continue;
            return method;
        }
        return null;
    }

    private static boolean compareClassLists(Class<?>[] a, Class<?>[] b) {
        if (a == null) {
            return b == null || b.length == 0;
        }
        if (b == null) {
            return a.length == 0;
        }
        if (a.length != b.length) {
            return false;
        }
        for (int i = 0; i < a.length; ++i) {
            if (a[i].isAssignableFrom(b[i]) || PRIMITIVE_MAP.containsKey(a[i]) && PRIMITIVE_MAP.get(a[i]).equals(PRIMITIVE_MAP.get(b[i]))) continue;
            return false;
        }
        return true;
    }

    public static <T> T callStaticMethodOrThrow(String className, String methodName, Object ... args) throws SecurityException, NoSuchMethodException, IllegalArgumentException, IllegalAccessException, InvocationTargetException, ClassNotFoundException {
        Class<?> clazz = Class.forName(className);
        Method method = JavaCalls.getDeclaredMethod(clazz, methodName, JavaCalls.getParameterTypes(args));
        Object result = method.invoke(null, JavaCalls.getParameters(args));
        return (T)result;
    }

    public static <T> T callStaticMethodOrThrow(Class<?> clazz, String methodName, Object ... args) throws SecurityException, NoSuchMethodException, IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        Method method = JavaCalls.getDeclaredMethod(clazz, methodName, JavaCalls.getParameterTypes(args));
        Object result = method.invoke(null, JavaCalls.getParameters(args));
        return (T)result;
    }

    public static <T> T newInstance(Class<?> clazz, Object ... args) {
        try {
            return JavaCalls.newInstanceOrThrow(clazz, args);
        }
        catch (Exception e) {
            Log.w((String)TAG, (String)("Meet exception when make instance as a " + clazz.getSimpleName()), (Throwable)e);
            return null;
        }
    }

    public static <T> T newEmptyInstance(Class<?> clazz) {
        try {
            return JavaCalls.newEmptyInstanceOrThrow(clazz);
        }
        catch (Exception e) {
            Log.w((String)TAG, (String)("Meet exception when make instance as a " + clazz.getSimpleName()), (Throwable)e);
            return null;
        }
    }

    public static <T> T newEmptyInstanceOrThrow(Class<?> clazz) throws IllegalAccessException, InvocationTargetException, InstantiationException, ClassNotFoundException {
        Constructor<?>[] constructors = clazz.getDeclaredConstructors();
        if (constructors == null || constructors.length == 0) {
            throw new IllegalArgumentException("Can't get even one available constructor for " + clazz);
        }
        Constructor<?> constructor = constructors[0];
        constructor.setAccessible(true);
        Class<?>[] types = constructor.getParameterTypes();
        if (types == null || types.length == 0) {
            return (T)constructor.newInstance(new Object[0]);
        }
        Object[] params = new Object[types.length];
        for (int i = 0; i < types.length; ++i) {
            params[i] = JavaCalls.getDefaultValue(types[i]);
        }
        return (T)constructor.newInstance(params);
    }

    private static Object getDefaultValue(Class<?> clazz) {
        if (Integer.TYPE.equals(clazz) || Integer.class.equals(clazz) || Byte.TYPE.equals(clazz) || Byte.class.equals(clazz) || Short.TYPE.equals(clazz) || Short.class.equals(clazz) || Long.TYPE.equals(clazz) || Long.class.equals(clazz) || Double.TYPE.equals(clazz) || Double.class.equals(clazz) || Float.TYPE.equals(clazz) || Float.class.equals(clazz)) {
            return 0;
        }
        if (Boolean.TYPE.equals(clazz) || Boolean.class.equals(clazz)) {
            return false;
        }
        if (Character.TYPE.equals(clazz) || Character.class.equals(clazz)) {
            return Character.valueOf('\u0000');
        }
        return null;
    }

    public static <T> T newInstanceOrThrow(Class<?> clazz, Object ... args) throws SecurityException, NoSuchMethodException, IllegalArgumentException, InstantiationException, IllegalAccessException, InvocationTargetException {
        Constructor<?> constructor = clazz.getConstructor(JavaCalls.getParameterTypes(args));
        return (T)constructor.newInstance(JavaCalls.getParameters(args));
    }

    public static Object newInstance(String className, Object ... args) {
        try {
            return JavaCalls.newInstanceOrThrow(className, args);
        }
        catch (Exception e) {
            Log.w((String)TAG, (String)("Meet exception when make instance as a " + className), (Throwable)e);
            return null;
        }
    }

    public static Object newInstanceOrThrow(String className, Object ... args) throws SecurityException, NoSuchMethodException, IllegalArgumentException, InstantiationException, IllegalAccessException, InvocationTargetException, ClassNotFoundException {
        return JavaCalls.newInstanceOrThrow(Class.forName(className), JavaCalls.getParameters(args));
    }

    private static Class<?>[] getParameterTypes(Object ... args) {
        Class[] parameterTypes = null;
        if (args != null && args.length > 0) {
            parameterTypes = new Class[args.length];
            for (int i = 0; i < args.length; ++i) {
                Object param = args[i];
                parameterTypes[i] = param != null && param instanceof JavaParam ? ((JavaParam)param).clazz : (param == null ? null : param.getClass());
            }
        }
        return parameterTypes;
    }

    private static Object[] getParameters(Object ... args) {
        Object[] parameters = null;
        if (args != null && args.length > 0) {
            parameters = new Object[args.length];
            for (int i = 0; i < args.length; ++i) {
                Object param = args[i];
                parameters[i] = param != null && param instanceof JavaParam ? ((JavaParam)param).obj : param;
            }
        }
        return parameters;
    }

    static {
        PRIMITIVE_MAP.put(Boolean.class, Boolean.TYPE);
        PRIMITIVE_MAP.put(Byte.class, Byte.TYPE);
        PRIMITIVE_MAP.put(Character.class, Character.TYPE);
        PRIMITIVE_MAP.put(Short.class, Short.TYPE);
        PRIMITIVE_MAP.put(Integer.class, Integer.TYPE);
        PRIMITIVE_MAP.put(Float.class, Float.TYPE);
        PRIMITIVE_MAP.put(Long.class, Long.TYPE);
        PRIMITIVE_MAP.put(Double.class, Double.TYPE);
        PRIMITIVE_MAP.put(Boolean.TYPE, Boolean.TYPE);
        PRIMITIVE_MAP.put(Byte.TYPE, Byte.TYPE);
        PRIMITIVE_MAP.put(Character.TYPE, Character.TYPE);
        PRIMITIVE_MAP.put(Short.TYPE, Short.TYPE);
        PRIMITIVE_MAP.put(Integer.TYPE, Integer.TYPE);
        PRIMITIVE_MAP.put(Float.TYPE, Float.TYPE);
        PRIMITIVE_MAP.put(Long.TYPE, Long.TYPE);
        PRIMITIVE_MAP.put(Double.TYPE, Double.TYPE);
    }

    public static class JavaParam<T> {
        public final Class<? extends T> clazz;
        public final T obj;

        public JavaParam(Class<? extends T> clazz, T obj) {
            this.clazz = clazz;
            this.obj = obj;
        }
    }
}

