/*
 * Decompiled with CFR 0.152.
 */
package com.run.utils;

import android.annotation.TargetApi;
import android.content.res.Resources;
import android.text.TextUtils;
import com.run.utils.R;
import com.run.utils.StringUtil;
import com.run.utils.config.GlobalConfig;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.concurrent.TimeUnit;

public class TimeUtils {
    public static final int MILLIS_OF_HOUR = 3600000;
    public static final int MILLIS_OF_DAY = 86400000;
    public static final int DAYS_OF_WEEK = 7;

    public static long getCurrentTime() {
        return Calendar.getInstance().getTime().getTime();
    }

    public static long getTodayTime() {
        Calendar cal = Calendar.getInstance();
        cal.set(11, 0);
        cal.set(13, 0);
        cal.set(12, 0);
        cal.set(14, 0);
        return cal.getTime().getTime();
    }

    public static int getDaysInMonth(int month, int year) {
        switch (month) {
            case 0: 
            case 2: 
            case 4: 
            case 6: 
            case 7: 
            case 9: 
            case 11: {
                return 31;
            }
            case 3: 
            case 5: 
            case 8: 
            case 10: {
                return 30;
            }
            case 1: {
                return TimeUtils.isLeapYear(year) ? 29 : 28;
            }
        }
        throw new IllegalArgumentException("Invalid Month");
    }

    public static boolean isLeapYear(int year) {
        boolean isLeapYear = false;
        if (year % 400 == 0) {
            isLeapYear = true;
        } else if (year % 4 == 0 && year % 100 != 0) {
            isLeapYear = true;
        }
        return isLeapYear;
    }

    public static boolean isSameYear(Calendar day1, Calendar day2) {
        if (day1 == null || day2 == null) {
            return false;
        }
        return day1.get(1) == day2.get(1);
    }

    public static boolean isSameMonth(Calendar day1, Calendar day2) {
        if (day1 == null || day2 == null) {
            return false;
        }
        return day1.get(1) == day2.get(1) && day1.get(2) == day2.get(2);
    }

    public static boolean isSameDay(Calendar day1, Calendar day2) {
        if (day1 == null || day2 == null) {
            return false;
        }
        return day1.get(1) == day2.get(1) && day1.get(2) == day2.get(2) && day1.get(5) == day2.get(5);
    }

    public static boolean isSameDay(Calendar day1, int year, int monthOfYear, int dayOfMonth) {
        if (day1 == null) {
            return false;
        }
        return day1.get(1) == year && day1.get(2) == monthOfYear && day1.get(5) == dayOfMonth;
    }

    public static boolean isBelowHour(long timeMillis1, long timeMillis2) {
        long rest = timeMillis1 - timeMillis2;
        return Math.abs(rest) <= 3600000L;
    }

    public static String getDayOfWeek(long time) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(time);
        int dayOfWeek = calendar.get(7);
        return TimeUtils.getResources().getStringArray(R.array.day_of_week)[dayOfWeek - 1];
    }

    public static String getDayOfWeek2(long time) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(time);
        int dayOfWeek = calendar.get(7);
        return TimeUtils.getResources().getStringArray(R.array.day_of_week2)[dayOfWeek - 1];
    }

    private static String getDayOfWeek(int dayOfWeek) {
        return TimeUtils.getResources().getStringArray(R.array.day_of_week)[dayOfWeek - 1];
    }

    public static String getDateHHMM(long time) {
        return new SimpleDateFormat(TimeUtils.getResources().getString(R.string.date_format_hhmm), Locale.CHINA).format(time);
    }

    public static String getDateMMDD(long time) {
        return new SimpleDateFormat(TimeUtils.getResources().getString(R.string.date_format_mmdd), Locale.CHINA).format(time);
    }

    public static String getDataMMDDHHMM(long time) {
        return new SimpleDateFormat(TimeUtils.getResources().getString(R.string.date_format_mmddhhmm), Locale.CHINA).format(time);
    }

    public static String getDateAll(long time) {
        return new SimpleDateFormat(TimeUtils.getResources().getString(R.string.date_format_yyyymmdd), Locale.CHINA).format(time);
    }

    public static String getDateYYMMDDHHMM(long time) {
        return new SimpleDateFormat(TimeUtils.getResources().getString(R.string.date_format_yyyymmddhhmm), Locale.CHINA).format(time);
    }

    public static String getDateYYMMDDHHMM2(long time) {
        return new SimpleDateFormat(TimeUtils.getResources().getString(R.string.date_format_yyyymmddhhmm2), Locale.CHINA).format(time);
    }

    public static String getDateM(long time) {
        return new SimpleDateFormat(TimeUtils.getResources().getString(R.string.date_format_m), Locale.CHINA).format(time);
    }

    public static String getDateYYYYM(long time) {
        return new SimpleDateFormat(TimeUtils.getResources().getString(R.string.date_format_yyyym), Locale.CHINA).format(time);
    }

    public static String getmDateYYYYMMDD2(long time) {
        return new SimpleDateFormat(TimeUtils.getResources().getString(R.string.date_format_yyyymmdd2), Locale.CHINA).format(time);
    }

    public static String getDateYYYYMMDD5(long time) {
        return new SimpleDateFormat(TimeUtils.getResources().getString(R.string.date_format_yyyymmdd5), Locale.CHINA).format(time);
    }

    public static String getDataYYYYMMDDSS(long time) {
        return new SimpleDateFormat(TimeUtils.getResources().getString(R.string.date_format_yyyymmddhhmmss), Locale.CHINA).format(time);
    }

    public static String getDataYYYYMMDDHHMMSS(long time) {
        return new SimpleDateFormat(TimeUtils.getResources().getString(R.string.data_format_yyyymmdd_hhmmss), Locale.CHINA).format(time);
    }

    public static String getDataYYYYMMDDHHMMSS2(long time) {
        return new SimpleDateFormat(TimeUtils.getResources().getString(R.string.data_format_yyyymmdd_hhmmss2), Locale.CHINA).format(time);
    }

    public static String getmDateYYYYMMDD3(long time) {
        return new SimpleDateFormat(TimeUtils.getResources().getString(R.string.date_format_yyyymmdd3), Locale.CHINA).format(time);
    }

    public static String getmDateYYYYMMDD4(long time) {
        return new SimpleDateFormat(TimeUtils.getResources().getString(R.string.date_format_yyyymmdd4), Locale.CHINA).format(time);
    }

    public static String getDateYYYYMMDD6(long time) {
        return new SimpleDateFormat(TimeUtils.getResources().getString(R.string.date_format_yyyymmdd6), Locale.CHINA).format(time);
    }

    public static String getDateMMDD2(long time) {
        return new SimpleDateFormat(TimeUtils.getResources().getString(R.string.date_format_mmdd1), Locale.CHINA).format(time);
    }

    public static String getDateMMSS(long time) {
        return new SimpleDateFormat(TimeUtils.getResources().getString(R.string.date_mm_ss), Locale.CHINA).format(time);
    }

    public static Calendar birthdayToCalendar(String birthday) {
        String[] birthArray;
        Calendar c = Calendar.getInstance();
        if (!TextUtils.isEmpty((CharSequence)birthday) && (birthArray = birthday.split("-")).length == 3) {
            c.set(Integer.valueOf(birthArray[0]), Integer.valueOf(birthArray[1]) - 1, Integer.valueOf(birthArray[2]));
            return c;
        }
        return null;
    }

    private static Resources getResources() {
        return GlobalConfig.getAppContext().getResources();
    }

    public static long parseStringToLong(String dateStr, String pattern) {
        if (TextUtils.isEmpty((CharSequence)dateStr) || TextUtils.isEmpty((CharSequence)pattern)) {
            return 0L;
        }
        SimpleDateFormat formater = new SimpleDateFormat(pattern);
        try {
            Date date = formater.parse(dateStr);
            return date.getTime();
        }
        catch (ParseException e) {
            e.printStackTrace();
            return 0L;
        }
    }

    @TargetApi(value=9)
    public static String getCountTime(long time) {
        if (time < 0L) {
            return "";
        }
        TimeUnit.DAYS.toSeconds(1L);
        StringBuffer countTimeString = new StringBuffer();
        if (time > TimeUnit.DAYS.toMillis(1L)) {
            countTimeString.append(time / TimeUnit.DAYS.toMillis(1L)).append(StringUtil.getString(R.string.day));
        }
        TimeUtils.parseTime(time, TimeUnit.DAYS.toMillis(1L), TimeUnit.HOURS.toMillis(1L), countTimeString);
        TimeUtils.parseTime(time, TimeUnit.HOURS.toMillis(1L), TimeUnit.MINUTES.toMillis(1L), countTimeString);
        TimeUtils.parseTime(time, TimeUnit.MINUTES.toMillis(1L), TimeUnit.SECONDS.toMillis(1L), countTimeString);
        return countTimeString.substring(0, countTimeString.length() - 1);
    }

    private static void parseTime(long time, long longer, long shorter, StringBuffer countTimeString) {
        if (time > shorter) {
            long val = time % longer / shorter;
            if (val < 10L) {
                countTimeString.append(StringUtil.getString(R.string.zero));
            }
            countTimeString.append(val).append(StringUtil.getString(R.string.colon));
        } else {
            countTimeString.append(StringUtil.getString(R.string.zero_zero)).append(StringUtil.getString(R.string.colon));
        }
    }
}

