/*
 * Decompiled with CFR 0.152.
 */
package com.run.utils;

import android.content.Context;
import android.text.Html;
import android.text.Spanned;
import android.text.TextUtils;
import com.run.utils.R;
import com.run.utils.StringUtil;
import java.sql.Date;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Formatter;
import java.util.List;
import java.util.Locale;
import java.util.Random;

public class TextUtil {
    private static final String MAGIC_SPLITTER = "#splitter#";
    private static final int SECONDS_OF_HOUR = 3600;
    private static final int SECONDS_OF_MINUTE = 60;
    private static final int MILLIS_OF_SECOND = 1000;
    private static final long WAN = 10000L;
    private static final ThreadLocalDecimalFormat DECIMAL_FORMAT = new ThreadLocalDecimalFormat();
    private static final long DEFAULT_STORAGE_SIZE_BASE = 1024L;

    public static String formatDateInfoToSecond(long time) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss");
        return sdf.format(new Date(time));
    }

    public static String formatDateInfoToDay(long time) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        return sdf.format(new Date(time));
    }

    public static String formatDateInfoToDayAndWeekDayWithYMD(long time) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy\u5e74MM\u6708dd\u65e5\uff0fE");
        return sdf.format(new Date(time));
    }

    public static String formatDateInfoToMonthDay(long time) {
        SimpleDateFormat sdf = new SimpleDateFormat("MM-dd");
        return sdf.format(new Date(time));
    }

    public static String formatDateInfoToMinuteWithCn(long time) {
        SimpleDateFormat sdf = new SimpleDateFormat(StringUtil.getString(R.string.date_format_yyyymmdd5));
        return sdf.format(new Date(time));
    }

    public static boolean checkGlVersion(String glVersion) {
        if (TextUtils.isEmpty((CharSequence)glVersion)) {
            return false;
        }
        String glVersionRegExp = "[0-9].[0-9]";
        return glVersion.matches(glVersionRegExp);
    }

    public static boolean checkEmail(String email) {
        if (TextUtils.isEmpty((CharSequence)email)) {
            return false;
        }
        String emailRegExp = "\\w+([-+.]\\w+)*@\\w+([-.]\\w+)*\\.\\w+([-.]\\w+)*";
        return email.matches(emailRegExp);
    }

    public static boolean checkEmailOrPhone(String account) {
        if (TextUtils.isEmpty((CharSequence)account)) {
            return false;
        }
        String mobileRegExp = "(\\+86)?1[0-9]{10}";
        String emailRegExp = "\\w+([-+.]\\w+)*@\\w+([-.]\\w+)*\\.\\w+([-.]\\w+)*";
        return account.matches(mobileRegExp) || account.matches(emailRegExp);
    }

    public static String formatTimeInfo(long time) {
        long HOUR_LEN = 3600000L;
        long MIN_LEN = 60000L;
        long SECOND_LEN = 1000L;
        StringBuilder timeText = new StringBuilder();
        if (time >= HOUR_LEN) {
            long hour = time / HOUR_LEN;
            if (hour < 10L) {
                timeText.append('0');
            }
            timeText.append(hour).append(':');
        }
        if (time >= MIN_LEN) {
            long minute = time % HOUR_LEN / MIN_LEN;
            if (minute < 10L) {
                timeText.append('0');
            }
            timeText.append(minute).append(':');
        } else {
            timeText.append("00:");
        }
        if (time >= 0L) {
            long second = time % HOUR_LEN % MIN_LEN / SECOND_LEN;
            if (second < 10L) {
                timeText.append('0');
            }
            timeText.append(second);
        }
        return timeText.toString();
    }

    public static String formatTimeInfoWithHour(long time) {
        long HOUR_LEN = 3600000L;
        long MIN_LEN = 60000L;
        long SECOND_LEN = 1000L;
        StringBuilder timeText = new StringBuilder();
        long hour = time / HOUR_LEN;
        if (hour < 10L) {
            timeText.append('0');
        }
        timeText.append(hour).append(':');
        long minute = time % HOUR_LEN / MIN_LEN;
        if (minute < 10L) {
            timeText.append('0');
        }
        timeText.append(minute).append(':');
        long second = time % HOUR_LEN % MIN_LEN / SECOND_LEN;
        if (second < 10L) {
            timeText.append('0');
        }
        timeText.append(second);
        return timeText.toString();
    }

    public static String formatSizeInfo(double size) {
        return TextUtil.formatSizeInfo(size, (DecimalFormat)DECIMAL_FORMAT.get());
    }

    public static String formatSizeInfo(double size, DecimalFormat format) {
        return TextUtil.formatSizeInfo(size, format, 1024L);
    }

    public static String formatSizeInfo(double size, DecimalFormat format, long sizeBase) {
        long storageSizeBase;
        long KILO = storageSizeBase = sizeBase == 0L ? 1024L : sizeBase;
        long MEGA = storageSizeBase * storageSizeBase;
        long GIGA = storageSizeBase * storageSizeBase * storageSizeBase;
        DecimalFormat decimalFormat = format == null ? (DecimalFormat)DECIMAL_FORMAT.get() : format;
        StringBuilder infoText = new StringBuilder();
        if (size <= 0.0) {
            infoText.append("0KB");
            return infoText.toString();
        }
        if (size > (double)GIGA) {
            infoText.append(decimalFormat.format(size / (double)GIGA)).append("GB");
            return infoText.toString();
        }
        if (size > (double)MEGA) {
            infoText.append(decimalFormat.format(size / (double)MEGA)).append("MB");
            return infoText.toString();
        }
        if (size > (double)KILO) {
            infoText.append(decimalFormat.format(size / (double)KILO)).append("KB");
        } else {
            infoText.append((int)size).append("B");
        }
        return infoText.toString();
    }

    public static List<Spanned> fromHtml(List<String> result) {
        ArrayList<Spanned> spannedList = new ArrayList<Spanned>();
        if (result != null) {
            for (String aResult : result) {
                spannedList.add(Html.fromHtml((String)aResult));
            }
        }
        return spannedList;
    }

    public static boolean isChinese(char c) {
        Character.UnicodeBlock ub = Character.UnicodeBlock.of(c);
        return ub == Character.UnicodeBlock.CJK_UNIFIED_IDEOGRAPHS || ub == Character.UnicodeBlock.CJK_COMPATIBILITY_IDEOGRAPHS || ub == Character.UnicodeBlock.CJK_UNIFIED_IDEOGRAPHS_EXTENSION_A || ub == Character.UnicodeBlock.GENERAL_PUNCTUATION || ub == Character.UnicodeBlock.CJK_SYMBOLS_AND_PUNCTUATION || ub == Character.UnicodeBlock.HALFWIDTH_AND_FULLWIDTH_FORMS;
    }

    public static String makeAppNamePair(String packageName, String appName) {
        return packageName + MAGIC_SPLITTER + appName;
    }

    public static String getAppNameFromAppNamePair(String namePair) {
        if (namePair == null || TextUtils.isEmpty((CharSequence)namePair)) {
            return null;
        }
        String[] fields = namePair.split(MAGIC_SPLITTER);
        if (fields == null || fields.length < 2) {
            return null;
        }
        return fields[1];
    }

    public static String getPakageNameFromAppNamePair(String namePair) {
        if (namePair == null || TextUtils.isEmpty((CharSequence)namePair)) {
            return null;
        }
        int index = namePair.indexOf(MAGIC_SPLITTER);
        if (index <= 0) {
            return null;
        }
        return namePair.substring(0, index);
    }

    public static String formatNumString(String nums, Context applicationContext) {
        if (TextUtils.isEmpty((CharSequence)nums)) {
            return "";
        }
        String demi = "";
        int levelBaseNum = Integer.valueOf(applicationContext.getString(R.string.num_split_level_base));
        int numLegth = nums.length();
        int resNum = numLegth % levelBaseNum;
        numLegth = numLegth <= 1 ? numLegth : numLegth - 1;
        int resLevel = numLegth / levelBaseNum;
        if (resNum == 0) {
            resNum = levelBaseNum;
        }
        if (resLevel != 0) {
            demi = String.valueOf(nums.charAt(resNum));
            demi = "0".equals(demi) ? "" : "." + demi;
        }
        switch (resLevel) {
            case 0: {
                return nums;
            }
            case 1: {
                return nums.substring(0, resNum) + demi + applicationContext.getString(R.string.num_split_level_base_one);
            }
            case 2: {
                return nums.substring(0, resNum) + demi + applicationContext.getString(R.string.num_split_level_base_two);
            }
            case 3: {
                return nums.substring(0, resNum) + demi + applicationContext.getString(R.string.num_split_level_base_three);
            }
        }
        return nums;
    }

    public static String formatNumString(long num, Context applicationContext) {
        if (num > 1000000000000L) {
            return ((DecimalFormat)DECIMAL_FORMAT.get()).format((float)num / 1.0E12f) + applicationContext.getString(R.string.num_split_level_base_three);
        }
        if (num > 100000000L) {
            return ((DecimalFormat)DECIMAL_FORMAT.get()).format((float)num / 1.0E8f) + applicationContext.getString(R.string.num_split_level_base_two);
        }
        if (num > 10000L) {
            return ((DecimalFormat)DECIMAL_FORMAT.get()).format((float)num / 10000.0f) + applicationContext.getString(R.string.num_split_level_base_one);
        }
        return String.valueOf(num);
    }

    public static String stringForTime(long timeMs) {
        StringBuilder formatBuilder = new StringBuilder();
        Formatter formatter = new Formatter(formatBuilder, Locale.getDefault());
        long totalSeconds = timeMs / 1000L;
        long seconds = totalSeconds % 60L;
        long minutes = totalSeconds / 60L % 60L;
        long hours = totalSeconds / 3600L;
        formatBuilder.setLength(0);
        return formatter.format("%d:%02d:%02d", hours, minutes, seconds).toString();
    }

    public static String stringForTimeInMinutes(long timeMs) {
        StringBuilder formatBuilder = new StringBuilder();
        Formatter formatter = new Formatter(formatBuilder, Locale.getDefault());
        long totalSeconds = timeMs / 1000L;
        long seconds = totalSeconds % 60L;
        long minutes = totalSeconds / 60L;
        formatBuilder.setLength(0);
        return formatter.format("%02d:%02d", minutes, seconds).toString();
    }

    public static String getRandomNumber() {
        Random random = new Random();
        return String.valueOf(random.nextInt());
    }

    public static String generateArrayInfo(Context context, List<String> values, int max) {
        if (max <= 0 || max > values.size()) {
            max = values.size();
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < max; ++i) {
            sb.append(values.get(i));
            if (i != max - 1) {
                sb.append(context.getString(R.string.seperator_mark));
                continue;
            }
            if (max >= values.size()) continue;
            sb.append(context.getString(R.string.and_so_on));
        }
        return sb.toString();
    }

    public static String cutStringByLength(String source, int length) {
        if (source != null && source.length() > length + 1) {
            return source.substring(0, length) + "..";
        }
        return source;
    }

    public static String formatDouble(double source) {
        DecimalFormat mFormat = new DecimalFormat("######0.00");
        return mFormat.format(source);
    }

    public static String ToDBC(String input) {
        char[] c = input.toCharArray();
        for (int i = 0; i < c.length; ++i) {
            if (c[i] == '\u3000') {
                c[i] = 32;
                continue;
            }
            if (c[i] <= '\uff00' || c[i] >= '\uff5f') continue;
            c[i] = (char)(c[i] - 65248);
        }
        return new String(c);
    }

    private static class ThreadLocalDecimalFormat
    extends ThreadLocal<DecimalFormat> {
        private ThreadLocalDecimalFormat() {
        }

        @Override
        protected DecimalFormat initialValue() {
            return new DecimalFormat("0.0");
        }
    }

    public static final class StorageSize {
        public static final long KILO = 1024L;
        public static final long MEGA = 0x100000L;
        public static final long GIGA = 0x40000000L;
    }
}

