/*
 * Decompiled with CFR 0.152.
 */
package com.run.utils;

import android.content.SharedPreferences;
import com.run.utils.config.GlobalConfig;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executors;

public class SPUtils {
    public static final String FILE_NAME = "share_data";

    private static SharedPreferences getSharedPreferences() {
        return GlobalConfig.getAppContext().getSharedPreferences(FILE_NAME, 0);
    }

    private static SharedPreferences.Editor getEditor() {
        SharedPreferences sp = SPUtils.getSharedPreferences();
        SharedPreferences.Editor editor = sp.edit();
        return editor;
    }

    public static void putString(String key, String value) {
        SharedPreferences.Editor editor = SPUtils.getEditor();
        editor.putString(key, value);
        SharedPreferencesCompat.apply(editor);
    }

    public static String getString(String key, String defaultValue) {
        SharedPreferences sp = SPUtils.getSharedPreferences();
        return sp.getString(key, defaultValue);
    }

    public static void putInt(String key, int value) {
        SharedPreferences.Editor editor = SPUtils.getEditor();
        editor.putInt(key, value);
        SharedPreferencesCompat.apply(editor);
    }

    public static int getInt(String key, int defaultValue) {
        SharedPreferences sp = SPUtils.getSharedPreferences();
        return sp.getInt(key, defaultValue);
    }

    public static void putBoolean(String key, boolean value) {
        SharedPreferences.Editor editor = SPUtils.getEditor();
        editor.putBoolean(key, value);
        SharedPreferencesCompat.apply(editor);
    }

    public static boolean getBoolean(String key, boolean defaultValue) {
        SharedPreferences sp = SPUtils.getSharedPreferences();
        return sp.getBoolean(key, defaultValue);
    }

    public static void putFloat(String key, float value) {
        SharedPreferences.Editor editor = SPUtils.getEditor();
        editor.putFloat(key, value);
        SharedPreferencesCompat.apply(editor);
    }

    public static float getFloat(String key, float defaultValue) {
        SharedPreferences sp = SPUtils.getSharedPreferences();
        return sp.getFloat(key, defaultValue);
    }

    public static void putLong(String key, long value) {
        SharedPreferences.Editor editor = SPUtils.getEditor();
        editor.putLong(key, value);
        SharedPreferencesCompat.apply(editor);
    }

    public static long getLong(String key, long defaultValue) {
        SharedPreferences sp = SPUtils.getSharedPreferences();
        return sp.getLong(key, defaultValue);
    }

    public static void remove(String key) {
        SharedPreferences.Editor editor = SPUtils.getEditor();
        editor.remove(key);
        SharedPreferencesCompat.apply(editor);
    }

    public static void clear() {
        SharedPreferences.Editor editor = SPUtils.getEditor();
        editor.clear();
        SharedPreferencesCompat.apply(editor);
    }

    public static boolean contains(String key) {
        SharedPreferences sp = SPUtils.getSharedPreferences();
        return sp.contains(key);
    }

    public static Map<String, ?> getAll() {
        SharedPreferences sp = SPUtils.getSharedPreferences();
        return sp.getAll();
    }

    public static Set<String> getStringSet(String key) {
        SharedPreferences sp = SPUtils.getSharedPreferences();
        return sp.getStringSet(key, new HashSet());
    }

    public static void putStringSet(String key, Set<String> value) {
        SharedPreferences.Editor editor = SPUtils.getEditor();
        editor.putStringSet(key, value);
        SharedPreferencesCompat.apply(editor);
    }

    private static class SharedPreferencesCompat {
        private static final Method sApplyMethod = SharedPreferencesCompat.findApplyMethod();

        private SharedPreferencesCompat() {
        }

        private static Method findApplyMethod() {
            try {
                Class<SharedPreferences.Editor> clz = SharedPreferences.Editor.class;
                return clz.getMethod("apply", new Class[0]);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                return null;
            }
        }

        public static void apply(final SharedPreferences.Editor editor) {
            try {
                if (sApplyMethod != null) {
                    sApplyMethod.invoke((Object)editor, new Object[0]);
                    return;
                }
            }
            catch (Exception e) {
                Executors.newSingleThreadExecutor().execute(new Runnable(){

                    @Override
                    public void run() {
                        editor.commit();
                    }
                });
            }
        }
    }
}

