/*
 * Decompiled with CFR 0.152.
 */
package com.run.utils;

import android.text.TextUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class MD5Utils {
    private static final int BYTE_SIZE = 1024;
    private static final String MD5 = "MD5";
    private static final int END_OF_FILE = -1;
    private static final int FILE_OFFSET = 0;

    public static final String get(String src) {
        try {
            MessageDigest digest = MessageDigest.getInstance(MD5);
            digest.update(src.getBytes());
            byte[] messageDigest = digest.digest();
            StringBuffer hexString = new StringBuffer();
            for (int i = 0; i < messageDigest.length; ++i) {
                String h = Integer.toHexString(0xFF & messageDigest[i]);
                while (h.length() < 2) {
                    h = "0" + h;
                }
                hexString.append(h);
            }
            return hexString.toString();
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
            return "";
        }
    }

    public static boolean check(String content, String md5) {
        return MD5Utils.get(content).equals(md5);
    }

    public static final String sign(String content, String key) {
        return MD5Utils.get(content + key);
    }

    public static boolean check(String content, String key, String md5) {
        return MD5Utils.get(content + key).equals(md5);
    }

    public static String getFileMD5(String path) throws NoSuchAlgorithmException, IOException {
        if (TextUtils.isEmpty((CharSequence)path)) {
            return null;
        }
        File file = new File(path);
        return MD5Utils.getFileMD5(file, false);
    }

    public static String getFileMD5(File file, boolean upperCase) throws NoSuchAlgorithmException, IOException {
        int size;
        if (file == null) {
            return null;
        }
        MessageDigest messageDigest = MessageDigest.getInstance(MD5);
        byte[] data = new byte[1024];
        FileInputStream fis = new FileInputStream(file);
        while ((size = fis.read(data)) != -1) {
            messageDigest.update(data, 0, size);
        }
        fis.close();
        byte[] digest = messageDigest.digest();
        int digestLength = digest.length;
        StringBuilder md5 = new StringBuilder();
        StringBuilder temp = new StringBuilder();
        for (int i = 0; i < digestLength; ++i) {
            temp.setLength(0);
            String hex = Integer.toHexString(digest[i] & 0xFF);
            if (hex.length() == 1) {
                temp.append("0").append(hex);
            } else {
                temp.append(hex);
            }
            md5.append(temp.toString());
        }
        if (upperCase) {
            return md5.toString().toUpperCase();
        }
        return md5.toString().toLowerCase();
    }
}

