/*
 * Decompiled with CFR 0.152.
 */
package com.run.utils;

import android.content.Context;
import android.database.Cursor;
import android.net.Uri;
import android.os.Environment;
import android.os.StatFs;
import android.text.TextUtils;
import com.run.utils.PathAdjustUtil;
import com.run.utils.config.GlobalConfig;
import com.run.utils.reflect.JavaCalls;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.nio.channels.FileChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class FileUtil {
    public static final int MAX_ERROR_FILES = 5;
    private static final String PATH_PLACEHOLDER_EXTERNAL = "%EXTERNAL%";
    private static final String PATH_PLACEHOLDER_HOME = "%HOME%";
    private static final String PATH_PREFIX_EXTERNAL = "/mnt/sdcard";
    private static final String PATH_PREFIX_EXTERNAL_SDCARD = "/sdcard";
    private static final int BUFFER_SIZE = 2048;

    public static void deleteFile(String path) {
        if (TextUtils.isEmpty((CharSequence)path)) {
            return;
        }
        File file = new File(path);
        if (!file.exists() || !file.isFile()) {
            return;
        }
        file.delete();
    }

    public static boolean exists(String path) {
        if (TextUtils.isEmpty((CharSequence)path)) {
            return false;
        }
        File file = new File(path);
        return file.exists();
    }

    public static boolean mkdir(String path) {
        File dir = new File(path);
        return dir.mkdirs();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean copyFile(File srcFile, File dstFile) {
        if (srcFile.exists() && srcFile.isFile()) {
            if (dstFile.isDirectory()) {
                return false;
            }
            if (dstFile.exists()) {
                dstFile.delete();
            }
            FileInputStream fi = null;
            FileOutputStream fo = null;
            AbstractInterruptibleChannel in = null;
            AbstractInterruptibleChannel out = null;
            try {
                fi = new FileInputStream(srcFile);
                fo = new FileOutputStream(dstFile);
                in = fi.getChannel();
                out = fo.getChannel();
                ((FileChannel)in).transferTo(0L, ((FileChannel)in).size(), (WritableByteChannel)((Object)out));
                boolean bl = true;
                return bl;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            finally {
                try {
                    if (fi != null) {
                        fi.close();
                    }
                    if (in != null) {
                        in.close();
                    }
                    if (fo != null) {
                        fo.close();
                    }
                    if (out != null) {
                        out.close();
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return false;
    }

    public static int copyDirectory(File sourceDir, File targetDir) {
        int errorFileNum = 0;
        if (!targetDir.exists() && !targetDir.mkdirs()) {
            return -1;
        }
        File[] file = sourceDir.listFiles();
        if (file == null) {
            return errorFileNum;
        }
        for (int i = 0; i < file.length; ++i) {
            File targetFile;
            File sourceFile;
            boolean result;
            if (file[i].isFile() && !(result = FileUtil.copyFile(sourceFile = file[i], targetFile = new File(targetDir, file[i].getName()))) && ++errorFileNum > 5) {
                return -1;
            }
            if (!file[i].isDirectory()) continue;
            int error = FileUtil.copyDirectory(file[i], new File(targetDir, file[i].getName()));
            if (error < 0) {
                return error;
            }
            if ((errorFileNum += error) <= 5) continue;
            return -1;
        }
        return errorFileNum;
    }

    public static int copyAllFiles(String sourceDir, String targetDir) {
        File sourceDF = new File(sourceDir);
        int errorFileNum = 0;
        if (!sourceDF.exists()) {
            return -1;
        }
        File targetDF = new File(targetDir);
        if (!targetDF.exists()) {
            return -1;
        }
        File[] file = sourceDF.listFiles();
        for (int i = 0; i < file.length; ++i) {
            boolean result;
            if (file[i].isFile() && !(result = FileUtil.copyFile(file[i], new File(targetDir, file[i].getName()))) && ++errorFileNum > 5) {
                return -1;
            }
            if (!file[i].isDirectory()) continue;
            int error = FileUtil.copyDirectory(file[i], new File(targetDir, file[i].getName()));
            if (error < 0) {
                return error;
            }
            if ((errorFileNum += error) <= 5) continue;
            return -1;
        }
        return errorFileNum;
    }

    public static boolean copyFile(String srcPath, String dstPath) {
        return FileUtil.copyFile(new File(srcPath), new File(dstPath));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readFileFirstLine(String filePath) {
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new FileReader(filePath));
            String line = reader.readLine();
            reader.close();
            String string = line;
            return string;
        }
        catch (Exception e) {
            String string = "";
            return string;
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public static void deletePath(String path) {
        File file = new File(path);
        if (!file.exists()) {
            return;
        }
        if (file.isFile()) {
            file.delete();
            return;
        }
        String[] tmpList = file.list();
        if (tmpList == null) {
            return;
        }
        for (String fileName : tmpList) {
            if (fileName == null) continue;
            String tmpPath = null;
            tmpPath = path.endsWith(File.separator) ? path + fileName : path + File.separator + fileName;
            File tmpFile = new File(tmpPath);
            if (tmpFile.isFile()) {
                tmpFile.delete();
            }
            if (!tmpFile.isDirectory()) continue;
            FileUtil.deletePath(tmpPath);
        }
        file.delete();
    }

    public static void clearPath(String path) {
        String[] tmpList;
        File file = new File(path);
        if (!file.exists() || !file.isDirectory()) {
            return;
        }
        for (String fileName : tmpList = file.list()) {
            String tmpPath = null;
            tmpPath = path.endsWith(File.separator) ? path + fileName : path + File.separator + fileName;
            File tmpFile = new File(tmpPath);
            if (tmpFile.isFile()) {
                tmpFile.delete();
            }
            if (!tmpFile.isDirectory()) continue;
            FileUtil.deletePath(tmpPath);
        }
    }

    public static long getFileSize(String path) {
        File[] childList;
        if (TextUtils.isEmpty((CharSequence)path)) {
            return 0L;
        }
        File file = new File(path);
        if (file == null || !file.exists()) {
            return 0L;
        }
        long size = file.length();
        if (file.isDirectory() && (childList = file.listFiles()) != null) {
            for (File childFile : childList) {
                try {
                    size += FileUtil.getFileSize(childFile.getAbsolutePath());
                }
                catch (StackOverflowError e) {
                    e.printStackTrace();
                    return 0L;
                }
                catch (OutOfMemoryError e2) {
                    e2.printStackTrace();
                    return 0L;
                }
            }
        }
        return size;
    }

    public static String formatExternalPath(String path) {
        String formatedPath = FileUtil.formatExternalPath(path, Environment.getExternalStorageDirectory().getAbsolutePath());
        if (!FileUtil.exists(formatedPath)) {
            return path;
        }
        return formatedPath;
    }

    private static String formatExternalPath(String path, String replaced) {
        if (!TextUtils.isEmpty((CharSequence)path)) {
            if (path.startsWith(PATH_PLACEHOLDER_EXTERNAL)) {
                return path.replace(PATH_PLACEHOLDER_EXTERNAL, replaced);
            }
            if (path.startsWith(PATH_PREFIX_EXTERNAL)) {
                return path.replace(PATH_PREFIX_EXTERNAL, replaced);
            }
            if (path.startsWith(PATH_PREFIX_EXTERNAL_SDCARD)) {
                return path.replace(PATH_PREFIX_EXTERNAL_SDCARD, replaced);
            }
            return PathAdjustUtil.adjustSdcardPathForApp(path);
        }
        return path;
    }

    public static String formatPath(Context context, String path) {
        if (path.startsWith(PATH_PLACEHOLDER_HOME)) {
            return FileUtil.formatHomePath(context, path);
        }
        return FileUtil.formatExternalPath(path);
    }

    public static boolean isExternalPath(String path) {
        return !path.startsWith(PATH_PLACEHOLDER_HOME);
    }

    public static String formatHomePath(Context context, String path) {
        if (path.startsWith(PATH_PLACEHOLDER_HOME)) {
            if (Environment.getExternalStorageState().equals("mounted")) {
                return path.replace(PATH_PLACEHOLDER_HOME, Environment.getExternalStorageDirectory().getAbsolutePath() + "/" + GlobalConfig.getAppRootDir() + "/");
            }
            return path.replace(PATH_PLACEHOLDER_HOME, context.getFilesDir().getAbsolutePath());
        }
        return path;
    }

    public static boolean isExternalFile(Context context, String path) {
        if (!TextUtils.isEmpty((CharSequence)path)) {
            return path.startsWith(Environment.getExternalStorageDirectory().getAbsolutePath());
        }
        return false;
    }

    public static String getFileName(String path) {
        int lastIndex;
        if (path.endsWith("/")) {
            path = path.substring(0, path.length() - 1);
        }
        if ((lastIndex = path.lastIndexOf("/")) > 0 && lastIndex < path.length() - 1) {
            return path.substring(lastIndex + 1);
        }
        return path;
    }

    public static String getParentFilePath(String filePath) {
        int lastSplitIndex;
        if (filePath.endsWith("/")) {
            filePath = filePath.substring(0, filePath.length() - 1);
        }
        if ((lastSplitIndex = filePath.lastIndexOf("/")) >= 0) {
            return filePath.substring(0, lastSplitIndex);
        }
        return null;
    }

    public static String getFileNameWithoutExtension(String path) {
        int dotPos;
        String filename = FileUtil.getFileName(path);
        if (filename != null && filename.length() > 0 && 0 < (dotPos = filename.lastIndexOf(46))) {
            return filename.substring(0, dotPos);
        }
        return filename;
    }

    public static String getFileExtension(String path) {
        int index = path.lastIndexOf(".");
        if (index >= 0 && index < path.length() - 1) {
            return path.substring(index + 1).toUpperCase();
        }
        return "";
    }

    public static boolean renameFile(String originPath, String destPath) {
        File origin = new File(originPath);
        File dest = new File(destPath);
        if (!origin.exists()) {
            return false;
        }
        return origin.renameTo(dest);
    }

    public static long getUsedBytes(String root) {
        try {
            if (!TextUtils.isEmpty((CharSequence)root) && new File(root).exists()) {
                StatFs stat = new StatFs(root);
                long availableBlocks = stat.getAvailableBlocks();
                long blocks = stat.getBlockCount();
                return (long)stat.getBlockSize() * (blocks - availableBlocks);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return 0L;
    }

    public static long getAvailableBytes(String root) {
        try {
            if (!TextUtils.isEmpty((CharSequence)root) && new File(root).exists()) {
                StatFs stat = new StatFs(root);
                long availableBlocks = stat.getAvailableBlocks();
                return (long)stat.getBlockSize() * availableBlocks;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return 0L;
    }

    public static long getAllBytes(String root) {
        if (TextUtils.isEmpty((CharSequence)root)) {
            return 0L;
        }
        try {
            if (!TextUtils.isEmpty((CharSequence)root) && new File(root).exists()) {
                StatFs stat = new StatFs(root);
                long blocks = stat.getBlockCount();
                return (long)stat.getBlockSize() * blocks;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return 0L;
    }

    public static boolean canWrite(File file) {
        String testName;
        File testFile;
        boolean result;
        if (file == null) {
            return false;
        }
        if (!file.exists()) {
            file.mkdirs();
        }
        if (result = (testFile = new File(file, testName = "." + System.currentTimeMillis())).mkdir()) {
            result = testFile.delete();
        }
        return result;
    }

    public static boolean canWrite(String path) {
        return FileUtil.canWrite(new File(path));
    }

    public static void setPermissions(String path, int permissions) {
        JavaCalls.callStaticMethod("android.os.FileUtils", path, permissions, -1, -1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean copyFile(InputStream ins, File outputFile) {
        boolean bl;
        if (outputFile == null) {
            return false;
        }
        String path = outputFile.getAbsolutePath();
        if (outputFile.exists()) {
            outputFile.delete();
        }
        FileOutputStream ous = null;
        try {
            ous = new FileOutputStream(path);
            bl = FileUtil.copyFile(ins, ous);
        }
        catch (FileNotFoundException e) {
            boolean bl2;
            try {
                e.printStackTrace();
                bl2 = false;
            }
            catch (Throwable throwable) {
                FileUtil.close(ous);
                FileUtil.close(ins);
                throw throwable;
            }
            FileUtil.close(ous);
            FileUtil.close(ins);
            return bl2;
        }
        FileUtil.close(ous);
        FileUtil.close(ins);
        return bl;
    }

    public static boolean copyFile(InputStream ins, OutputStream outs) {
        if (ins == null || outs == null) {
            return false;
        }
        int count = 0;
        byte[] buffer = new byte[2048];
        try {
            while ((count = ins.read(buffer)) > 0) {
                outs.write(buffer, 0, count);
            }
            outs.flush();
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public static String[] getAssetsFile(Context context, String assetPath) {
        if (context == null || TextUtils.isEmpty((CharSequence)assetPath)) {
            return null;
        }
        try {
            return context.getResources().getAssets().list(assetPath);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static byte[] readFully(InputStream is) {
        if (is == null) {
            return null;
        }
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        byte[] buffer = new byte[4096];
        try {
            int count = 0;
            while ((count = is.read(buffer)) != -1) {
                bos.write(buffer, 0, count);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return bos.toByteArray();
    }

    private static void close(Closeable closeable) {
        if (closeable == null) {
            return;
        }
        try {
            closeable.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void deleteFilesByDirectory(File directory) {
        if (directory == null || !directory.exists()) {
            return;
        }
        if (directory.isFile()) {
            directory.delete();
            return;
        }
        if (directory.isDirectory()) {
            for (File item : directory.listFiles()) {
                if (item == null) continue;
                if (item.isFile()) {
                    item.delete();
                }
                if (!item.isDirectory()) continue;
                FileUtil.deleteFilesByDirectory(item);
            }
        }
        directory.delete();
    }

    public static boolean writeFileFromBytes(byte[] fileBytes, String path) {
        if (fileBytes == null) {
            return false;
        }
        boolean result = true;
        try {
            File file = new File(path);
            file.setWritable(true, false);
            FileOutputStream fs = new FileOutputStream(file);
            fs.write(fileBytes);
            fs.flush();
            fs.close();
        }
        catch (IOException e) {
            result = false;
        }
        return result;
    }

    public static byte[] readFileToBytes(InputStream is) throws IOException {
        int n;
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        byte[] b = new byte[1024];
        while ((n = is.read(b)) != -1) {
            bos.write(b, 0, n);
        }
        is.close();
        bos.flush();
        bos.close();
        byte[] buffer = bos.toByteArray();
        return buffer;
    }

    public static String getRealFilePath(Context context, Uri uri) {
        Cursor cursor;
        if (null == uri) {
            return null;
        }
        String scheme = uri.getScheme();
        String data = null;
        if (scheme == null) {
            data = uri.getPath();
        } else if ("file".equals(scheme)) {
            data = uri.getPath();
        } else if ("content".equals(scheme) && null != (cursor = context.getContentResolver().query(uri, new String[]{"_data"}, null, null, null))) {
            int index;
            if (cursor.moveToFirst() && (index = cursor.getColumnIndex("_data")) > -1) {
                data = cursor.getString(index);
            }
            cursor.close();
        }
        return data;
    }

    public static void deleteFileAndFolder(File file) {
        if (file == null) {
            return;
        }
        if (!file.exists()) {
            return;
        }
        if (file.isFile()) {
            file.delete();
            return;
        }
        if (file.isDirectory()) {
            File[] fileNameList = file.listFiles();
            if (fileNameList == null || fileNameList.length == 0) {
                file.delete();
                return;
            }
            for (File childFile : fileNameList) {
                FileUtil.deleteFileAndFolder(childFile);
            }
            file.delete();
        }
    }

    public static boolean unZipFile(String zipFilePath, String folderPath) {
        boolean flag = false;
        try {
            ZipFile zfile = new ZipFile(zipFilePath);
            Enumeration<? extends ZipEntry> zList = zfile.entries();
            ZipEntry ze = null;
            byte[] buf = new byte[1024];
            while (zList.hasMoreElements()) {
                ze = zList.nextElement();
                if (ze.isDirectory()) {
                    String dirstr = folderPath + ze.getName();
                    File f = new File(dirstr);
                    f.mkdir();
                    continue;
                }
                BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(FileUtil.getRealFileName(folderPath, ze.getName())));
                BufferedInputStream is2 = new BufferedInputStream(zfile.getInputStream(ze));
                int readLen = 0;
                while ((readLen = ((InputStream)is2).read(buf, 0, 1024)) != -1) {
                    ((OutputStream)os).write(buf, 0, readLen);
                }
                ((InputStream)is2).close();
                ((OutputStream)os).close();
            }
            flag = true;
            zfile.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return flag;
    }

    private static File getRealFileName(String baseDir, String relativeFileName) {
        String[] dirs = relativeFileName.split("/");
        File ret = new File(baseDir);
        String substr = null;
        if (dirs.length >= 1) {
            for (int i = 0; i < dirs.length - 1; ++i) {
                substr = dirs[i];
                try {
                    substr = new String(substr.getBytes("8859_1"), "GB2312");
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    // empty catch block
                }
                ret = new File(ret, substr);
            }
            if (!ret.exists()) {
                ret.mkdirs();
            }
            substr = dirs[dirs.length - 1];
            try {
                substr = new String(substr.getBytes("8859_1"), "GB2312");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
            ret = new File(ret, substr);
            return ret;
        }
        return ret;
    }
}

