/*
 * Decompiled with CFR 0.152.
 */
package com.run.utils;

import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.text.TextUtils;
import java.io.IOException;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class ChannelUtil {
    private static String getMetaData(Context context, String key) {
        try {
            ApplicationInfo ai = context.getPackageManager().getApplicationInfo(context.getPackageName(), 128);
            Object channel = ai.metaData.get(key);
            if (channel != null) {
                String[] values = channel.toString().split("_");
                return values[values.length - 1];
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getChannelInfo(Context context) {
        ApplicationInfo appinfo = context.getApplicationInfo();
        String sourceDir = appinfo.sourceDir;
        String ret = "channel_xxx_0";
        String start_flag = "META-INF/channel_";
        ZipFile zipfile = null;
        try {
            zipfile = new ZipFile(sourceDir);
            Enumeration<? extends ZipEntry> entries = zipfile.entries();
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                String entryName = entry.getName();
                if (TextUtils.isEmpty((CharSequence)entryName) || !entryName.startsWith("META-INF/channel_")) continue;
                ret = entryName.replace("META-INF/channel_", "channel_");
                break;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (zipfile != null) {
                try {
                    zipfile.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return ret;
    }

    public static String getChannelCode(String channel) {
        String[] split = channel.split("_");
        if (split != null && split.length >= 2) {
            return split[split.length - 1];
        }
        return "0";
    }
}

