/*
 * Decompiled with CFR 0.152.
 */
package com.run.utils;

import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.os.Build;
import java.lang.reflect.Field;

public class BadgeUtil {
    public static void setBadgeCount(Context context, int count) {
        if (count < 0) {
            return;
        }
        if (Build.MANUFACTURER.equalsIgnoreCase("Xiaomi")) {
            BadgeUtil.sendToXiaoMi(context, count);
        } else if (Build.MANUFACTURER.equalsIgnoreCase("sony")) {
            BadgeUtil.sendToSony(context, count);
        } else if (Build.MANUFACTURER.toLowerCase().contains("samsung")) {
            BadgeUtil.sendToSamsumg(context, count);
        }
    }

    private static void sendToXiaoMi(Context context, int count) {
        try {
            Class<?> miuiNotificationClass = Class.forName("android.app.MiuiNotification");
            Object miuiNotification = miuiNotificationClass.newInstance();
            Field field = miuiNotification.getClass().getDeclaredField("messageCount");
            field.setAccessible(true);
            field.set(miuiNotification, String.valueOf(count == 0 ? "" : Integer.valueOf(count)));
        }
        catch (Exception e) {
            e.printStackTrace();
            Intent localIntent = new Intent("android.intent.action.APPLICATION_MESSAGE_UPDATE");
            localIntent.putExtra("android.intent.extra.update_application_component_name", context.getPackageName() + "/" + BadgeUtil.getLaunchActivityName(context));
            localIntent.putExtra("android.intent.extra.update_application_message_text", String.valueOf(count == 0 ? "" : Integer.valueOf(count)));
            context.sendBroadcast(localIntent);
        }
    }

    private static void sendToSony(Context context, int count) {
        String launcherClassName = BadgeUtil.getLaunchActivityName(context);
        if (launcherClassName == null) {
            return;
        }
        boolean isShow = true;
        if (count == 0) {
            isShow = false;
        }
        Intent localIntent = new Intent();
        localIntent.setAction("com.sonyericsson.home.action.UPDATE_BADGE");
        localIntent.putExtra("com.sonyericsson.home.intent.extra.badge.SHOW_MESSAGE", isShow);
        localIntent.putExtra("com.sonyericsson.home.intent.extra.badge.ACTIVITY_NAME", launcherClassName);
        localIntent.putExtra("com.sonyericsson.home.intent.extra.badge.MESSAGE", String.valueOf(count));
        localIntent.putExtra("com.sonyericsson.home.intent.extra.badge.PACKAGE_NAME", context.getPackageName());
        context.sendBroadcast(localIntent);
    }

    private static void sendToSamsumg(Context context, int count) {
        String launcherClassName = BadgeUtil.getLaunchActivityName(context);
        if (launcherClassName == null) {
            return;
        }
        Intent intent = new Intent("android.intent.action.BADGE_COUNT_UPDATE");
        intent.putExtra("badge_count", count);
        intent.putExtra("badge_count_package_name", context.getPackageName());
        intent.putExtra("badge_count_class_name", launcherClassName);
        context.sendBroadcast(intent);
    }

    public static void resetBadgeCount(Context context) {
        BadgeUtil.setBadgeCount(context, 0);
    }

    public static String getLaunchActivityName(Context context) {
        PackageManager localPackageManager = context.getPackageManager();
        Intent localIntent = new Intent("android.intent.action.MAIN");
        localIntent.addCategory("android.intent.category.LAUNCHER");
        try {
            for (ResolveInfo localResolveInfo : localPackageManager.queryIntentActivities(localIntent, 0)) {
                if (!localResolveInfo.activityInfo.applicationInfo.packageName.equalsIgnoreCase(context.getPackageName())) continue;
                String str = localResolveInfo.activityInfo.name;
                return str;
            }
        }
        catch (Exception localException) {
            return null;
        }
        return null;
    }
}

