/*
 * Decompiled with CFR 0.152.
 */
package com.run.rxjava.rxbus;

import io.reactivex.Observable;
import io.reactivex.annotations.NonNull;
import io.reactivex.annotations.Nullable;
import io.reactivex.subjects.PublishSubject;
import io.reactivex.subjects.Subject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;

public class RxBus {
    private final ConcurrentHashMap<Object, List<Subject>> mSubjectMapper = new ConcurrentHashMap();

    public static RxBus getInstance() {
        return RxBusHolder.INSTANCE;
    }

    private RxBus() {
    }

    public <T> Observable<T> register(@NonNull Object tag, @Nullable Class<T> cls) {
        List<Subject> subjectList = this.mSubjectMapper.get(tag);
        if (subjectList == null) {
            subjectList = new ArrayList<Subject>();
            this.mSubjectMapper.put(tag, subjectList);
        }
        PublishSubject subject = PublishSubject.create();
        subjectList.add((Subject)subject);
        return subject;
    }

    public <T> Observable<T> register(@NonNull Object tag) {
        return this.register(tag, null);
    }

    public RxBus unregister(@NonNull Object tag, @NonNull Observable<?> observable) {
        List<Subject> subjects = this.mSubjectMapper.get(tag);
        if (subjects != null) {
            subjects.remove((Subject)observable);
            if (RxBus.isEmpty(subjects)) {
                this.mSubjectMapper.remove(tag);
            }
        }
        return this;
    }

    public void unregisterAllForTag(@NonNull Object tag) {
        List<Subject> subjects = this.mSubjectMapper.get(tag);
        if (subjects != null) {
            this.mSubjectMapper.remove(tag);
        }
    }

    public void postWithClassNameAsTag(@NonNull Object content) {
        this.post(content.getClass().getName(), content);
    }

    public void post(@NonNull Object tag, @NonNull Object content) {
        List<Subject> subjectList = this.mSubjectMapper.get(tag);
        if (!RxBus.isEmpty(subjectList)) {
            for (Subject subject : subjectList) {
                subject.onNext(content);
            }
        }
    }

    private static <T> boolean isEmpty(@Nullable Collection<T> collection) {
        return collection == null || collection.isEmpty();
    }

    private static final class RxBusHolder {
        private static final RxBus INSTANCE = new RxBus();

        private RxBusHolder() {
        }
    }
}

