/*
 * Decompiled with CFR 0.152.
 */
package com.ruijc.util;

import com.alibaba.fastjson.JSON;
import com.ruijc.util.EncryptUtils;
import com.ruijc.util.MapUtils;
import com.ruijc.util.StringUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.Enumeration;
import java.util.HashMap;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class HttpUtils {
    public static final String HTTP_PROTCOL = "http://";

    public static boolean checkSign(ServletRequest req, String key) {
        String sign = req.getParameter(key);
        if (StringUtils.isBlank(sign)) {
            boolean ret = false;
            return ret;
        }
        HashMap<String, String> params = new HashMap<String, String>();
        Enumeration paramNames = req.getParameterNames();
        while (paramNames.hasMoreElements()) {
            String name = (String)paramNames.nextElement();
            params.put(name, req.getParameter(name));
        }
        params.put(key, "");
        String mySign = EncryptUtils.md5(MapUtils.linkString(params));
        boolean ret = sign.equals(mySign);
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void write(ServletResponse response, String content) throws IOException {
        response.setContentLength(-1);
        PrintWriter writer = null;
        ServletOutputStream sos = null;
        try {
            writer = response.getWriter();
            writer.println(content);
        }
        catch (Exception e) {
            sos = response.getOutputStream();
            sos.println(content);
        }
        finally {
            if (null != writer) {
                writer.flush();
                writer.close();
            }
            if (null != sos) {
                sos.flush();
                sos.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void write(ServletResponse response, Object data) throws IOException {
        response.setContentLength(-1);
        response.setContentType("application/json;charset=utf-8");
        response.setCharacterEncoding("utf-8");
        String json = JSON.toJSONString((Object)data);
        PrintWriter writer = null;
        ServletOutputStream sos = null;
        try {
            writer = response.getWriter();
            writer.println(json);
        }
        catch (Exception e) {
            sos = response.getOutputStream();
            sos.println(json);
        }
        finally {
            if (null != writer) {
                writer.flush();
                writer.close();
            }
            if (null != sos) {
                sos.flush();
                sos.close();
            }
        }
    }

    public static String finalUrl(String url) {
        String to = url;
        try {
            URL serverUrl = new URL(url);
            HttpURLConnection conn = (HttpURLConnection)serverUrl.openConnection();
            conn.setConnectTimeout(300000);
            conn.setReadTimeout(300000);
            conn.setRequestMethod("GET");
            conn.setInstanceFollowRedirects(false);
            conn.addRequestProperty("Accept-Charset", "UTF-8;");
            conn.addRequestProperty("User-Agent", "Mozilla/5.0 (Windows; U; Windows NT 5.1; zh-CN; rv:1.9.2.8) Firefox/3.6.8");
            conn.addRequestProperty("Referer", "http://icoolxue.com/");
            conn.connect();
            if (conn.getResponseCode() == 302 || conn.getResponseCode() == 301) {
                to = conn.getHeaderField("Location");
                return HttpUtils.finalUrl(to);
            }
            conn.disconnect();
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
        }
        return to;
    }

    public static String encode(String from) {
        return HttpUtils.encode(from, "UTF-8");
    }

    public static String encode(String from, String charset) {
        String to;
        try {
            to = URLEncoder.encode(from, charset);
        }
        catch (UnsupportedEncodingException e) {
            to = from;
        }
        return to;
    }

    public static String decode(String from) {
        return HttpUtils.decode(from, "UTF-8");
    }

    public static String decode(String from, String charset) {
        String to;
        try {
            to = URLDecoder.decode(from, charset);
        }
        catch (UnsupportedEncodingException e) {
            to = from;
        }
        return to;
    }

    public static String clientIP(ServletRequest request) {
        String ip = "127.0.0.1";
        if (!(request instanceof HttpServletRequest)) {
            return ip;
        }
        HttpServletRequest req = (HttpServletRequest)request;
        ip = req.getHeader("x-forwarded-for");
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = req.getHeader("Proxy-Client-IP");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = req.getHeader("WL-Proxy-Client-IP");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = req.getRemoteAddr();
        }
        return ip;
    }

    public static String getReferer(ServletRequest request) {
        String referer = "";
        if (!(request instanceof HttpServletRequest)) {
            return referer;
        }
        HttpServletRequest req = (HttpServletRequest)request;
        referer = StringUtils.getString(req.getHeader("referer"), req.getHeader("Referer"));
        if (!StringUtils.isBlank(referer) && !referer.startsWith(HTTP_PROTCOL)) {
            referer = referer + HTTP_PROTCOL;
        }
        return referer;
    }

    public static String getString(ServletRequest request) throws Exception {
        int portion;
        char[] readerBuffer = new char[request.getContentLength()];
        BufferedReader bufferedReader = request.getReader();
        for (int amount = portion = bufferedReader.read(readerBuffer); amount < readerBuffer.length; amount += portion) {
            portion = bufferedReader.read(readerBuffer, amount, readerBuffer.length - amount);
        }
        StringBuilder stringBuffer = new StringBuilder((int)((double)readerBuffer.length * 1.5));
        for (int index = 0; index < readerBuffer.length; ++index) {
            char c = readerBuffer[index];
            stringBuffer.append(c);
        }
        String xml = stringBuffer.toString();
        return xml;
    }

    public static boolean isAjax(ServletRequest sr) {
        String method;
        boolean isAjax = false;
        String contentType = sr.getContentType();
        if (!StringUtils.isBlank(contentType) && contentType.contains("application/json")) {
            isAjax = true;
        }
        if (!isAjax && sr instanceof HttpServletRequest && !StringUtils.isBlank(method = ((HttpServletRequest)sr).getHeader("method")) && method.contains("ajax")) {
            isAjax = true;
        }
        return isAjax;
    }

    public static HttpServletRequest toHttp(ServletRequest request) {
        return (HttpServletRequest)request;
    }

    public static HttpServletResponse toHttp(ServletResponse response) {
        return (HttpServletResponse)response;
    }
}

