/*
 * Decompiled with CFR 0.152.
 */
package com.ruijc.util;

import java.util.Arrays;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CollectionUtils {
    public static <T> T last(List<T> data) {
        return data.get(data.size() - 1);
    }

    public static <T> String strings(List<T> data, String split) {
        StringBuilder sb = new StringBuilder();
        if (null == data || data.isEmpty()) {
            sb.append("");
        } else {
            sb.append(split);
            for (T obj : data) {
                sb.append(obj.toString());
                sb.append(split);
            }
        }
        return sb.toString();
    }

    public static <T> String strings(List<T> data) {
        return CollectionUtils.strings(data, "\n");
    }

    public static <T> T[] concat(T[] first, T[] ... rest) {
        int totalLength = first.length;
        for (T[] array : rest) {
            totalLength += array.length;
        }
        T[] result = Arrays.copyOf(first, totalLength);
        int offset = first.length;
        for (T[] array : rest) {
            System.arraycopy(array, 0, result, offset, array.length);
            offset += array.length;
        }
        return result;
    }

    public static boolean isBlank(byte[] data) {
        return null == data || 0 == data.length;
    }

    public static <T> boolean isBlank(List<T> data) {
        return null == data || data.isEmpty();
    }
}

