/*
 * Decompiled with CFR 0.152.
 */
package com.ruijc.util.serialize;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import com.ruijc.util.CollectionUtils;
import com.ruijc.util.serialize.ISerialize;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KryoSerializeImpl<T>
implements ISerialize<T> {
    private Kryo kryo = new Kryo();

    @Override
    public <T> T deserialize(byte[] bytes) {
        Object result;
        if (CollectionUtils.isBlank(bytes)) {
            return null;
        }
        try {
            result = this.kryo.readObject(new Input(bytes), Object.class);
        }
        catch (Exception e) {
            result = null;
        }
        return (T)result;
    }

    @Override
    public byte[] serialize(Object object) {
        byte[] byArray;
        if (object == null) {
            byte[] result = new byte[]{};
            return result;
        }
        Output output = new Output();
        try {
            this.kryo.writeObject(output, object);
        }
        catch (Exception e) {
            byArray = new byte[]{};
        }
        byArray = output.toBytes();
        return byArray;
    }
}

