/*
 * Decompiled with CFR 0.152.
 */
package com.ruijc.util;

import com.ruijc.util.StringUtils;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NumberUtils {
    public static int getInt(String data, int defaultValue) {
        int ret;
        try {
            ret = Integer.parseInt(data);
        }
        catch (NumberFormatException e) {
            ret = defaultValue;
        }
        return ret;
    }

    public static int getInt(String data) {
        return NumberUtils.getInt(data, 0);
    }

    public static double getDouble(String data) {
        double ret;
        try {
            ret = Double.parseDouble(data);
        }
        catch (NumberFormatException e) {
            ret = 0.0;
        }
        return ret;
    }

    public static List<Integer> getInts(String data) {
        return NumberUtils.getInts(data, ",");
    }

    public static List<Integer> getInts(String data, String space) {
        ArrayList<Integer> ints = new ArrayList<Integer>();
        String[] intArray = StringUtils.list(data, space);
        if (null == intArray || intArray.length == 0) {
            return ints;
        }
        for (String intString : intArray) {
            try {
                ints.add(Integer.parseInt(intString));
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        return ints;
    }
}

