/*
 * Decompiled with CFR 0.152.
 */
package com.ruijc.util;

import com.ruijc.util.bean.Href;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StringUtils {
    public static final String HTML_A_TAG_PATTERN = "(?i)<a([^>]+)>(.+?)</a>";
    public static final String HTML_A_HREF_TAG_PATTERN = "\\s*(?i)href\\s*=\\s*(\"([^\"]*\")|'[^']*'|([^'\">\\s]+))";
    private static final Pattern patternTag = Pattern.compile("(?i)<a([^>]+)>(.+?)</a>");
    private static final Pattern patternLink = Pattern.compile("\\s*(?i)href\\s*=\\s*(\"([^\"]*\")|'[^']*'|([^'\">\\s]+))");
    private static Matcher matcherTag;
    private static Matcher matcherLink;

    public static String getNicknameFromEmail(String email) {
        int index = email.indexOf(64);
        if (-1 != index) {
            return email.substring(0, index);
        }
        return email;
    }

    public static String emailServer(String email) {
        int index = email.indexOf(64);
        if (-1 != index) {
            return "http://mail." + email.substring(index + 1);
        }
        return email;
    }

    public static boolean isChinese(char c) {
        Character.UnicodeBlock ub = Character.UnicodeBlock.of(c);
        return ub == Character.UnicodeBlock.CJK_UNIFIED_IDEOGRAPHS || ub == Character.UnicodeBlock.CJK_COMPATIBILITY_IDEOGRAPHS || ub == Character.UnicodeBlock.CJK_UNIFIED_IDEOGRAPHS_EXTENSION_A || ub == Character.UnicodeBlock.GENERAL_PUNCTUATION || ub == Character.UnicodeBlock.CJK_SYMBOLS_AND_PUNCTUATION || ub == Character.UnicodeBlock.HALFWIDTH_AND_FULLWIDTH_FORMS;
    }

    public static boolean isMessyCode(String strName) {
        Pattern p = Pattern.compile("\\s*|\t*|\r*|\n*");
        Matcher m = p.matcher(strName);
        String after = m.replaceAll("");
        String temp = after.replaceAll("\\p{P}", "");
        char[] ch = temp.trim().toCharArray();
        float chLength = ch.length;
        float count = 0.0f;
        for (int i = 0; i < ch.length; ++i) {
            char c = ch[i];
            if (Character.isLetterOrDigit(c) || StringUtils.isChinese(c)) continue;
            count += 1.0f;
        }
        float result = count / chLength;
        return (double)result > 1.0E-13;
    }

    public static boolean isGBK(String str) {
        char[] chars = str.toCharArray();
        boolean isGBK = false;
        for (int i = 0; i < chars.length; ++i) {
            int[] ints;
            byte[] bytes = ("" + chars[i]).getBytes();
            if (bytes.length != 2 || (ints = new int[]{bytes[0] & 0xFF, bytes[1] & 0xFF})[0] < 129 || ints[0] > 254 || ints[1] < 64 || ints[1] > 254) continue;
            isGBK = true;
            break;
        }
        return isGBK;
    }

    public static String read(Reader reader) throws IOException {
        String line;
        BufferedReader br = new BufferedReader(reader);
        StringBuilder content = new StringBuilder();
        while ((line = br.readLine()) != null) {
            content.append(line);
            content.append("\r\n");
        }
        return content.toString();
    }

    public static Map<String, String> parseQuery(String query) {
        String[] tmps;
        HashMap<String, String> params = new HashMap<String, String>();
        if (!StringUtils.isBlank(query) && null != (tmps = query.split("&")) && tmps.length > 0) {
            for (String tmp : tmps) {
                if (StringUtils.isBlank(tmp)) continue;
                String[] keyValue = tmp.split("=");
                params.put(keyValue[0], keyValue[1]);
            }
        }
        return params;
    }

    public static String delSpace(String str) {
        if (str == null) {
            return "";
        }
        String regStartSpace = "^[\u3000 ]*";
        String regEndSpace = "[\u3000 ]*$";
        return str.replaceAll(regStartSpace, "").replaceAll(regEndSpace, "");
    }

    public static String trimEx(String str) {
        if (str == null) {
            return "";
        }
        str = StringUtils.delSpace(str);
        return str.replaceAll("\\s{2,}", " ");
    }

    public static String domain(String url) {
        String domain = "";
        if (null == url || "".equals(url)) {
            return "";
        }
        Pattern p = Pattern.compile("(?<=http://|\\.)[^.]*?\\.(com|cn|net|org|biz|info|cc|tv)", 2);
        Matcher matcher = p.matcher(url);
        while (matcher.find()) {
            domain = matcher.group();
        }
        return domain;
    }

    public static String substring(String from, int len, char append) {
        String key = "";
        if (null == from) {
            return key;
        }
        if (from.length() < len) {
            StringBuilder sb = new StringBuilder();
            sb.append(from);
            for (int i = 0; i < len - from.length(); ++i) {
                sb.append("0");
            }
            key = sb.toString();
        } else {
            key = from.substring(0, len);
        }
        return key;
    }

    public static String substring(String from, int len, String append) {
        int strLen = from.length();
        if (strLen <= len) {
            return from.substring(0, strLen);
        }
        return from.substring(0, len) + append;
    }

    public static String substring(String from, int len) {
        return StringUtils.substring(from, len, "...");
    }

    public static String replaceBlank(String str) {
        String dest = "";
        if (str != null) {
            Pattern p = Pattern.compile("\\s*|\t|\r|\n");
            Matcher m = p.matcher(str);
            dest = m.replaceAll("");
        }
        return dest;
    }

    public static String[] list(String content, String space) {
        if (null != content) {
            return content.split(space);
        }
        return new String[0];
    }

    public static String[] list(String content) {
        return StringUtils.list(content, ",");
    }

    public static String toString(Object obj) {
        if (null == obj) {
            return "";
        }
        return obj.toString();
    }

    public static String clearHTML(String from) {
        String regEx_script = "<script[^>]*?>[\\s\\S]*?<\\/script>";
        String regEx_style = "<style[^>]*?>[\\s\\S]*?<\\/style>";
        String regEx_html = "<[^>]+>";
        Pattern p_script = Pattern.compile(regEx_script, 2);
        Matcher m_script = p_script.matcher(from);
        from = m_script.replaceAll("");
        Pattern p_style = Pattern.compile(regEx_style, 2);
        Matcher m_style = p_style.matcher(from);
        from = m_style.replaceAll("");
        Pattern p_html = Pattern.compile(regEx_html, 2);
        Matcher m_html = p_html.matcher(from);
        from = m_html.replaceAll("");
        return from.trim();
    }

    public static boolean isBlank(String str) {
        return null == str || str.isEmpty();
    }

    public static boolean isAnyBlank(String ... strs) {
        for (String str : strs) {
            if (!StringUtils.isBlank(str)) continue;
            return true;
        }
        return false;
    }

    public static boolean isAllBlank(String ... strs) {
        for (String str : strs) {
            if (StringUtils.isBlank(str)) continue;
            return false;
        }
        return true;
    }

    public static boolean isAllEndsWith(String from, String ... withs) {
        for (String with : withs) {
            if (from.endsWith(with)) continue;
            return false;
        }
        return true;
    }

    public static boolean isAnyEndsWith(String from, String ... withs) {
        for (String with : withs) {
            if (!from.endsWith(with)) continue;
            return true;
        }
        return false;
    }

    public static String toAscii(String from) {
        StringBuilder sb = new StringBuilder();
        byte[] bt = from.getBytes();
        for (int i = 0; i < bt.length; ++i) {
            if (bt[i] < 0) {
                sb.append((char)(bt[i] & 0x7F));
                continue;
            }
            sb.append('\u0000');
            sb.append((char)bt[i]);
        }
        return sb.toString();
    }

    public static String fromAscii(String from) {
        int i;
        byte[] btAll = from.getBytes();
        int l = 0;
        int length = btAll.length;
        int j = 0;
        for (i = 0; i < length; ++i) {
            if (btAll[i] != 0) continue;
            ++l;
        }
        byte[] btTrue = new byte[length - l];
        for (i = 0; i < length; ++i) {
            btTrue[j] = btAll[i] == 0 ? btAll[++i] : (byte)(btAll[i] | 0x80);
            ++j;
        }
        String tt = new String(btTrue);
        return tt;
    }

    public static List<Href> getHrefs(String html) {
        ArrayList<Href> hrefs = new ArrayList<Href>();
        if (StringUtils.isBlank(html)) {
            return hrefs;
        }
        matcherTag = patternTag.matcher(html);
        while (matcherTag.find()) {
            String link = matcherTag.group(1);
            String text = matcherTag.group(2);
            matcherLink = patternLink.matcher(link);
            while (matcherLink.find()) {
                String url = matcherLink.group(1).replaceAll("\"", "").replaceAll("'", "");
                if (StringUtils.isBlank(url)) continue;
                hrefs.add(new Href(url, text));
            }
        }
        return hrefs;
    }

    public static void parseLink(String text, List<Map<String, String>> links) {
        List<Href> hrefs = StringUtils.getHrefs(text);
        if (null != hrefs && !hrefs.isEmpty()) {
            for (Href href : hrefs) {
                String link = href.getLink();
                if (StringUtils.isBlank(link) || -1 != link.indexOf("pan.baidu.com")) continue;
                HashMap<String, String> url = new HashMap<String, String>();
                url.put("url", link);
                url.put("name", href.getText());
                links.add(url);
            }
        }
    }

    public static String interval(String from, String insert, int interval) {
        StringBuilder ret = new StringBuilder();
        if (StringUtils.isBlank(from)) {
            return ret.toString();
        }
        int len = from.length();
        for (int index = 0; index < len; index += interval) {
            int end = index + interval;
            if (index >= len) {
                index = len - 1;
            }
            if (end >= len) {
                end = len - 1;
            }
            if (end == len - 1) {
                ret.append(from.subSequence(index, end));
                continue;
            }
            ret.append(from.subSequence(index, end));
            ret.append(insert);
        }
        return ret.toString();
    }

    public static String interval(String from, int interval) {
        return StringUtils.interval(from, "<br/>", interval);
    }

    public static String interval(String from, String insert) {
        return StringUtils.interval(from, insert, 30);
    }

    public static String interval(String from) {
        return StringUtils.interval(from, "<br/>", 30);
    }

    public static boolean check(String check, String patternString) {
        Pattern pattern = Pattern.compile(patternString);
        Matcher matcher = pattern.matcher(check);
        return matcher.find();
    }

    public static boolean check(String check, String ... patterns) {
        for (String patternString : patterns) {
            Pattern pattern = Pattern.compile(patternString);
            Matcher matcher = pattern.matcher(check);
            if (!matcher.find()) continue;
            return true;
        }
        return false;
    }

    public static boolean contains(String target, String test) {
        return StringUtils.contains(target, test, ",", ",");
    }

    public static boolean contains(String target, String test, String targetInterval, String testInterval) {
        if (StringUtils.isBlank(target)) {
            return false;
        }
        if (StringUtils.isBlank(test)) {
            return true;
        }
        String[] targetArray = target.split(targetInterval);
        if (null == targetArray || 0 == targetArray.length) {
            return false;
        }
        String[] testArray = test.split(testInterval);
        if (null == testArray || 0 == testArray.length) {
            return true;
        }
        for (String targetStr : targetArray) {
            for (String testStr : testArray) {
                if (StringUtils.isBlank(targetStr) || StringUtils.isBlank(testStr) || !targetStr.equals(testStr)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean containsAll(String content, String ... checks) {
        boolean contains = false;
        if (StringUtils.isBlank(content)) {
            return contains;
        }
        if (null == checks || 0 == checks.length) {
            contains = true;
            return contains;
        }
        for (String check : checks) {
            if (content.contains(check)) continue;
            contains = false;
            break;
        }
        return contains;
    }

    public static boolean containsAny(String content, String ... checks) {
        boolean contains = false;
        if (StringUtils.isBlank(content)) {
            return contains;
        }
        if (null == checks || 0 == checks.length) {
            contains = true;
            return contains;
        }
        for (String check : checks) {
            if (!content.contains(check)) continue;
            contains = true;
            break;
        }
        return contains;
    }

    public static String getString(String ... params) {
        String param;
        String ret = "";
        if (null == params || 0 == params.length) {
            return ret;
        }
        String[] stringArray = params;
        int n = stringArray.length;
        for (int i = 0; i < n && StringUtils.isBlank(ret = (param = stringArray[i])); ++i) {
        }
        return ret;
    }

    public static boolean contains(List<String> checks, String ... tests) {
        boolean contains = true;
        if (null == checks || checks.isEmpty()) {
            return contains;
        }
        for (String test : tests) {
            contains |= checks.contains(test);
        }
        return contains;
    }

    public static boolean containsNCS(List<String> checks, String test) {
        boolean contains = false;
        if (null == checks || checks.isEmpty() || StringUtils.isBlank(test)) {
            return contains;
        }
        for (String check : checks) {
            if (!check.toLowerCase().equals(test.toLowerCase())) continue;
            contains = true;
            break;
        }
        return contains;
    }

    public static String stackTrace(Throwable e) {
        StringBuilder sb = new StringBuilder();
        for (StackTraceElement element : e.getStackTrace()) {
            sb.append(element.toString());
            sb.append("\n");
        }
        return sb.toString();
    }

    public static String contact(Collection<String> strings, String contact) {
        String ret = "";
        if (null == strings || strings.isEmpty()) {
            return ret;
        }
        StringBuilder sb = new StringBuilder();
        for (String string : strings) {
            sb.append(string).append(contact);
        }
        ret = sb.substring(0, sb.length() - contact.length());
        return ret;
    }

    public static void main(String[] args) {
        System.err.println("--->" + StringUtils.interval("<a href='www.icoolxue.com'>Href1</a>Content<a href='video.icoolxue.com'>Href2</a>", "<br/>", 3));
    }
}

