/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package com.ruijc.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

/**
 * 映射工具类
 *
 * @author Storezhang
 */
public class MapUtils {

    public static int getInt(Map<Object, Object> dataMap, Object key) {
        int ret;
        Object data = dataMap.get(key);
        try {
            ret = Integer.parseInt(data.toString());
        } catch (NumberFormatException e) {
            ret = 0;
        }
        return ret;
    }

    public static double getDouble(Map<Object, Object> dataMap, Object key) {
        double ret;
        Object data = dataMap.get(key);
        try {
            ret = Double.parseDouble(data.toString());
        } catch (NumberFormatException e) {
            ret = 0;
        }
        return ret;
    }

    public static long getLong(Map<Object, Object> dataMap, Object key) {
        long ret;
        Object data = dataMap.get(key);
        try {
            ret = Long.parseLong(data.toString());
        } catch (NumberFormatException e) {
            ret = 0;
        }
        return ret;
    }

    public static String getString(Map<Object, Object> dataMap, Object key) {
        Object data = dataMap.get(key);
        return data.toString();
    }

    public static boolean check(Map<String, Boolean> data, String key) {
        boolean success;
        if (!data.containsKey(key)) {
            success = false;
        } else {
            success = data.get(key);
        }

        return success;
    }

    /**
     * 把数组所有元素排序，并按照“参数=参数值”的模式用逻辑与字符拼接成字符串
     *
     * @param params 需要排序并参与字符拼接的参数组
     * @return 拼接后字符串
     */
    public static String linkString(Map<String, String> params) {
        String ret = "";

        List<String> keys = new ArrayList<String>(params.keySet());
        Collections.sort(keys);

        for (int i = 0; i < keys.size(); i++) {
            String key = keys.get(i);
            String value = params.get(key);
            if (StringUtils.isBlank(value)) {
                continue;
            }

            if (i == keys.size() - 1) {//拼接时，不包括最后一个&字符
                ret = ret + key + "=" + value;
            } else {
                ret = ret + key + "=" + value + "&";
            }
        }

        return ret;
    }
}
