/*
 * Decompiled with CFR 0.152.
 */
package com.ruijc.fastjson;

import com.alibaba.fastjson.serializer.SerializerFeature;
import com.alibaba.fastjson.support.config.FastJsonConfig;
import com.ruijc.fastjson.FastJsonProperties;
import com.ruijc.fastjson.converter.FastJsonHttpMessageConverter;
import com.ruijc.util.CollectionUtils;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.autoconfigure.web.HttpMessageConverters;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnClass(name={"com.alibaba.fastjson.JSON"})
public class FastJsonAutoConfiguration {

    @Configuration
    @ConditionalOnClass(name={"com.alibaba.fastjson.support.spring.FastJsonHttpMessageConverter"})
    @ConditionalOnProperty(name={"spring.http.converters.preferred-json-mapper"}, havingValue="fastjson", matchIfMissing=true)
    @ConditionalOnWebApplication
    @EnableConfigurationProperties(value={FastJsonProperties.class})
    protected static class FastJson2HttpMessageConverterConfiguration {
        @Autowired
        private FastJsonProperties properties;

        protected FastJson2HttpMessageConverterConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean(value={com.alibaba.fastjson.support.spring.FastJsonHttpMessageConverter.class})
        public HttpMessageConverters customConverters(FastJsonHttpMessageConverter fastJsonHttpMessageConverter) {
            Object object;
            ArrayList<FastJsonHttpMessageConverter> arrayList = new ArrayList<FastJsonHttpMessageConverter>();
            if (fastJsonHttpMessageConverter == null) {
                object = this.properties.getConverter();
                fastJsonHttpMessageConverter = (FastJsonHttpMessageConverter)((Object)BeanUtils.instantiate(object));
            }
            object = new FastJsonConfig();
            List<SerializerFeature> list = this.properties.getFeatures();
            if (!CollectionUtils.isBlank(list)) {
                SerializerFeature[] serializerFeatureArray = new SerializerFeature[list.size()];
                object.setSerializerFeatures(list.toArray(serializerFeatureArray));
            }
            fastJsonHttpMessageConverter.setFastJsonConfig((FastJsonConfig)object);
            arrayList.add(fastJsonHttpMessageConverter);
            return new HttpMessageConverters(true, arrayList);
        }

        @Bean
        @ConditionalOnMissingBean(value={FastJsonHttpMessageConverter.class})
        public FastJsonHttpMessageConverter converter() {
            return new FastJsonHttpMessageConverter();
        }
    }
}

