/*
 * Decompiled with CFR 0.152.
 */
package com.ruijc.fastjson;

import com.alibaba.fastjson.serializer.SerializeFilter;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.alibaba.fastjson.serializer.ValueFilter;
import com.alibaba.fastjson.support.config.FastJsonConfig;
import com.alibaba.fastjson.support.spring.FastJsonHttpMessageConverter;
import com.ruijc.fastjson.FastJsonProperties;
import com.ruijc.fastjson.converter.MyFastJsonHttpMessageConverter;
import com.ruijc.util.CollectionUtils;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.autoconfigure.web.HttpMessageConverters;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnClass(name={"com.alibaba.fastjson.JSON"})
public class FastJsonAutoConfiguration {

    @Configuration
    @ConditionalOnClass(name={"com.alibaba.fastjson.support.spring.FastJsonHttpMessageConverter"})
    @ConditionalOnProperty(name={"spring.http.converters.preferred-json-mapper"}, havingValue="fastjson", matchIfMissing=true)
    @ConditionalOnWebApplication
    @EnableConfigurationProperties(value={FastJsonProperties.class})
    protected static class FastJson2HttpMessageConverterConfiguration {
        @Autowired
        private FastJsonProperties properties;

        protected FastJson2HttpMessageConverterConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean(value={FastJsonHttpMessageConverter.class})
        public HttpMessageConverters customConverters() {
            ArrayList<MyFastJsonHttpMessageConverter> messageConverters = new ArrayList<MyFastJsonHttpMessageConverter>();
            MyFastJsonHttpMessageConverter converter = new MyFastJsonHttpMessageConverter();
            FastJsonConfig config = new FastJsonConfig();
            List<String> features = this.properties.getFeatures();
            if (!CollectionUtils.isBlank(features)) {
                SerializerFeature[] featureArray = new SerializerFeature[features.size()];
                for (int i = 0; i < features.size(); ++i) {
                    try {
                        featureArray[i] = SerializerFeature.valueOf((String)features.get(i));
                        continue;
                    }
                    catch (IllegalArgumentException e) {
                        // empty catch block
                    }
                }
                config.setSerializerFeatures(featureArray);
            }
            config.setSerializeFilters(new SerializeFilter[]{new ValueFilter(){

                public Object process(Object o, String s, Object o1) {
                    if (null == o1) {
                        o1 = "";
                    }
                    return o1;
                }
            }});
            converter.setFastJsonConfig(config);
            messageConverters.add(converter);
            return new HttpMessageConverters(true, messageConverters);
        }
    }
}

