/*
 * Decompiled with CFR 0.152.
 */
package com.ruijc.fastjson;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializeFilter;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.alibaba.fastjson.support.spring.FastJsonHttpMessageConverter;
import com.ruijc.fastjson.FastjsonFilterWrapper;
import com.ruijc.fastjson.JSONP;
import java.io.IOException;
import java.io.OutputStream;
import org.springframework.http.HttpOutputMessage;
import org.springframework.http.converter.HttpMessageNotWritableException;

public class FastjsonHttpMessageConverter
extends FastJsonHttpMessageConverter {
    protected void writeInternal(Object obj, HttpOutputMessage output) throws IOException, HttpMessageNotWritableException {
        String text;
        if (obj instanceof JSONP) {
            JSONP jsonp = (JSONP)obj;
            text = jsonp.getFunction() + "(" + JSON.toJSONString((Object)jsonp.getJson(), (SerializerFeature[])this.getFastJsonConfig().getSerializerFeatures()) + ")";
        } else {
            FastjsonFilterWrapper wrapper;
            SerializeFilter[] filters;
            text = obj instanceof FastjsonFilterWrapper ? (null != (filters = (wrapper = (FastjsonFilterWrapper)obj).getFilters()) ? JSON.toJSONString((Object)wrapper.getObj(), (SerializeFilter[])filters, (SerializerFeature[])this.getFastJsonConfig().getSerializerFeatures()) : JSON.toJSONString((Object)wrapper.getObj(), (SerializerFeature[])this.getFastJsonConfig().getSerializerFeatures())) : JSON.toJSONString((Object)obj, (SerializerFeature[])this.getFastJsonConfig().getSerializerFeatures());
        }
        this.write(output, text);
    }

    public String getResult(String text) {
        return text;
    }

    public String getResult(Object obj) {
        return this.getResult(JSON.toJSONString((Object)obj));
    }

    private void write(HttpOutputMessage output, String text) throws IOException {
        OutputStream out = output.getBody();
        byte[] bytes = this.getResult(text).getBytes(this.getFastJsonConfig().getCharset());
        out.write(bytes);
    }
}

