/*
 * Decompiled with CFR 0.152.
 */
package com.rui.alphaplayer.utils;

import android.text.TextUtils;
import android.util.Log;
import com.google.gson.Gson;
import com.rui.alphaplayer.bean.MyAlphaAdConfigModel;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;

public class MyAlphaAdJsonUtils {
    private static final String TAG = "JsonUtil";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MyAlphaAdConfigModel parseConfigModel(String resourcePath) {
        String configFilePath;
        if (TextUtils.isEmpty((CharSequence)resourcePath)) {
            return null;
        }
        if (!new File(resourcePath).exists()) {
            return null;
        }
        String string = configFilePath = resourcePath.endsWith(File.separator) ? resourcePath + "config.json" : resourcePath + File.separator + "config.json";
        if (!new File(configFilePath).exists()) {
            return null;
        }
        FileInputStream fis = null;
        InputStreamReader isr = null;
        char[] input = null;
        try {
            fis = new FileInputStream(configFilePath);
            isr = new InputStreamReader((InputStream)fis, "UTF-8");
            input = new char[fis.available()];
            isr.read(input);
            isr.close();
            fis.close();
        }
        catch (IOException e) {
            Log.e((String)TAG, (String)("parse: " + e.toString()));
        }
        finally {
            try {
                if (isr != null) {
                    isr.close();
                }
                if (fis != null) {
                    fis.close();
                }
            }
            catch (IOException e) {
                Log.e((String)TAG, (String)("parse: " + e.toString()));
            }
        }
        if (input == null) {
            return null;
        }
        String configStr = new String(input);
        Gson gson = new Gson();
        return (MyAlphaAdConfigModel)gson.fromJson(configStr, MyAlphaAdConfigModel.class);
    }
}

