/*
 * Decompiled with CFR 0.152.
 */
package com.rui.alphaplayer;

import android.content.Context;
import android.net.Uri;
import android.util.Log;
import android.view.Surface;
import com.ss.ugc.android.alpha_player.model.VideoInfo;
import com.ss.ugc.android.alpha_player.player.AbsPlayer;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;
import tv.danmaku.ijk.media.player.IMediaPlayer;
import tv.danmaku.ijk.media.player.IjkMediaPlayer;

public class AlphaPlayer
extends AbsPlayer {
    private static final String TAG = "AlphaPlayer";
    private IjkMediaPlayer ijkMediaPlayer;
    private int currVideoWidth;
    private int currVideoHeight;
    private Context mContext;
    private boolean mEnableMediaCodec = false;
    private IMediaPlayer.OnErrorListener onErrorListener = new IMediaPlayer.OnErrorListener(){

        public boolean onError(IMediaPlayer iMediaPlayer, int i, int i1) {
            AlphaPlayer.this.errorListener.onError(0, 0, "ExoPlayer on error i:" + i + ",i1:" + i1);
            return false;
        }
    };
    private IMediaPlayer.OnVideoSizeChangedListener onVideoSizeChangedListener = new IMediaPlayer.OnVideoSizeChangedListener(){

        public void onVideoSizeChanged(IMediaPlayer iMediaPlayer, int i, int i1, int i2, int i3) {
            AlphaPlayer.this.currVideoWidth = i;
            AlphaPlayer.this.currVideoHeight = i1;
        }
    };
    private IMediaPlayer.OnPreparedListener onPreparedListener = new IMediaPlayer.OnPreparedListener(){

        public void onPrepared(IMediaPlayer iMediaPlayer) {
            Log.i((String)AlphaPlayer.TAG, (String)"onPrepared");
            AlphaPlayer.this.preparedListener.onPrepared();
        }
    };

    public AlphaPlayer(Context context) {
        this.mContext = context;
    }

    public boolean isEnableMediaCodec() {
        return this.mEnableMediaCodec;
    }

    public void setEnableMediaCodec(boolean mEnableMediaCodec) {
        this.mEnableMediaCodec = mEnableMediaCodec;
    }

    @NotNull
    public String getPlayerType() {
        return TAG;
    }

    @NotNull
    public VideoInfo getVideoInfo() throws Exception {
        return new VideoInfo(this.currVideoWidth, this.currVideoHeight);
    }

    public void initMediaPlayer() throws Exception {
        this.ijkMediaPlayer = new IjkMediaPlayer();
        this.ijkMediaPlayer.setOption(4, "opensles", 1L);
        this.ijkMediaPlayer.setOption(4, "overlay-format", 842225234L);
        this.ijkMediaPlayer.setOption(4, "framedrop", 1L);
        this.ijkMediaPlayer.setOption(4, "start-on-prepared", 0L);
        this.ijkMediaPlayer.setOption(4, "http-detect-range-support", 1L);
        this.ijkMediaPlayer.setOption(2, "skip_loop_filter", 48L);
        this.ijkMediaPlayer.setOption(2, "min-frames", 100L);
        this.ijkMediaPlayer.setOption(4, "enable-accurate-seek", 1L);
        this.ijkMediaPlayer.setVolume(1.0f, 1.0f);
        this.setEnableMediaCodec(this.ijkMediaPlayer, this.mEnableMediaCodec);
        this.ijkMediaPlayer.setOnInfoListener(new IMediaPlayer.OnInfoListener(){

            public boolean onInfo(IMediaPlayer iMediaPlayer, int i, int i1) {
                Log.i((String)AlphaPlayer.TAG, (String)("onInfo:" + i + ",i1:" + i1));
                if (i == 3) {
                    AlphaPlayer.this.firstFrameListener.onFirstFrame();
                }
                return false;
            }
        });
        this.ijkMediaPlayer.setOnPreparedListener(this.onPreparedListener);
        this.ijkMediaPlayer.setOnVideoSizeChangedListener(this.onVideoSizeChangedListener);
        this.ijkMediaPlayer.setOnErrorListener(this.onErrorListener);
        this.ijkMediaPlayer.setLogEnabled(true);
        this.ijkMediaPlayer.setOnCompletionListener(new IMediaPlayer.OnCompletionListener(){

            public void onCompletion(IMediaPlayer iMediaPlayer) {
                AlphaPlayer.this.completionListener.onCompletion();
            }
        });
        this.ijkMediaPlayer.setOnBufferingUpdateListener(new IMediaPlayer.OnBufferingUpdateListener(){

            public void onBufferingUpdate(IMediaPlayer iMediaPlayer, int i) {
                Log.i((String)AlphaPlayer.TAG, (String)("onBufferingUpdate i:" + i));
            }
        });
    }

    private void setEnableMediaCodec(IjkMediaPlayer ijkMediaPlayer, boolean isEnable) {
        int value = isEnable ? 1 : 0;
        ijkMediaPlayer.setOption(4, "mediacodec", (long)value);
        ijkMediaPlayer.setOption(4, "mediacodec-auto-rotate", (long)value);
        ijkMediaPlayer.setOption(4, "mediacodec-handle-resolution-change", (long)value);
    }

    public void pause() {
        this.ijkMediaPlayer.pause();
    }

    public void prepareAsync() {
        this.ijkMediaPlayer.prepareAsync();
    }

    public void release() {
        this.ijkMediaPlayer.release();
    }

    public void reset() {
        this.ijkMediaPlayer.stop();
    }

    public void setDataSource(@NotNull String dataPath) throws IOException {
        Log.i((String)TAG, (String)("dataPath:" + dataPath));
        this.ijkMediaPlayer.setDataSource(this.mContext, Uri.parse((String)dataPath), null);
    }

    public void setLooping(boolean looping) {
    }

    public void setScreenOnWhilePlaying(boolean b) {
    }

    public void setSurface(@NotNull Surface surface) {
        this.ijkMediaPlayer.setSurface(surface);
    }

    public void start() {
        this.ijkMediaPlayer.start();
    }

    public void stop() {
        this.ijkMediaPlayer.stop();
    }
}

