/*
 * Decompiled with CFR 0.152.
 */
package com.rui.alphaplayer;

import android.arch.lifecycle.LifecycleOwner;
import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.RelativeLayout;
import com.rui.alphaplayer.AlphaPlayer;
import com.rui.alphaplayer.R;
import com.rui.alphaplayer.bean.AlphaAdConfigModel;
import com.rui.alphaplayer.utils.AlphaAdJsonUtils;
import com.ss.ugc.android.alpha_player.IMonitor;
import com.ss.ugc.android.alpha_player.IPlayerAction;
import com.ss.ugc.android.alpha_player.controller.PlayerController;
import com.ss.ugc.android.alpha_player.model.AlphaVideoViewType;
import com.ss.ugc.android.alpha_player.model.Configuration;
import com.ss.ugc.android.alpha_player.model.DataSource;
import com.ss.ugc.android.alpha_player.player.IMediaPlayer;
import java.io.File;

public class AlphaPlayerView
extends FrameLayout {
    private static final String TAG = "AlphaPlayerView";
    private Context mContext;
    private RelativeLayout mVideoContainer;
    private AlphaVideoViewType mViewType = AlphaVideoViewType.GL_SURFACE_VIEW;
    private PlayerController mPlayerController;
    private Configuration mPlayConfiguration;
    private boolean mEnableMediaCodec = false;
    private AlphaPlayer mAlphaPlayer;
    private IPlayerAction iPlayerAction;
    private IMonitor iMonitor;

    public AlphaPlayerView(@NonNull Context context) {
        super(context);
        this.mContext = context;
        this.initView();
    }

    public AlphaPlayerView(@NonNull Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.mContext = context;
        this.initView();
    }

    public AlphaPlayerView(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.mContext = context;
        this.initView();
    }

    public void initView() {
        LayoutInflater.from((Context)this.mContext).inflate(R.layout.view_player, (ViewGroup)this);
        this.mVideoContainer = (RelativeLayout)this.findViewById(R.id.alpha_play_view);
        this.mAlphaPlayer = new AlphaPlayer(this.mContext);
    }

    public void initController(LifecycleOwner lifecycleOwner) {
        if (this.mPlayConfiguration == null) {
            this.mPlayConfiguration = new Configuration(this.mContext, lifecycleOwner);
            this.mPlayConfiguration.setAlphaVideoViewType(this.mViewType);
        }
        if (this.mPlayerController == null && this.mAlphaPlayer != null) {
            this.mAlphaPlayer.setEnableMediaCodec(this.mEnableMediaCodec);
            this.mPlayerController = new PlayerController(this.mContext, lifecycleOwner, this.mPlayConfiguration.getAlphaVideoViewType(), (IMediaPlayer)this.mAlphaPlayer);
            if (this.iPlayerAction != null) {
                this.mPlayerController.setPlayerAction(this.iPlayerAction);
            }
            if (this.iMonitor != null) {
                this.mPlayerController.setMonitor(this.iMonitor);
            }
        }
    }

    public void play(String videoPath) {
        if (TextUtils.isEmpty((CharSequence)videoPath)) {
            Log.e((String)TAG, (String)"videopath is null");
            return;
        }
        File dirFile = new File(videoPath);
        if (!dirFile.exists()) {
            dirFile.mkdirs();
        }
        this.attachPlayView();
        AlphaAdConfigModel configModel = AlphaAdJsonUtils.parseConfigModel(dirFile.getAbsolutePath());
        DataSource mDataSource = new DataSource();
        mDataSource.baseDir = videoPath;
        mDataSource.setPortraitPath(configModel.getPortraitItem().getPath(), configModel.getPortraitItem().getAlignMode());
        mDataSource.setLandscapePath(configModel.getLandscapeItem().getPath(), configModel.getLandscapeItem().getAlignMode());
        if (mDataSource.isValid()) {
            this.mPlayerController.start(mDataSource);
        }
    }

    public void attachPlayView() {
        if (this.mPlayerController != null) {
            this.mPlayerController.attachAlphaView((ViewGroup)this.mVideoContainer);
        }
    }

    public void detachPlayView() {
        if (this.mPlayerController != null) {
            this.mPlayerController.detachAlphaView((ViewGroup)this.mVideoContainer);
        }
    }

    public void releasePlayController() {
        if (this.mPlayerController != null) {
            this.detachPlayView();
            this.mPlayerController.release();
        }
    }

    public AlphaVideoViewType getViewType() {
        return this.mViewType;
    }

    public void setViewType(AlphaVideoViewType mViewType) {
        this.mViewType = mViewType;
    }

    public boolean isEnableMediaCodec() {
        return this.mEnableMediaCodec;
    }

    public void setEnableMediaCodec(boolean mEnableMediaCodec) {
        this.mEnableMediaCodec = mEnableMediaCodec;
    }

    public IPlayerAction getIPlayerAction() {
        return this.iPlayerAction;
    }

    public void setIPlayerAction(IPlayerAction mIPlayerAction) {
        this.iPlayerAction = mIPlayerAction;
    }

    public IMonitor getMonitor() {
        return this.iMonitor;
    }

    public void setMonitor(IMonitor iMonitor) {
        this.iMonitor = iMonitor;
    }
}

