/*
 * Decompiled with CFR 0.152.
 */
package com.roughike.swipeselector;

import android.animation.ObjectAnimator;
import android.content.Context;
import android.content.res.AssetManager;
import android.graphics.Typeface;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.ShapeDrawable;
import android.os.Build;
import android.os.Bundle;
import android.support.v4.content.ContextCompat;
import android.support.v4.view.PagerAdapter;
import android.support.v4.view.ViewPager;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.roughike.swipeselector.Indicator;
import com.roughike.swipeselector.OnSwipeItemSelectedListener;
import com.roughike.swipeselector.PixelUtils;
import com.roughike.swipeselector.R;
import com.roughike.swipeselector.SwipeItem;
import java.util.ArrayList;
import java.util.Arrays;

class SwipeAdapter
extends PagerAdapter
implements View.OnClickListener,
ViewPager.OnPageChangeListener {
    private static final String STATE_CURRENT_POSITION = "STATE_CURRENT_POSITION";
    private static final String TAG_CIRCLE = "TAG_CIRCLE";
    private static final String TAG_HIDDEN = "TAG_HIDDEN";
    private final Context mContext;
    private final ViewPager mViewPager;
    private final ViewGroup mIndicatorContainer;
    private final LinearLayout.LayoutParams mCircleParams;
    private final ShapeDrawable mInActiveCircleDrawable;
    private final ShapeDrawable mActiveCircleDrawable;
    private Typeface mCustomTypeFace;
    private final int mTitleTextAppearance;
    private final int mDescriptionTextAppearance;
    private final int mDescriptionGravity;
    private final ImageView mLeftButton;
    private final ImageView mRightButton;
    private final int mSweetSixteen;
    private final int mContentLeftPadding;
    private final int mContentRightPadding;
    private OnSwipeItemSelectedListener mOnItemSelectedListener;
    private ArrayList<SwipeItem> mItems;
    private int mCurrentPosition;

    private SwipeAdapter(ViewPager viewPager, ViewGroup indicatorContainer, int indicatorSize, int indicatorMargin, int inActiveIndicatorColor, int activeIndicatorColor, int leftButtonResource, int rightButtonResource, ImageView leftButton, ImageView rightButton, String customFontPath, int titleTextAppearance, int descriptionTextAppearance, int descriptionGravity) {
        this.mContext = viewPager.getContext();
        this.mViewPager = viewPager;
        this.mViewPager.addOnPageChangeListener((ViewPager.OnPageChangeListener)this);
        this.mIndicatorContainer = indicatorContainer;
        this.mCircleParams = new LinearLayout.LayoutParams(indicatorSize, indicatorSize);
        this.mCircleParams.leftMargin = indicatorMargin;
        this.mInActiveCircleDrawable = Indicator.newOne(indicatorSize, inActiveIndicatorColor);
        this.mActiveCircleDrawable = Indicator.newOne(indicatorSize, activeIndicatorColor);
        if (customFontPath != null && (Build.VERSION.SDK_INT >= 11 && !customFontPath.isEmpty() || customFontPath.length() > 0)) {
            this.mCustomTypeFace = Typeface.createFromAsset((AssetManager)this.mContext.getAssets(), (String)customFontPath);
        }
        this.mTitleTextAppearance = titleTextAppearance;
        this.mDescriptionTextAppearance = descriptionTextAppearance;
        this.mDescriptionGravity = this.getGravity(descriptionGravity);
        this.mLeftButton = leftButton;
        this.mLeftButton.setImageResource(leftButtonResource);
        this.mRightButton = rightButton;
        this.mRightButton.setImageResource(rightButtonResource);
        this.mSweetSixteen = (int)PixelUtils.dpToPixel(this.mContext, 16.0f);
        this.mContentLeftPadding = ContextCompat.getDrawable((Context)this.mContext, (int)leftButtonResource).getIntrinsicWidth() + this.mSweetSixteen;
        this.mContentRightPadding = ContextCompat.getDrawable((Context)this.mContext, (int)rightButtonResource).getIntrinsicWidth() + this.mSweetSixteen;
        this.mLeftButton.setOnClickListener((View.OnClickListener)this);
        this.mRightButton.setOnClickListener((View.OnClickListener)this);
        this.mLeftButton.setTag((Object)TAG_HIDDEN);
        this.mLeftButton.setClickable(false);
        this.setAlpha(0.0f, this.mLeftButton);
    }

    protected void setOnItemSelectedListener(OnSwipeItemSelectedListener listener) {
        this.mOnItemSelectedListener = listener;
    }

    protected void setItems(SwipeItem ... items) {
        if (SwipeItem.checkForStringResources) {
            ArrayList<SwipeItem> theRealOnes = new ArrayList<SwipeItem>();
            for (SwipeItem item : items) {
                if (item.titleRes != -1) {
                    item.title = this.mContext.getString(item.titleRes);
                }
                if (item.descriptionRes != -1) {
                    item.description = this.mContext.getString(item.descriptionRes);
                }
                theRealOnes.add(item);
            }
            this.mItems = theRealOnes;
            SwipeItem.checkForStringResources = false;
        } else {
            this.mItems = new ArrayList<SwipeItem>(Arrays.asList(items));
        }
        this.mCurrentPosition = 0;
        this.setActiveIndicator(0);
        this.notifyDataSetChanged();
    }

    protected SwipeItem getSelectedItem() {
        return this.mItems.get(this.mCurrentPosition);
    }

    public void selectItemAt(int position, boolean animate) {
        if (position < 0 || position >= this.mItems.size()) {
            throw new IndexOutOfBoundsException("This SwipeSelector does not have an item at position " + position + ".");
        }
        this.mViewPager.setCurrentItem(position, animate);
    }

    public void selectItemWithValue(Object value, boolean animate) {
        boolean itemExists = false;
        for (int i = 0; i < this.mItems.size(); ++i) {
            if (!this.mItems.get((int)i).value.equals(value)) continue;
            this.mViewPager.setCurrentItem(i, animate);
            itemExists = true;
            break;
        }
        if (!itemExists) {
            throw new IllegalArgumentException("This SwipeSelector does not have an item with the given value " + value.toString() + ".");
        }
    }

    protected Bundle onSaveInstanceState() {
        Bundle bundle = new Bundle();
        bundle.putInt(STATE_CURRENT_POSITION, this.mCurrentPosition);
        return bundle;
    }

    protected void onRestoreInstanceState(Bundle state) {
        this.mViewPager.setCurrentItem(state.getInt(STATE_CURRENT_POSITION), false);
        this.notifyDataSetChanged();
    }

    public Object instantiateItem(ViewGroup container, int position) {
        LinearLayout layout2 = (LinearLayout)View.inflate((Context)this.mContext, (int)R.layout.swipeselector_content_item, null);
        TextView title = (TextView)layout2.findViewById(R.id.swipeselector_content_title);
        TextView description = (TextView)layout2.findViewById(R.id.swipeselector_content_description);
        SwipeItem slideItem = this.mItems.get(position);
        title.setText((CharSequence)slideItem.title);
        if (slideItem.description == null) {
            description.setVisibility(8);
        } else {
            description.setVisibility(0);
            description.setText((CharSequence)slideItem.description);
        }
        if (this.mCustomTypeFace != null) {
            title.setTypeface(this.mCustomTypeFace);
            description.setTypeface(this.mCustomTypeFace);
        }
        if (this.mTitleTextAppearance != -1) {
            this.setTextAppearanceCompat(title, this.mTitleTextAppearance);
        }
        if (this.mDescriptionTextAppearance != -1) {
            this.setTextAppearanceCompat(description, this.mDescriptionTextAppearance);
        }
        if (this.mDescriptionGravity != -1) {
            description.setGravity(this.mDescriptionGravity);
        }
        layout2.setPadding(this.mContentLeftPadding, this.mSweetSixteen, this.mContentRightPadding, this.mSweetSixteen);
        container.addView((View)layout2);
        return layout2;
    }

    public void destroyItem(ViewGroup container, int position, Object object) {
        container.removeView((View)object);
    }

    public int getCount() {
        return this.mItems != null ? this.mItems.size() : 0;
    }

    public boolean isViewFromObject(View view, Object object) {
        return view.equals(object);
    }

    public void onPageSelected(int position) {
        if (this.getCount() == 0) {
            return;
        }
        this.setActiveIndicator(position);
        this.handleLeftButtonVisibility(position);
        this.handleRightButtonVisibility(position);
    }

    public void onClick(View v) {
        if (v.equals(this.mLeftButton) && this.mCurrentPosition >= 1) {
            this.mViewPager.setCurrentItem(this.mCurrentPosition - 1, true);
        } else if (v.equals(this.mRightButton) && this.mCurrentPosition <= this.getCount() - 1) {
            this.mViewPager.setCurrentItem(this.mCurrentPosition + 1, true);
        }
    }

    public void onPageScrolled(int position, float positionOffset, int positionOffsetPixels) {
    }

    public void onPageScrollStateChanged(int state) {
    }

    private void setActiveIndicator(int position) {
        if (this.mIndicatorContainer.findViewWithTag((Object)TAG_CIRCLE) == null) {
            for (int i = 0; i < this.getCount(); ++i) {
                ImageView indicator = (ImageView)View.inflate((Context)this.mContext, (int)R.layout.swipeselector_circle_item, null);
                if (i == position) {
                    indicator.setImageDrawable((Drawable)this.mActiveCircleDrawable);
                } else {
                    indicator.setImageDrawable((Drawable)this.mInActiveCircleDrawable);
                }
                indicator.setLayoutParams((ViewGroup.LayoutParams)this.mCircleParams);
                indicator.setTag((Object)TAG_CIRCLE);
                this.mIndicatorContainer.addView((View)indicator);
            }
            return;
        }
        ImageView previousActiveIndicator = (ImageView)this.mIndicatorContainer.getChildAt(this.mCurrentPosition);
        ImageView nextActiveIndicator = (ImageView)this.mIndicatorContainer.getChildAt(position);
        previousActiveIndicator.setImageDrawable((Drawable)this.mInActiveCircleDrawable);
        nextActiveIndicator.setImageDrawable((Drawable)this.mActiveCircleDrawable);
        this.mCurrentPosition = position;
        if (this.mOnItemSelectedListener != null) {
            this.mOnItemSelectedListener.onItemSelected(this.getSelectedItem());
        }
    }

    private void setTextAppearanceCompat(TextView textView, int appearanceRes) {
        if (Build.VERSION.SDK_INT >= 23) {
            textView.setTextAppearance(appearanceRes);
        } else {
            textView.setTextAppearance(textView.getContext(), appearanceRes);
        }
    }

    private int getGravity(int gravity) {
        int realGravityValue;
        if (gravity == -1) {
            return -1;
        }
        switch (gravity) {
            case 0: {
                realGravityValue = 0x800003;
                break;
            }
            case 1: {
                realGravityValue = 1;
                break;
            }
            case 2: {
                realGravityValue = 0x800005;
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid value specified for swipe_descriptionGravity. Use \"left\", \"center\", \"right\" or leave blank for default.");
            }
        }
        return realGravityValue;
    }

    private void handleLeftButtonVisibility(int position) {
        if (position < 1) {
            this.mLeftButton.setTag((Object)TAG_HIDDEN);
            this.mLeftButton.setClickable(false);
            this.animate(0.0f, this.mLeftButton);
        } else if (TAG_HIDDEN.equals(this.mLeftButton.getTag())) {
            this.mLeftButton.setTag(null);
            this.mLeftButton.setClickable(true);
            this.animate(1.0f, this.mLeftButton);
        }
    }

    private void handleRightButtonVisibility(int position) {
        if (position == this.getCount() - 1) {
            this.mRightButton.setTag((Object)TAG_HIDDEN);
            this.mRightButton.setClickable(false);
            this.animate(0.0f, this.mRightButton);
        } else if (TAG_HIDDEN.equals(this.mRightButton.getTag())) {
            this.mRightButton.setTag(null);
            this.mRightButton.setClickable(true);
            this.animate(1.0f, this.mRightButton);
        }
    }

    private void animate(float alpha, ImageView button) {
        if (Build.VERSION.SDK_INT >= 14) {
            button.animate().alpha(alpha).setDuration(120L).start();
        } else if (Build.VERSION.SDK_INT >= 12) {
            ObjectAnimator.ofFloat((Object)button, (String)"alpha", (float[])new float[]{alpha == 1.0f ? 0.0f : alpha, alpha == 1.0f ? alpha : 0.0f}).setDuration(120L).start();
        } else {
            this.setAlpha(alpha, button);
        }
    }

    private void setAlpha(float alpha, ImageView button) {
        if (Build.VERSION.SDK_INT >= 11) {
            button.setAlpha(alpha);
        } else {
            button.setAlpha((int)(alpha * 255.0f));
        }
    }

    protected static class Builder {
        private ViewPager viewPager;
        private ViewGroup indicatorContainer;
        private int indicatorSize;
        private int indicatorMargin;
        private int inActiveIndicatorColor;
        private int activeIndicatorColor;
        private int leftButtonResource;
        private int rightButtonResource;
        private ImageView leftButton;
        private ImageView rightButton;
        private String customFontPath;
        private int titleTextAppearance;
        private int descriptionTextAppearance;
        private int descriptionGravity;

        protected Builder() {
        }

        protected Builder viewPager(ViewPager viewPager) {
            this.viewPager = viewPager;
            return this;
        }

        protected Builder indicatorContainer(ViewGroup indicatorContainer) {
            this.indicatorContainer = indicatorContainer;
            return this;
        }

        protected Builder indicatorSize(int indicatorSize) {
            this.indicatorSize = indicatorSize;
            return this;
        }

        protected Builder indicatorMargin(int indicatorMargin) {
            this.indicatorMargin = indicatorMargin;
            return this;
        }

        protected Builder inActiveIndicatorColor(int inActiveIndicatorColor) {
            this.inActiveIndicatorColor = inActiveIndicatorColor;
            return this;
        }

        protected Builder activeIndicatorColor(int activeIndicatorColor) {
            this.activeIndicatorColor = activeIndicatorColor;
            return this;
        }

        protected Builder leftButtonResource(int leftButtonResource) {
            this.leftButtonResource = leftButtonResource;
            return this;
        }

        protected Builder rightButtonResource(int rightButtonResource) {
            this.rightButtonResource = rightButtonResource;
            return this;
        }

        protected Builder leftButton(ImageView leftButton) {
            this.leftButton = leftButton;
            return this;
        }

        protected Builder rightButton(ImageView rightButton) {
            this.rightButton = rightButton;
            return this;
        }

        protected Builder customFontPath(String customFontPath) {
            this.customFontPath = customFontPath;
            return this;
        }

        protected Builder titleTextAppearance(int titleTextAppearance) {
            this.titleTextAppearance = titleTextAppearance;
            return this;
        }

        protected Builder descriptionTextAppearance(int descriptionTextAppearance) {
            this.descriptionTextAppearance = descriptionTextAppearance;
            return this;
        }

        protected Builder descriptionGravity(int descriptionGravity) {
            this.descriptionGravity = descriptionGravity;
            return this;
        }

        protected SwipeAdapter build() {
            return new SwipeAdapter(this.viewPager, this.indicatorContainer, this.indicatorSize, this.indicatorMargin, this.inActiveIndicatorColor, this.activeIndicatorColor, this.leftButtonResource, this.rightButtonResource, this.leftButton, this.rightButton, this.customFontPath, this.titleTextAppearance, this.descriptionTextAppearance, this.descriptionGravity);
        }
    }
}

