/*
 * Decompiled with CFR 0.152.
 */
package com.roughike.swipeselector;

import android.annotation.TargetApi;
import android.content.Context;
import android.content.res.TypedArray;
import android.support.v4.content.ContextCompat;
import android.support.v4.view.PagerAdapter;
import android.support.v4.view.ViewPager;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ImageView;
import com.roughike.swipeselector.OnSwipeItemSelectedListener;
import com.roughike.swipeselector.PixelUtils;
import com.roughike.swipeselector.R;
import com.roughike.swipeselector.SwipeAdapter;
import com.roughike.swipeselector.SwipeItem;

public class SwipeSelector
extends FrameLayout {
    private static final int DEFAULT_INDICATOR_SIZE = 6;
    private static final int DEFAULT_INDICATOR_MARGIN = 8;
    private SwipeAdapter mAdapter;

    public SwipeSelector(Context context) {
        super(context);
        this.init(context, null, 0, 0);
    }

    public SwipeSelector(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(context, attrs, 0, 0);
    }

    public SwipeSelector(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context, attrs, defStyleAttr, 0);
    }

    @TargetApi(value=21)
    public SwipeSelector(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.init(context, attrs, defStyleAttr, defStyleRes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        int descriptionGravity;
        int descriptionTextAppearance;
        int titleTextAppearance;
        String customFontPath;
        int rightButtonResource;
        int leftButtonResource;
        int indicatorActiveColor;
        int indicatorInActiveColor;
        int indicatorMargin;
        int indicatorSize;
        TypedArray ta = context.getTheme().obtainStyledAttributes(attrs, R.styleable.SwipeSelector, defStyleAttr, defStyleRes);
        try {
            indicatorSize = (int)ta.getDimension(R.styleable.SwipeSelector_swipe_indicatorSize, PixelUtils.dpToPixel(context, 6.0f));
            indicatorMargin = (int)ta.getDimension(R.styleable.SwipeSelector_swipe_indicatorMargin, PixelUtils.dpToPixel(context, 8.0f));
            indicatorInActiveColor = ta.getColor(R.styleable.SwipeSelector_swipe_indicatorInActiveColor, ContextCompat.getColor((Context)context, (int)R.color.swipeselector_color_indicator_inactive));
            indicatorActiveColor = ta.getColor(R.styleable.SwipeSelector_swipe_indicatorActiveColor, ContextCompat.getColor((Context)context, (int)R.color.swipeselector_color_indicator_active));
            leftButtonResource = ta.getResourceId(R.styleable.SwipeSelector_swipe_leftButtonResource, R.drawable.ic_action_navigation_chevron_left);
            rightButtonResource = ta.getResourceId(R.styleable.SwipeSelector_swipe_rightButtonResource, R.drawable.ic_action_navigation_chevron_right);
            customFontPath = ta.getString(R.styleable.SwipeSelector_swipe_customFontPath);
            titleTextAppearance = ta.getResourceId(R.styleable.SwipeSelector_swipe_titleTextAppearance, -1);
            descriptionTextAppearance = ta.getResourceId(R.styleable.SwipeSelector_swipe_descriptionTextAppearance, -1);
            descriptionGravity = ta.getInteger(R.styleable.SwipeSelector_swipe_descriptionGravity, -1);
        }
        finally {
            ta.recycle();
        }
        LayoutInflater inflater = LayoutInflater.from((Context)context);
        inflater.inflate(R.layout.swipeselector_layout, (ViewGroup)this);
        ViewPager pager = (ViewPager)this.findViewById(R.id.swipeselector_layout_swipePager);
        ViewGroup indicatorContainer = (ViewGroup)this.findViewById(R.id.swipeselector_layout_circleContainer);
        ImageView leftButton = (ImageView)this.findViewById(R.id.swipeselector_layout_leftButton);
        ImageView rightButton = (ImageView)this.findViewById(R.id.swipeselector_layout_rightButton);
        this.mAdapter = new SwipeAdapter.Builder().viewPager(pager).indicatorContainer(indicatorContainer).indicatorSize(indicatorSize).indicatorMargin(indicatorMargin).inActiveIndicatorColor(indicatorInActiveColor).activeIndicatorColor(indicatorActiveColor).leftButtonResource(leftButtonResource).rightButtonResource(rightButtonResource).leftButton(leftButton).rightButton(rightButton).customFontPath(customFontPath).titleTextAppearance(titleTextAppearance).descriptionTextAppearance(descriptionTextAppearance).descriptionGravity(descriptionGravity).build();
        pager.setAdapter((PagerAdapter)this.mAdapter);
    }

    public void setOnItemSelectedListener(OnSwipeItemSelectedListener listener) {
        this.mAdapter.setOnItemSelectedListener(listener);
    }

    public void setItems(SwipeItem ... swipeItems) {
        this.mAdapter.setItems(swipeItems);
    }

    public SwipeItem getSelectedItem() {
        if (this.mAdapter.getCount() == 0) {
            throw new UnsupportedOperationException("The SwipeSelector doesn't have any items! Use the setItems() method for setting the items before calling getSelectedItem().");
        }
        return this.mAdapter.getSelectedItem();
    }
}

