/*
 * Decompiled with CFR 0.152.
 */
package com.roughike.swipeselector;

import android.annotation.TargetApi;
import android.content.Context;
import android.content.res.TypedArray;
import android.support.v4.content.ContextCompat;
import android.support.v4.view.PagerAdapter;
import android.support.v4.view.ViewPager;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import com.roughike.swipeselector.OnSwipeItemSelectedListener;
import com.roughike.swipeselector.PixelUtils;
import com.roughike.swipeselector.R;
import com.roughike.swipeselector.SwipeAdapter;
import com.roughike.swipeselector.SwipeItem;

public class SwipeSelector
extends FrameLayout {
    private static final int DEFAULT_INDICATOR_SIZE = 6;
    private static final int DEFAULT_INDICATOR_MARGIN = 8;
    private ViewPager mPager;
    private SwipeAdapter mAdapter;
    private int mIndicatorSize;
    private int mIndicatorMargin;
    private int mIndicatorInActiveColor;
    private int mIndicatorActiveColor;

    public SwipeSelector(Context context) {
        super(context);
        this.init(context, null, 0, 0);
    }

    public SwipeSelector(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(context, attrs, 0, 0);
    }

    public SwipeSelector(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context, attrs, defStyleAttr, 0);
    }

    @TargetApi(value=21)
    public SwipeSelector(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.init(context, attrs, defStyleAttr, defStyleRes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        TypedArray ta = context.getTheme().obtainStyledAttributes(attrs, R.styleable.SwipeSelector, defStyleAttr, defStyleRes);
        try {
            this.mIndicatorSize = (int)ta.getDimension(R.styleable.SwipeSelector_swipe_indicatorSize, PixelUtils.dpToPixel(context, 6.0f));
            this.mIndicatorMargin = (int)ta.getDimension(R.styleable.SwipeSelector_swipe_indicatorMargin, PixelUtils.dpToPixel(context, 8.0f));
            this.mIndicatorInActiveColor = ta.getColor(R.styleable.SwipeSelector_swipe_indicatorInActiveColor, ContextCompat.getColor((Context)context, (int)R.color.swipeselector_color_indicator_inactive));
            this.mIndicatorActiveColor = ta.getColor(R.styleable.SwipeSelector_swipe_indicatorActiveColor, ContextCompat.getColor((Context)context, (int)R.color.swipeselector_color_indicator_active));
        }
        finally {
            ta.recycle();
        }
        LayoutInflater inflater = LayoutInflater.from((Context)context);
        inflater.inflate(R.layout.swipeselector_layout, (ViewGroup)this);
        this.mPager = (ViewPager)this.findViewById(R.id.swipeselector_layout_swipePager);
        this.mAdapter = new SwipeAdapter(this.mPager, (ViewGroup)this.findViewById(R.id.swipeselector_layout_circleContainer), this.mIndicatorSize, this.mIndicatorMargin, this.mIndicatorInActiveColor, this.mIndicatorActiveColor, this.findViewById(R.id.swipeselector_layout_leftButton), this.findViewById(R.id.swipeselector_layout_rightButton));
        this.mPager.setAdapter((PagerAdapter)this.mAdapter);
    }

    public void setOnItemSelectedListener(OnSwipeItemSelectedListener listener) {
        this.mAdapter.setOnItemSelectedListener(listener);
    }

    public void setItems(SwipeItem ... swipeItems) {
        this.mAdapter.setItems(swipeItems);
    }

    public SwipeItem getSelectedItem() {
        if (this.mAdapter.getCount() == 0) {
            throw new UnsupportedOperationException("The SwipeSelector doesn't have any items! Use the setItems() method for setting the items before calling getSelectedItem().");
        }
        return this.mAdapter.getSelectedItem();
    }
}

