/*
 * Decompiled with CFR 0.152.
 */
package com.roughike.swipeselector;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.ShapeDrawable;
import android.support.v4.view.PagerAdapter;
import android.support.v4.view.ViewPager;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.roughike.swipeselector.Indicator;
import com.roughike.swipeselector.OnSwipeItemSelectedListener;
import com.roughike.swipeselector.R;
import com.roughike.swipeselector.SwipeItem;
import java.util.ArrayList;
import java.util.Arrays;

class SwipeAdapter
extends PagerAdapter
implements View.OnClickListener,
ViewPager.OnPageChangeListener {
    private static final String TAG_VISIBLE = "TAG_VISIBLE";
    private static final String TAG_HIDDEN = "TAG_HIDDEN";
    private final Context mContext;
    private final LinearLayout.LayoutParams mCircleParams;
    private final ViewGroup mCircleContainer;
    private final ShapeDrawable mInActiveCircleDrawable;
    private final ShapeDrawable mActiveCircleDrawable;
    private final View mLeftButton;
    private final View mRightButton;
    private final ViewPager mViewPager;
    private ArrayList<SwipeItem> mItems;
    private int mCurrentPosition;
    private OnSwipeItemSelectedListener mOnItemSelectedListener;

    protected SwipeAdapter(ViewPager viewPager, ViewGroup circleContainer, int circleSize, int circleMargin, int inActiveCircleColor, int activeCircleColor, View leftButton, View rightButton) {
        this.mContext = viewPager.getContext();
        this.mViewPager = viewPager;
        this.mViewPager.addOnPageChangeListener((ViewPager.OnPageChangeListener)this);
        this.mCircleContainer = circleContainer;
        this.mCircleParams = new LinearLayout.LayoutParams(circleSize, circleSize);
        this.mCircleParams.leftMargin = circleMargin;
        this.mInActiveCircleDrawable = Indicator.newOne(circleSize, inActiveCircleColor);
        this.mActiveCircleDrawable = Indicator.newOne(circleSize, activeCircleColor);
        this.mLeftButton = leftButton;
        this.mRightButton = rightButton;
        this.mLeftButton.setOnClickListener((View.OnClickListener)this);
        this.mRightButton.setOnClickListener((View.OnClickListener)this);
        this.mLeftButton.setTag((Object)TAG_HIDDEN);
        this.mLeftButton.setClickable(false);
        this.mLeftButton.setAlpha(0.0f);
    }

    protected void setOnItemSelectedListener(OnSwipeItemSelectedListener listener) {
        this.mOnItemSelectedListener = listener;
    }

    protected void setItems(SwipeItem ... items) {
        if (SwipeItem.checkForStringResources) {
            ArrayList<SwipeItem> theRealOnes = new ArrayList<SwipeItem>();
            for (SwipeItem item : items) {
                if (item.titleRes != -1) {
                    item.title = this.mContext.getString(item.titleRes);
                }
                if (item.descriptionRes != -1) {
                    item.description = this.mContext.getString(item.descriptionRes);
                }
                theRealOnes.add(item);
            }
            this.mItems = theRealOnes;
            SwipeItem.checkForStringResources = false;
        } else {
            this.mItems = new ArrayList<SwipeItem>(Arrays.asList(items));
        }
        this.mCurrentPosition = 0;
        this.setActiveCircle(0);
        this.notifyDataSetChanged();
    }

    protected SwipeItem getSelectedItem() {
        return this.mItems.get(this.mCurrentPosition);
    }

    private void setActiveCircle(int position) {
        if (this.mCircleContainer.findViewWithTag((Object)TAG_VISIBLE) == null) {
            for (int i = 0; i < this.getCount(); ++i) {
                ImageView circle = (ImageView)View.inflate((Context)this.mContext, (int)R.layout.swipeselector_circle_item, null);
                if (i == position) {
                    circle.setImageDrawable((Drawable)this.mActiveCircleDrawable);
                } else {
                    circle.setImageDrawable((Drawable)this.mInActiveCircleDrawable);
                }
                circle.setLayoutParams((ViewGroup.LayoutParams)this.mCircleParams);
                circle.setTag((Object)TAG_VISIBLE);
                this.mCircleContainer.addView((View)circle);
            }
            return;
        }
        ImageView previousActiveCircle = (ImageView)this.mCircleContainer.getChildAt(this.mCurrentPosition);
        ImageView nextActiveCircle = (ImageView)this.mCircleContainer.getChildAt(position);
        previousActiveCircle.setImageDrawable((Drawable)this.mInActiveCircleDrawable);
        nextActiveCircle.setImageDrawable((Drawable)this.mActiveCircleDrawable);
        this.mCurrentPosition = position;
        if (this.mOnItemSelectedListener != null) {
            this.mOnItemSelectedListener.onItemSelected(this.getSelectedItem());
        }
    }

    public Object instantiateItem(ViewGroup container, int position) {
        ViewGroup layout2 = (ViewGroup)View.inflate((Context)this.mContext, (int)R.layout.swipeselector_content_item, null);
        TextView title = (TextView)layout2.findViewById(R.id.swipeselector_content_title);
        TextView description = (TextView)layout2.findViewById(R.id.swipeselector_content_description);
        SwipeItem slideItem = this.mItems.get(position);
        title.setText((CharSequence)slideItem.title);
        description.setText((CharSequence)slideItem.description);
        container.addView((View)layout2);
        return layout2;
    }

    public void destroyItem(ViewGroup container, int position, Object object) {
        container.removeView((View)object);
    }

    public int getCount() {
        return this.mItems != null ? this.mItems.size() : 0;
    }

    public boolean isViewFromObject(View view, Object object) {
        return view.equals(object);
    }

    public void onPageSelected(int position) {
        if (this.getCount() == 0) {
            return;
        }
        this.setActiveCircle(position);
        if (position < 1) {
            this.mLeftButton.setTag((Object)TAG_HIDDEN);
            this.mLeftButton.setClickable(false);
            this.mLeftButton.animate().alpha(0.0f).setDuration(120L).start();
        } else if (TAG_HIDDEN.equals(this.mLeftButton.getTag())) {
            this.mLeftButton.setTag(null);
            this.mLeftButton.setClickable(true);
            this.mLeftButton.animate().alpha(1.0f).setDuration(120L).start();
        }
        if (position == this.getCount() - 1) {
            this.mRightButton.setTag((Object)TAG_HIDDEN);
            this.mRightButton.setClickable(false);
            this.mRightButton.animate().alpha(0.0f).setDuration(120L).start();
        } else {
            this.mRightButton.setTag(null);
            this.mRightButton.setClickable(true);
            this.mRightButton.animate().alpha(1.0f).setDuration(120L).start();
        }
    }

    public void onClick(View v) {
        if (v.equals(this.mLeftButton) && this.mCurrentPosition >= 1) {
            this.mViewPager.setCurrentItem(this.mCurrentPosition - 1, true);
        } else if (v.equals(this.mRightButton) && this.mCurrentPosition <= this.getCount() - 1) {
            this.mViewPager.setCurrentItem(this.mCurrentPosition + 1, true);
        }
    }

    public void onPageScrolled(int position, float positionOffset, int positionOffsetPixels) {
    }

    public void onPageScrollStateChanged(int state) {
    }
}

