/*
 * Decompiled with CFR 0.152.
 */
package com.roughike.bottombar;

import android.content.Context;
import android.content.res.XmlResourceParser;
import android.graphics.Color;
import android.support.annotation.XmlRes;
import android.support.v4.content.ContextCompat;
import com.roughike.bottombar.BottomBarTab;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.xmlpull.v1.XmlPullParserException;

class TabParser {
    private final Context context;
    private final BottomBarTab.Config defaultTabConfig;
    private final XmlResourceParser parser;
    private ArrayList<BottomBarTab> tabs;
    private BottomBarTab workingTab;

    TabParser(Context context, BottomBarTab.Config defaultTabConfig, @XmlRes int tabsXmlResId) {
        this.context = context;
        this.defaultTabConfig = defaultTabConfig;
        this.parser = context.getResources().getXml(tabsXmlResId);
        this.tabs = new ArrayList();
        this.parse();
    }

    private void parse() {
        try {
            this.parser.next();
            int eventType = this.parser.getEventType();
            while (eventType != 1) {
                if (eventType == 2) {
                    this.parseNewTab(this.parser);
                } else if (eventType == 3 && this.parser.getName().equals("tab") && this.workingTab != null) {
                    this.tabs.add(this.workingTab);
                    this.workingTab = null;
                }
                eventType = this.parser.next();
            }
        }
        catch (IOException | XmlPullParserException e) {
            e.printStackTrace();
            throw new TabParserException();
        }
    }

    private void parseNewTab(XmlResourceParser parser) {
        if (this.workingTab == null) {
            this.workingTab = this.tabWithDefaults();
        }
        this.workingTab.setIndexInContainer(this.tabs.size());
        block18: for (int i = 0; i < parser.getAttributeCount(); ++i) {
            String attrName;
            switch (attrName = parser.getAttributeName(i)) {
                case "id": {
                    this.workingTab.setId(parser.getIdAttributeResourceValue(i));
                    continue block18;
                }
                case "icon": {
                    this.workingTab.setIconResId(parser.getAttributeResourceValue(i, 0));
                    continue block18;
                }
                case "title": {
                    this.workingTab.setTitle(this.getTitleValue(i, parser));
                    continue block18;
                }
                case "inActiveColor": {
                    Integer inActiveColor = this.getColorValue(i, parser);
                    if (inActiveColor == null) continue block18;
                    this.workingTab.setInActiveColor(inActiveColor);
                    continue block18;
                }
                case "activeColor": {
                    Integer activeColor = this.getColorValue(i, parser);
                    if (activeColor == null) continue block18;
                    this.workingTab.setActiveColor(activeColor);
                    continue block18;
                }
                case "barColorWhenSelected": {
                    Integer barColorWhenSelected = this.getColorValue(i, parser);
                    if (barColorWhenSelected == null) continue block18;
                    this.workingTab.setBarColorWhenSelected(barColorWhenSelected);
                    continue block18;
                }
                case "badgeBackgroundColor": {
                    Integer badgeBackgroundColor = this.getColorValue(i, parser);
                    if (badgeBackgroundColor == null) continue block18;
                    this.workingTab.setBadgeBackgroundColor(badgeBackgroundColor);
                }
            }
        }
    }

    private BottomBarTab tabWithDefaults() {
        BottomBarTab tab = new BottomBarTab(this.context);
        tab.setConfig(this.defaultTabConfig);
        return tab;
    }

    private String getTitleValue(int attrIndex, XmlResourceParser parser) {
        int titleResource = parser.getAttributeResourceValue(attrIndex, 0);
        if (titleResource != 0) {
            return this.context.getString(titleResource);
        }
        return parser.getAttributeValue(attrIndex);
    }

    private Integer getColorValue(int attrIndex, XmlResourceParser parser) {
        int colorResource = parser.getAttributeResourceValue(attrIndex, 0);
        if (colorResource != 0) {
            return ContextCompat.getColor((Context)this.context, (int)colorResource);
        }
        try {
            return Color.parseColor((String)parser.getAttributeValue(attrIndex));
        }
        catch (Exception ignored) {
            return null;
        }
    }

    List<BottomBarTab> getTabs() {
        return this.tabs;
    }

    private class TabParserException
    extends RuntimeException {
        private TabParserException() {
        }
    }
}

