/*
 * Decompiled with CFR 0.152.
 */
package com.roughike.bottombar;

import android.content.Context;
import android.content.res.Resources;
import android.os.Build;
import android.util.DisplayMetrics;
import android.view.Display;
import android.view.KeyCharacterMap;
import android.view.ViewConfiguration;
import android.view.WindowManager;
import com.roughike.bottombar.R;

final class NavbarUtils {
    NavbarUtils() {
    }

    static int getNavbarHeight(Context context) {
        Resources res = context.getResources();
        int navBarIdentifier = res.getIdentifier("navigation_bar_height", "dimen", "android");
        int navBarHeight = 0;
        if (navBarIdentifier > 0) {
            navBarHeight = res.getDimensionPixelSize(navBarIdentifier);
        }
        return navBarHeight;
    }

    static boolean shouldDrawBehindNavbar(Context context) {
        return NavbarUtils.isPortrait(context) && NavbarUtils.hasSoftKeys(context);
    }

    private static boolean isPortrait(Context context) {
        Resources res = context.getResources();
        return res.getBoolean(R.bool.bb_bottom_bar_is_portrait_mode);
    }

    private static boolean hasSoftKeys(Context context) {
        boolean hasSoftwareKeys = true;
        if (Build.VERSION.SDK_INT >= 17) {
            Display d = ((WindowManager)context.getSystemService("window")).getDefaultDisplay();
            DisplayMetrics realDisplayMetrics = new DisplayMetrics();
            d.getRealMetrics(realDisplayMetrics);
            int realHeight = realDisplayMetrics.heightPixels;
            int realWidth = realDisplayMetrics.widthPixels;
            DisplayMetrics displayMetrics = new DisplayMetrics();
            d.getMetrics(displayMetrics);
            int displayHeight = displayMetrics.heightPixels;
            int displayWidth = displayMetrics.widthPixels;
            hasSoftwareKeys = realWidth - displayWidth > 0 || realHeight - displayHeight > 0;
        } else if (Build.VERSION.SDK_INT >= 14) {
            boolean hasMenuKey = ViewConfiguration.get((Context)context).hasPermanentMenuKey();
            boolean hasBackKey = KeyCharacterMap.deviceHasKey((int)4);
            hasSoftwareKeys = !hasMenuKey && !hasBackKey;
        }
        return hasSoftwareKeys;
    }
}

