/*
 * Decompiled with CFR 0.152.
 */
package com.roughike.bottombar;

import android.content.Context;
import android.content.res.Resources;
import android.os.Build;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.widget.TextView;

class MiscUtils {
    MiscUtils() {
    }

    protected static int getColor(Context context, int color) {
        TypedValue tv = new TypedValue();
        context.getTheme().resolveAttribute(color, tv, true);
        return tv.data;
    }

    protected static int dpToPixel(Context context, float dp) {
        Resources resources = context.getResources();
        DisplayMetrics metrics = resources.getDisplayMetrics();
        try {
            return (int)(dp * ((float)metrics.densityDpi / 160.0f));
        }
        catch (NoSuchFieldError ignored) {
            return (int)TypedValue.applyDimension((int)1, (float)dp, (DisplayMetrics)metrics);
        }
    }

    protected static int getScreenWidth(Context context) {
        DisplayMetrics displayMetrics = context.getResources().getDisplayMetrics();
        return (int)((float)displayMetrics.widthPixels / displayMetrics.density);
    }

    protected static void setTextAppearance(TextView textView, int resId) {
        if (Build.VERSION.SDK_INT >= 23) {
            textView.setTextAppearance(resId);
        } else {
            textView.setTextAppearance(textView.getContext(), resId);
        }
    }

    protected static boolean isNightMode(Context context) {
        int currentNightMode = context.getResources().getConfiguration().uiMode & 0x30;
        return currentNightMode == 32;
    }
}

