/*
 * Decompiled with CFR 0.152.
 */
package com.roughike.bottombar;

import android.os.Build;
import android.support.annotation.NonNull;
import android.support.design.widget.CoordinatorLayout;
import android.support.design.widget.Snackbar;
import android.support.v4.view.ViewCompat;
import android.support.v4.view.ViewPropertyAnimatorCompat;
import android.support.v4.view.animation.LinearOutSlowInInterpolator;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.Interpolator;
import com.roughike.bottombar.VerticalScrollingBehavior;

class BottomNavigationBehavior<V extends View>
extends VerticalScrollingBehavior<V> {
    private static final Interpolator INTERPOLATOR = new LinearOutSlowInInterpolator();
    private final int bottomNavHeight;
    private final int defaultOffset;
    private boolean isTablet = false;
    private ViewPropertyAnimatorCompat mTranslationAnimator;
    private boolean hidden = false;
    private int mSnackbarHeight = -1;
    private final BottomNavigationWithSnackbar mWithSnackBarImpl = Build.VERSION.SDK_INT >= 21 ? new LollipopBottomNavWithSnackBarImpl() : new PreLollipopBottomNavWithSnackBarImpl();
    private boolean mScrollingEnabled = true;

    BottomNavigationBehavior(int bottomNavHeight, int defaultOffset, boolean tablet) {
        this.bottomNavHeight = bottomNavHeight;
        this.defaultOffset = defaultOffset;
        this.isTablet = tablet;
    }

    public boolean layoutDependsOn(CoordinatorLayout parent, V child, View dependency) {
        this.mWithSnackBarImpl.updateSnackbar(parent, dependency, (View)child);
        return dependency instanceof Snackbar.SnackbarLayout;
    }

    @Override
    public void onNestedVerticalOverScroll(CoordinatorLayout coordinatorLayout, V child, int direction, int currentOverScroll, int totalOverScroll) {
    }

    public void onDependentViewRemoved(CoordinatorLayout parent, V child, View dependency) {
        this.updateScrollingForSnackbar(dependency, true);
        super.onDependentViewRemoved(parent, child, dependency);
    }

    private void updateScrollingForSnackbar(View dependency, boolean enabled) {
        if (!this.isTablet && dependency instanceof Snackbar.SnackbarLayout) {
            this.mScrollingEnabled = enabled;
        }
    }

    public boolean onDependentViewChanged(CoordinatorLayout parent, V child, View dependency) {
        this.updateScrollingForSnackbar(dependency, false);
        return super.onDependentViewChanged(parent, child, dependency);
    }

    @Override
    public void onDirectionNestedPreScroll(CoordinatorLayout coordinatorLayout, V child, View target, int dx, int dy, int[] consumed, int scrollDirection) {
        this.handleDirection(child, scrollDirection);
    }

    private void handleDirection(V child, int scrollDirection) {
        if (!this.mScrollingEnabled) {
            return;
        }
        if (scrollDirection == -1 && this.hidden) {
            this.hidden = false;
            this.animateOffset(child, this.defaultOffset);
        } else if (scrollDirection == 1 && !this.hidden) {
            this.hidden = true;
            this.animateOffset(child, this.bottomNavHeight + this.defaultOffset);
        }
    }

    @Override
    protected boolean onNestedDirectionFling(CoordinatorLayout coordinatorLayout, V child, View target, float velocityX, float velocityY, int scrollDirection) {
        this.handleDirection(child, scrollDirection);
        return true;
    }

    private void animateOffset(V child, int offset) {
        this.ensureOrCancelAnimator(child);
        this.mTranslationAnimator.translationY((float)offset).start();
    }

    private void ensureOrCancelAnimator(V child) {
        if (this.mTranslationAnimator == null) {
            this.mTranslationAnimator = ViewCompat.animate(child);
            this.mTranslationAnimator.setDuration(300L);
            this.mTranslationAnimator.setInterpolator(INTERPOLATOR);
        } else {
            this.mTranslationAnimator.cancel();
        }
    }

    void setHidden(@NonNull V view, boolean bottomLayoutHidden) {
        if (!bottomLayoutHidden && this.hidden) {
            this.animateOffset(view, this.defaultOffset);
        } else if (bottomLayoutHidden && !this.hidden) {
            this.animateOffset(view, this.bottomNavHeight + this.defaultOffset);
        }
        this.hidden = bottomLayoutHidden;
    }

    static <V extends View> BottomNavigationBehavior<V> from(@NonNull V view) {
        ViewGroup.LayoutParams params = view.getLayoutParams();
        if (!(params instanceof CoordinatorLayout.LayoutParams)) {
            throw new IllegalArgumentException("The view is not a child of CoordinatorLayout");
        }
        CoordinatorLayout.Behavior behavior = ((CoordinatorLayout.LayoutParams)params).getBehavior();
        if (!(behavior instanceof BottomNavigationBehavior)) {
            throw new IllegalArgumentException("The view is not associated with BottomNavigationBehavior");
        }
        return (BottomNavigationBehavior)behavior;
    }

    private class LollipopBottomNavWithSnackBarImpl
    implements BottomNavigationWithSnackbar {
        private LollipopBottomNavWithSnackBarImpl() {
        }

        @Override
        public void updateSnackbar(CoordinatorLayout parent, View dependency, View child) {
            if (!BottomNavigationBehavior.this.isTablet && dependency instanceof Snackbar.SnackbarLayout) {
                if (BottomNavigationBehavior.this.mSnackbarHeight == -1) {
                    BottomNavigationBehavior.this.mSnackbarHeight = dependency.getHeight();
                }
                if (ViewCompat.getTranslationY((View)child) != 0.0f) {
                    return;
                }
                int targetPadding = BottomNavigationBehavior.this.mSnackbarHeight + BottomNavigationBehavior.this.bottomNavHeight - BottomNavigationBehavior.this.defaultOffset;
                dependency.setPadding(dependency.getPaddingLeft(), dependency.getPaddingTop(), dependency.getPaddingRight(), targetPadding);
            }
        }
    }

    private class PreLollipopBottomNavWithSnackBarImpl
    implements BottomNavigationWithSnackbar {
        private PreLollipopBottomNavWithSnackBarImpl() {
        }

        @Override
        public void updateSnackbar(CoordinatorLayout parent, View dependency, View child) {
            if (!BottomNavigationBehavior.this.isTablet && dependency instanceof Snackbar.SnackbarLayout) {
                if (BottomNavigationBehavior.this.mSnackbarHeight == -1) {
                    BottomNavigationBehavior.this.mSnackbarHeight = dependency.getHeight();
                }
                if (ViewCompat.getTranslationY((View)child) != 0.0f) {
                    return;
                }
                int targetPadding = BottomNavigationBehavior.this.bottomNavHeight + BottomNavigationBehavior.this.mSnackbarHeight - BottomNavigationBehavior.this.defaultOffset;
                ViewGroup.MarginLayoutParams layoutParams = (ViewGroup.MarginLayoutParams)dependency.getLayoutParams();
                layoutParams.bottomMargin = targetPadding;
                child.bringToFront();
                child.getParent().requestLayout();
                if (Build.VERSION.SDK_INT < 19) {
                    ((View)child.getParent()).invalidate();
                }
            }
        }
    }

    private static interface BottomNavigationWithSnackbar {
        public void updateSnackbar(CoordinatorLayout var1, View var2, View var3);
    }
}

