/*
 * Decompiled with CFR 0.152.
 */
package com.roughike.bottombar;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.ArgbEvaluator;
import android.animation.TypeEvaluator;
import android.animation.ValueAnimator;
import android.content.Context;
import android.graphics.Typeface;
import android.os.Build;
import android.os.Bundle;
import android.os.Parcelable;
import android.support.annotation.ColorInt;
import android.support.annotation.VisibleForTesting;
import android.support.v4.view.ViewCompat;
import android.support.v4.view.ViewPropertyAnimatorCompat;
import android.support.v7.widget.AppCompatImageView;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.roughike.bottombar.BottomBarBadge;
import com.roughike.bottombar.MiscUtils;
import com.roughike.bottombar.R;

public class BottomBarTab
extends LinearLayout {
    private static final long ANIMATION_DURATION = 150L;
    private static final float ACTIVE_TITLE_SCALE = 1.0f;
    private static final float INACTIVE_FIXED_TITLE_SCALE = 0.86f;
    private final int sixDps;
    private final int eightDps;
    private final int sixteenDps;
    private Type type = Type.FIXED;
    private int iconResId;
    private String title;
    private float inActiveAlpha;
    private float activeAlpha;
    private int inActiveColor;
    private int activeColor;
    private int barColorWhenSelected;
    private int badgeBackgroundColor;
    private AppCompatImageView iconView;
    private TextView titleView;
    private boolean isActive;
    private int indexInContainer;
    @VisibleForTesting
    BottomBarBadge badge;
    private int titleTextAppearanceResId;
    private Typeface titleTypeFace;

    BottomBarTab(Context context) {
        super(context);
        this.sixDps = MiscUtils.dpToPixel(context, 6.0f);
        this.eightDps = MiscUtils.dpToPixel(context, 8.0f);
        this.sixteenDps = MiscUtils.dpToPixel(context, 16.0f);
    }

    void setConfig(Config config) {
        this.setInActiveAlpha(config.inActiveTabAlpha);
        this.setActiveAlpha(config.activeTabAlpha);
        this.setInActiveColor(config.inActiveTabColor);
        this.setActiveColor(config.activeTabColor);
        this.setBarColorWhenSelected(config.barColorWhenSelected);
        this.setBadgeBackgroundColor(config.badgeBackgroundColor);
        this.setTitleTextAppearance(config.titleTextAppearance);
        this.setTitleTypeface(config.titleTypeFace);
    }

    void prepareLayout() {
        int layoutResource = this.getLayoutResource();
        BottomBarTab.inflate((Context)this.getContext(), (int)layoutResource, (ViewGroup)this);
        this.setOrientation(1);
        this.setGravity(1);
        this.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-2, -2));
        this.iconView = (AppCompatImageView)this.findViewById(R.id.bb_bottom_bar_icon);
        this.iconView.setImageResource(this.iconResId);
        if (this.type != Type.TABLET) {
            this.titleView = (TextView)this.findViewById(R.id.bb_bottom_bar_title);
            this.titleView.setText((CharSequence)this.title);
        }
        this.updateCustomTextAppearance();
        this.updateCustomTypeface();
    }

    @VisibleForTesting
    int getLayoutResource() {
        int layoutResource;
        switch (this.type) {
            case FIXED: {
                layoutResource = R.layout.bb_bottom_bar_item_fixed;
                break;
            }
            case SHIFTING: {
                layoutResource = R.layout.bb_bottom_bar_item_shifting;
                break;
            }
            case TABLET: {
                layoutResource = R.layout.bb_bottom_bar_item_fixed_tablet;
                break;
            }
            default: {
                throw new RuntimeException("Unknown BottomBarTab type.");
            }
        }
        return layoutResource;
    }

    private void updateCustomTextAppearance() {
        if (this.titleView == null || this.titleTextAppearanceResId == 0) {
            return;
        }
        if (Build.VERSION.SDK_INT >= 23) {
            this.titleView.setTextAppearance(this.titleTextAppearanceResId);
        } else {
            this.titleView.setTextAppearance(this.getContext(), this.titleTextAppearanceResId);
        }
        this.titleView.setTag((Object)this.titleTextAppearanceResId);
    }

    private void updateCustomTypeface() {
        if (this.titleTypeFace != null && this.titleView != null) {
            this.titleView.setTypeface(this.titleTypeFace);
        }
    }

    Type getType() {
        return this.type;
    }

    void setType(Type type) {
        this.type = type;
    }

    public ViewGroup getOuterView() {
        return (ViewGroup)this.getParent();
    }

    AppCompatImageView getIconView() {
        return this.iconView;
    }

    int getIconResId() {
        return this.iconResId;
    }

    void setIconResId(int iconResId) {
        this.iconResId = iconResId;
    }

    String getTitle() {
        return this.title;
    }

    TextView getTitleView() {
        return this.titleView;
    }

    void setTitle(String title) {
        this.title = title;
    }

    float getInActiveAlpha() {
        return this.inActiveAlpha;
    }

    void setInActiveAlpha(float inActiveAlpha) {
        this.inActiveAlpha = inActiveAlpha;
        if (!this.isActive) {
            this.setAlphas(inActiveAlpha);
        }
    }

    float getActiveAlpha() {
        return this.activeAlpha;
    }

    void setActiveAlpha(float activeAlpha) {
        this.activeAlpha = activeAlpha;
        if (this.isActive) {
            this.setAlphas(activeAlpha);
        }
    }

    int getInActiveColor() {
        return this.inActiveColor;
    }

    void setInActiveColor(int inActiveColor) {
        this.inActiveColor = inActiveColor;
        if (!this.isActive) {
            this.setColors(inActiveColor);
        }
    }

    int getActiveColor() {
        return this.activeColor;
    }

    void setActiveColor(int activeIconColor) {
        this.activeColor = activeIconColor;
        if (this.isActive) {
            this.setColors(this.activeColor);
        }
    }

    int getBarColorWhenSelected() {
        return this.barColorWhenSelected;
    }

    void setBarColorWhenSelected(int barColorWhenSelected) {
        this.barColorWhenSelected = barColorWhenSelected;
    }

    int getBadgeBackgroundColor() {
        return this.badgeBackgroundColor;
    }

    void setBadgeBackgroundColor(int badgeBackgroundColor) {
        this.badgeBackgroundColor = badgeBackgroundColor;
        if (this.badge != null) {
            this.badge.setColoredCircleBackground(badgeBackgroundColor);
        }
    }

    int getCurrentDisplayedIconColor() {
        Object tag = this.iconView.getTag();
        if (tag instanceof Integer) {
            return (Integer)this.iconView.getTag();
        }
        return 0;
    }

    int getCurrentDisplayedTitleColor() {
        if (this.titleView != null) {
            return this.titleView.getCurrentTextColor();
        }
        return 0;
    }

    int getCurrentDisplayedTextAppearance() {
        Object tag = this.titleView.getTag();
        if (this.titleView != null && tag instanceof Integer) {
            return (Integer)this.titleView.getTag();
        }
        return 0;
    }

    public void setBadgeCount(int count) {
        if (count <= 0) {
            if (this.badge != null) {
                this.badge.removeFromTab(this);
                this.badge = null;
            }
            return;
        }
        if (this.badge == null) {
            this.badge = new BottomBarBadge(this.getContext());
            this.badge.attachToTab(this, this.badgeBackgroundColor);
        }
        this.badge.setCount(count);
    }

    public void removeBadge() {
        this.setBadgeCount(0);
    }

    boolean isActive() {
        return this.isActive;
    }

    boolean hasActiveBadge() {
        return this.badge != null;
    }

    int getIndexInTabContainer() {
        return this.indexInContainer;
    }

    void setIndexInContainer(int indexInContainer) {
        this.indexInContainer = indexInContainer;
    }

    void setIconTint(int tint) {
        this.iconView.setColorFilter(tint);
    }

    void setTitleTextAppearance(int resId) {
        this.titleTextAppearanceResId = resId;
        this.updateCustomTextAppearance();
    }

    public int getTitleTextAppearance() {
        return this.titleTextAppearanceResId;
    }

    void setTitleTypeface(Typeface typeface) {
        this.titleTypeFace = typeface;
        this.updateCustomTypeface();
    }

    Typeface getTitleTypeFace() {
        return this.titleTypeFace;
    }

    void select(boolean animate) {
        this.isActive = true;
        if (animate) {
            this.setTopPaddingAnimated(this.iconView.getPaddingTop(), this.sixDps);
            this.animateIcon(this.activeAlpha);
            this.animateTitle(1.0f, this.activeAlpha);
            this.animateColors(this.inActiveColor, this.activeColor);
        } else {
            this.setTitleScale(1.0f);
            this.setTopPadding(this.sixDps);
            this.setColors(this.activeColor);
            this.setAlphas(this.activeAlpha);
        }
        if (this.badge != null) {
            this.badge.hide();
        }
    }

    void deselect(boolean animate) {
        int iconPaddingTop;
        this.isActive = false;
        boolean isShifting = this.type == Type.SHIFTING;
        float scale = isShifting ? 0.0f : 0.86f;
        int n = iconPaddingTop = isShifting ? this.sixteenDps : this.eightDps;
        if (animate) {
            this.setTopPaddingAnimated(this.iconView.getPaddingTop(), iconPaddingTop);
            this.animateTitle(scale, this.inActiveAlpha);
            this.animateIcon(this.inActiveAlpha);
            this.animateColors(this.activeColor, this.inActiveColor);
        } else {
            this.setTitleScale(scale);
            this.setTopPadding(iconPaddingTop);
            this.setColors(this.inActiveColor);
            this.setAlphas(this.inActiveAlpha);
        }
        if (!isShifting && this.badge != null) {
            this.badge.show();
        }
    }

    private void animateColors(int previousColor, int color2) {
        ValueAnimator anim = new ValueAnimator();
        anim.setIntValues(new int[]{previousColor, color2});
        anim.setEvaluator((TypeEvaluator)new ArgbEvaluator());
        anim.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator valueAnimator) {
                BottomBarTab.this.setColors((Integer)valueAnimator.getAnimatedValue());
            }
        });
        anim.setDuration(150L);
        anim.start();
    }

    private void setColors(int color2) {
        if (this.iconView != null) {
            this.iconView.setColorFilter(color2);
            this.iconView.setTag((Object)color2);
        }
        if (this.titleView != null) {
            this.titleView.setTextColor(color2);
        }
    }

    private void setAlphas(float alpha) {
        if (this.iconView != null) {
            ViewCompat.setAlpha((View)this.iconView, (float)alpha);
        }
        if (this.titleView != null) {
            ViewCompat.setAlpha((View)this.titleView, (float)alpha);
        }
    }

    void updateWidth(float endWidth, boolean animated) {
        if (!animated) {
            this.getLayoutParams().width = (int)endWidth;
            if (!this.isActive && this.badge != null) {
                this.badge.adjustPositionAndSize(this);
                this.badge.show();
            }
            return;
        }
        float start = this.getWidth();
        ValueAnimator animator = ValueAnimator.ofFloat((float[])new float[]{start, endWidth});
        animator.setDuration(150L);
        animator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animator) {
                ViewGroup.LayoutParams params = BottomBarTab.this.getLayoutParams();
                if (params == null) {
                    return;
                }
                params.width = Math.round(((Float)animator.getAnimatedValue()).floatValue());
                BottomBarTab.this.setLayoutParams(params);
            }
        });
        animator.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationEnd(Animator animation) {
                if (!BottomBarTab.this.isActive && BottomBarTab.this.badge != null) {
                    BottomBarTab.this.badge.adjustPositionAndSize(BottomBarTab.this);
                    BottomBarTab.this.badge.show();
                }
            }
        });
        animator.start();
    }

    private void updateBadgePosition() {
        if (this.badge != null) {
            this.badge.adjustPositionAndSize(this);
        }
    }

    private void setTopPaddingAnimated(int start, int end) {
        if (this.type == Type.TABLET) {
            return;
        }
        ValueAnimator paddingAnimator = ValueAnimator.ofInt((int[])new int[]{start, end});
        paddingAnimator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animation) {
                BottomBarTab.this.iconView.setPadding(BottomBarTab.this.iconView.getPaddingLeft(), ((Integer)animation.getAnimatedValue()).intValue(), BottomBarTab.this.iconView.getPaddingRight(), BottomBarTab.this.iconView.getPaddingBottom());
            }
        });
        paddingAnimator.setDuration(150L);
        paddingAnimator.start();
    }

    private void animateTitle(float finalScale, float finalAlpha) {
        if (this.type == Type.TABLET) {
            return;
        }
        ViewPropertyAnimatorCompat titleAnimator = ViewCompat.animate((View)this.titleView).setDuration(150L).scaleX(finalScale).scaleY(finalScale);
        titleAnimator.alpha(finalAlpha);
        titleAnimator.start();
    }

    private void animateIcon(float finalAlpha) {
        ViewCompat.animate((View)this.iconView).setDuration(150L).alpha(finalAlpha).start();
    }

    private void setTopPadding(int topPadding) {
        if (this.type == Type.TABLET) {
            return;
        }
        this.iconView.setPadding(this.iconView.getPaddingLeft(), topPadding, this.iconView.getPaddingRight(), this.iconView.getPaddingBottom());
    }

    private void setTitleScale(float scale) {
        if (this.type == Type.TABLET) {
            return;
        }
        ViewCompat.setScaleX((View)this.titleView, (float)scale);
        ViewCompat.setScaleY((View)this.titleView, (float)scale);
    }

    public Parcelable onSaveInstanceState() {
        if (this.badge != null) {
            Bundle bundle = this.badge.saveState(this.indexInContainer);
            bundle.putParcelable("superstate", super.onSaveInstanceState());
            return bundle;
        }
        return super.onSaveInstanceState();
    }

    public void onRestoreInstanceState(Parcelable state) {
        if (this.badge != null && state instanceof Bundle) {
            Bundle bundle = (Bundle)state;
            this.badge.restoreState(bundle, this.indexInContainer);
            state = bundle.getParcelable("superstate");
        }
        super.onRestoreInstanceState(state);
    }

    public static class Config {
        private final float inActiveTabAlpha;
        private final float activeTabAlpha;
        private final int inActiveTabColor;
        private final int activeTabColor;
        private final int barColorWhenSelected;
        private final int badgeBackgroundColor;
        private final int titleTextAppearance;
        private final Typeface titleTypeFace;

        private Config(Builder builder) {
            this.inActiveTabAlpha = builder.inActiveTabAlpha;
            this.activeTabAlpha = builder.activeTabAlpha;
            this.inActiveTabColor = builder.inActiveTabColor;
            this.activeTabColor = builder.activeTabColor;
            this.barColorWhenSelected = builder.barColorWhenSelected;
            this.badgeBackgroundColor = builder.badgeBackgroundColor;
            this.titleTextAppearance = builder.titleTextAppearance;
            this.titleTypeFace = builder.titleTypeFace;
        }

        public static class Builder {
            private float inActiveTabAlpha;
            private float activeTabAlpha;
            private int inActiveTabColor;
            private int activeTabColor;
            private int barColorWhenSelected;
            private int badgeBackgroundColor;
            private int titleTextAppearance;
            private Typeface titleTypeFace;

            public Builder inActiveTabAlpha(float alpha) {
                this.inActiveTabAlpha = alpha;
                return this;
            }

            public Builder activeTabAlpha(float alpha) {
                this.activeTabAlpha = alpha;
                return this;
            }

            public Builder inActiveTabColor(@ColorInt int color2) {
                this.inActiveTabColor = color2;
                return this;
            }

            public Builder activeTabColor(@ColorInt int color2) {
                this.activeTabColor = color2;
                return this;
            }

            public Builder barColorWhenSelected(@ColorInt int color2) {
                this.barColorWhenSelected = color2;
                return this;
            }

            public Builder badgeBackgroundColor(@ColorInt int color2) {
                this.badgeBackgroundColor = color2;
                return this;
            }

            public Builder titleTextAppearance(int titleTextAppearance) {
                this.titleTextAppearance = titleTextAppearance;
                return this;
            }

            public Builder titleTypeFace(Typeface titleTypeFace) {
                this.titleTypeFace = titleTypeFace;
                return this;
            }

            public Config build() {
                return new Config(this);
            }
        }
    }

    static enum Type {
        FIXED,
        SHIFTING,
        TABLET;

    }
}

