/*
 * Decompiled with CFR 0.152.
 */
package com.roughike.bottombar;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.ShapeDrawable;
import android.os.Build;
import android.os.Bundle;
import android.support.annotation.VisibleForTesting;
import android.support.v4.view.ViewCompat;
import android.support.v7.widget.AppCompatImageView;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import android.widget.FrameLayout;
import android.widget.TextView;
import com.roughike.bottombar.BadgeCircle;
import com.roughike.bottombar.BottomBarTab;
import com.roughike.bottombar.MiscUtils;
import com.roughike.bottombar.R;

class BottomBarBadge
extends TextView {
    @VisibleForTesting
    static final String STATE_COUNT = "STATE_BADGE_COUNT_FOR_TAB_";
    private int count;
    private boolean isVisible = false;

    BottomBarBadge(Context context) {
        super(context);
    }

    void setCount(int count) {
        this.count = count;
        this.setText(String.valueOf(count));
    }

    int getCount() {
        return this.count;
    }

    void show() {
        this.isVisible = true;
        ViewCompat.animate((View)this).setDuration(150L).alpha(1.0f).scaleX(1.0f).scaleY(1.0f).start();
    }

    void hide() {
        this.isVisible = false;
        ViewCompat.animate((View)this).setDuration(150L).alpha(0.0f).scaleX(0.0f).scaleY(0.0f).start();
    }

    boolean isVisible() {
        return this.isVisible;
    }

    void attachToTab(BottomBarTab tab, int backgroundColor) {
        ViewGroup.LayoutParams params = new ViewGroup.LayoutParams(-2, -2);
        this.setLayoutParams(params);
        this.setGravity(17);
        MiscUtils.setTextAppearance(this, R.style.BB_BottomBarBadge_Text);
        this.setColoredCircleBackground(backgroundColor);
        this.wrapTabAndBadgeInSameContainer(tab);
    }

    void setColoredCircleBackground(int circleColor) {
        int innerPadding = MiscUtils.dpToPixel(this.getContext(), 1.0f);
        ShapeDrawable backgroundCircle = BadgeCircle.make(innerPadding * 3, circleColor);
        this.setPadding(innerPadding, innerPadding, innerPadding, innerPadding);
        this.setBackgroundCompat((Drawable)backgroundCircle);
    }

    private void wrapTabAndBadgeInSameContainer(final BottomBarTab tab) {
        ViewGroup tabContainer = (ViewGroup)tab.getParent();
        tabContainer.removeView((View)tab);
        final FrameLayout badgeContainer = new FrameLayout(this.getContext());
        badgeContainer.setLayoutParams(new ViewGroup.LayoutParams(-2, -2));
        badgeContainer.addView((View)tab);
        badgeContainer.addView((View)this);
        tabContainer.addView((View)badgeContainer, tab.getIndexInTabContainer());
        badgeContainer.getViewTreeObserver().addOnGlobalLayoutListener(new ViewTreeObserver.OnGlobalLayoutListener(){

            public void onGlobalLayout() {
                badgeContainer.getViewTreeObserver().removeGlobalOnLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
                BottomBarBadge.this.adjustPositionAndSize(tab);
            }
        });
    }

    void removeFromTab(BottomBarTab tab) {
        FrameLayout badgeAndTabContainer = (FrameLayout)this.getParent();
        ViewGroup originalTabContainer = (ViewGroup)badgeAndTabContainer.getParent();
        badgeAndTabContainer.removeView((View)tab);
        originalTabContainer.removeView((View)badgeAndTabContainer);
        originalTabContainer.addView((View)tab, tab.getIndexInTabContainer());
    }

    void adjustPositionAndSize(BottomBarTab tab) {
        AppCompatImageView iconView = tab.getIconView();
        ViewGroup.LayoutParams params = this.getLayoutParams();
        int size = Math.max(this.getWidth(), this.getHeight());
        float xOffset = iconView.getWidth();
        if (tab.getType() == BottomBarTab.Type.TABLET) {
            xOffset = (float)((double)xOffset / 1.25);
        }
        this.setX(iconView.getX() + xOffset);
        this.setTranslationY(10.0f);
        if (params.width != size || params.height != size) {
            params.width = size;
            params.height = size;
            this.setLayoutParams(params);
        }
    }

    private void setBackgroundCompat(Drawable background) {
        if (Build.VERSION.SDK_INT >= 16) {
            this.setBackground(background);
        } else {
            this.setBackgroundDrawable(background);
        }
    }

    Bundle saveState(int tabIndex) {
        Bundle state = new Bundle();
        state.putInt(STATE_COUNT + tabIndex, this.count);
        return state;
    }

    void restoreState(Bundle bundle, int tabIndex) {
        this.setCount(bundle.getInt(STATE_COUNT + tabIndex, this.count));
    }
}

