/*
 * Decompiled with CFR 0.152.
 */
package com.roughike.bottombar;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.annotation.TargetApi;
import android.content.Context;
import android.content.res.AssetManager;
import android.content.res.TypedArray;
import android.graphics.Typeface;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.os.Bundle;
import android.os.Parcelable;
import android.support.annotation.ColorInt;
import android.support.annotation.IdRes;
import android.support.annotation.Nullable;
import android.support.annotation.VisibleForTesting;
import android.support.annotation.XmlRes;
import android.support.design.widget.CoordinatorLayout;
import android.support.v4.content.ContextCompat;
import android.support.v4.view.ViewCompat;
import android.support.v4.view.ViewPropertyAnimatorListener;
import android.support.v4.view.ViewPropertyAnimatorListenerAdapter;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewAnimationUtils;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.widget.FrameLayout;
import android.widget.LinearLayout;
import android.widget.TextView;
import android.widget.Toast;
import com.roughike.bottombar.BottomBarTab;
import com.roughike.bottombar.BottomNavigationBehavior;
import com.roughike.bottombar.MiscUtils;
import com.roughike.bottombar.NavbarUtils;
import com.roughike.bottombar.OnTabReselectListener;
import com.roughike.bottombar.OnTabSelectListener;
import com.roughike.bottombar.R;
import com.roughike.bottombar.TabParser;
import java.util.List;

public class BottomBar
extends LinearLayout
implements View.OnClickListener,
View.OnLongClickListener {
    private static final String STATE_CURRENT_SELECTED_TAB = "STATE_CURRENT_SELECTED_TAB";
    private static final float DEFAULT_INACTIVE_SHIFTING_TAB_ALPHA = 0.6f;
    private static final int BEHAVIOR_NONE = 0;
    private static final int BEHAVIOR_SHIFTING = 1;
    private static final int BEHAVIOR_SHY = 2;
    private static final int BEHAVIOR_DRAW_UNDER_NAV = 4;
    private int primaryColor;
    private int screenWidth;
    private int tenDp;
    private int maxFixedItemWidth;
    private int tabXmlResource;
    private boolean isTabletMode;
    private int behaviors;
    private float inActiveTabAlpha;
    private float activeTabAlpha;
    private int inActiveTabColor;
    private int activeTabColor;
    private int badgeBackgroundColor;
    private int titleTextAppearance;
    private Typeface titleTypeFace;
    private boolean showShadow;
    private View backgroundOverlay;
    private ViewGroup outerContainer;
    private ViewGroup tabContainer;
    private View shadowView;
    private int defaultBackgroundColor = -1;
    private int currentBackgroundColor;
    private int currentTabPosition;
    private int inActiveShiftingItemWidth;
    private int activeShiftingItemWidth;
    private OnTabSelectListener onTabSelectListener;
    private OnTabReselectListener onTabReselectListener;
    private boolean isComingFromRestoredState;
    private boolean ignoreTabReselectionListener;
    private boolean shyHeightAlreadyCalculated;
    private boolean navBarAccountedHeightCalculated;

    public BottomBar(Context context) {
        super(context);
        this.init(context, null);
    }

    public BottomBar(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(context, attrs);
        this.setItems(this.tabXmlResource);
    }

    private void init(Context context, AttributeSet attrs) {
        this.populateAttributes(context, attrs);
        this.initializeViews();
        this.determineInitialBackgroundColor();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void populateAttributes(Context context, AttributeSet attrs) {
        this.primaryColor = MiscUtils.getColor(this.getContext(), R.attr.colorPrimary);
        this.screenWidth = MiscUtils.getScreenWidth(this.getContext());
        this.tenDp = MiscUtils.dpToPixel(this.getContext(), 10.0f);
        this.maxFixedItemWidth = MiscUtils.dpToPixel(this.getContext(), 168.0f);
        TypedArray ta = context.getTheme().obtainStyledAttributes(attrs, R.styleable.BottomBar, 0, 0);
        try {
            this.tabXmlResource = ta.getResourceId(R.styleable.BottomBar_bb_tabXmlResource, 0);
            this.isTabletMode = ta.getBoolean(R.styleable.BottomBar_bb_tabletMode, false);
            this.behaviors = ta.getInteger(R.styleable.BottomBar_bb_behavior, 0);
            this.inActiveTabAlpha = ta.getFloat(R.styleable.BottomBar_bb_inActiveTabAlpha, this.isShiftingMode() ? 0.6f : 1.0f);
            this.activeTabAlpha = ta.getFloat(R.styleable.BottomBar_bb_activeTabAlpha, 1.0f);
            int defaultInActiveColor = this.isShiftingMode() ? -1 : ContextCompat.getColor((Context)context, (int)R.color.bb_inActiveBottomBarItemColor);
            int defaultActiveColor = this.isShiftingMode() ? -1 : this.primaryColor;
            this.inActiveTabColor = ta.getColor(R.styleable.BottomBar_bb_inActiveTabColor, defaultInActiveColor);
            this.activeTabColor = ta.getColor(R.styleable.BottomBar_bb_activeTabColor, defaultActiveColor);
            this.badgeBackgroundColor = ta.getColor(R.styleable.BottomBar_bb_badgeBackgroundColor, -65536);
            this.titleTextAppearance = ta.getResourceId(R.styleable.BottomBar_bb_titleTextAppearance, 0);
            this.titleTypeFace = this.getTypeFaceFromAsset(ta.getString(R.styleable.BottomBar_bb_titleTypeFace));
            this.showShadow = ta.getBoolean(R.styleable.BottomBar_bb_showShadow, true);
        }
        finally {
            ta.recycle();
        }
    }

    private boolean isShiftingMode() {
        return !this.isTabletMode && this.hasBehavior(1);
    }

    private boolean drawUnderNav() {
        return !this.isTabletMode && this.hasBehavior(4) && NavbarUtils.shouldDrawBehindNavbar(this.getContext());
    }

    private boolean isShy() {
        return !this.isTabletMode && this.hasBehavior(2);
    }

    private boolean hasBehavior(int behavior) {
        return (this.behaviors | behavior) == this.behaviors;
    }

    private Typeface getTypeFaceFromAsset(String fontPath) {
        if (fontPath != null) {
            return Typeface.createFromAsset((AssetManager)this.getContext().getAssets(), (String)fontPath);
        }
        return null;
    }

    private void initializeViews() {
        int width = this.isTabletMode ? -2 : -1;
        int height = this.isTabletMode ? -1 : -2;
        LinearLayout.LayoutParams params = new LinearLayout.LayoutParams(width, height);
        this.setLayoutParams((ViewGroup.LayoutParams)params);
        this.setOrientation(this.isTabletMode ? 0 : 1);
        ViewCompat.setElevation((View)this, (float)MiscUtils.dpToPixel(this.getContext(), 8.0f));
        View rootView = BottomBar.inflate((Context)this.getContext(), (int)(this.isTabletMode ? R.layout.bb_bottom_bar_item_container_tablet : R.layout.bb_bottom_bar_item_container), (ViewGroup)this);
        rootView.setLayoutParams((ViewGroup.LayoutParams)params);
        this.backgroundOverlay = rootView.findViewById(R.id.bb_bottom_bar_background_overlay);
        this.outerContainer = (ViewGroup)rootView.findViewById(R.id.bb_bottom_bar_outer_container);
        this.tabContainer = (ViewGroup)rootView.findViewById(R.id.bb_bottom_bar_item_container);
        this.shadowView = rootView.findViewById(R.id.bb_bottom_bar_shadow);
        if (!this.showShadow) {
            this.shadowView.setVisibility(8);
        }
    }

    private void determineInitialBackgroundColor() {
        Drawable userDefinedBackground;
        boolean userHasDefinedBackgroundColor;
        if (this.isShiftingMode()) {
            this.defaultBackgroundColor = this.primaryColor;
        }
        boolean bl = userHasDefinedBackgroundColor = (userDefinedBackground = this.getBackground()) != null && userDefinedBackground instanceof ColorDrawable;
        if (userHasDefinedBackgroundColor) {
            this.defaultBackgroundColor = ((ColorDrawable)userDefinedBackground).getColor();
            this.setBackgroundColor(0);
        }
    }

    public void setItems(@XmlRes int xmlRes) {
        this.setItems(xmlRes, null);
    }

    public void setItems(@XmlRes int xmlRes, BottomBarTab.Config defaultTabConfig) {
        if (xmlRes == 0) {
            throw new RuntimeException("No items specified for the BottomBar!");
        }
        if (defaultTabConfig == null) {
            defaultTabConfig = this.getTabConfig();
        }
        TabParser parser = new TabParser(this.getContext(), defaultTabConfig, xmlRes);
        this.updateItems(parser.getTabs());
    }

    private BottomBarTab.Config getTabConfig() {
        return new BottomBarTab.Config.Builder().inActiveTabAlpha(this.inActiveTabAlpha).activeTabAlpha(this.activeTabAlpha).inActiveTabColor(this.inActiveTabColor).activeTabColor(this.activeTabColor).barColorWhenSelected(this.defaultBackgroundColor).badgeBackgroundColor(this.badgeBackgroundColor).titleTextAppearance(this.titleTextAppearance).titleTypeFace(this.titleTypeFace).build();
    }

    private void updateItems(List<BottomBarTab> bottomBarItems) {
        int index = 0;
        int biggestWidth = 0;
        BottomBarTab[] viewsToAdd = new BottomBarTab[bottomBarItems.size()];
        for (BottomBarTab bottomBarTab : bottomBarItems) {
            BottomBarTab.Type type = this.isShiftingMode() ? BottomBarTab.Type.SHIFTING : (this.isTabletMode ? BottomBarTab.Type.TABLET : BottomBarTab.Type.FIXED);
            bottomBarTab.setType(type);
            bottomBarTab.prepareLayout();
            if (index == this.currentTabPosition) {
                bottomBarTab.select(false);
                this.handleBackgroundColorChange(bottomBarTab, false);
            } else {
                bottomBarTab.deselect(false);
            }
            if (!this.isTabletMode) {
                if (bottomBarTab.getWidth() > biggestWidth) {
                    biggestWidth = bottomBarTab.getWidth();
                }
                viewsToAdd[index] = bottomBarTab;
            } else {
                this.tabContainer.addView((View)bottomBarTab);
            }
            bottomBarTab.setOnClickListener(this);
            bottomBarTab.setOnLongClickListener(this);
            ++index;
        }
        if (!this.isTabletMode) {
            this.resizeTabsToCorrectSizes(bottomBarItems, viewsToAdd);
        }
    }

    private void resizeTabsToCorrectSizes(List<BottomBarTab> bottomBarItems, BottomBarTab[] viewsToAdd) {
        int proposedItemWidth = Math.min(MiscUtils.dpToPixel(this.getContext(), this.screenWidth / bottomBarItems.size()), this.maxFixedItemWidth);
        this.inActiveShiftingItemWidth = (int)((double)proposedItemWidth * 0.9);
        this.activeShiftingItemWidth = (int)((double)proposedItemWidth + (double)proposedItemWidth * ((double)bottomBarItems.size() * 0.1));
        int height = Math.round(this.getContext().getResources().getDimension(R.dimen.bb_height));
        for (BottomBarTab bottomBarView : viewsToAdd) {
            LinearLayout.LayoutParams params = this.isShiftingMode() ? (bottomBarView.isActive() ? new LinearLayout.LayoutParams(this.activeShiftingItemWidth, height) : new LinearLayout.LayoutParams(this.inActiveShiftingItemWidth, height)) : new LinearLayout.LayoutParams(proposedItemWidth, height);
            bottomBarView.setLayoutParams((ViewGroup.LayoutParams)params);
            this.tabContainer.addView((View)bottomBarView);
        }
    }

    public void setOnTabSelectListener(@Nullable OnTabSelectListener listener) {
        this.onTabSelectListener = listener;
        if (this.onTabSelectListener != null && this.getTabCount() > 0) {
            listener.onTabSelected(this.getCurrentTabId());
        }
    }

    public void setOnTabReselectListener(@Nullable OnTabReselectListener listener) {
        this.onTabReselectListener = listener;
    }

    public void setDefaultTab(@IdRes int defaultTabId) {
        int defaultTabPosition = this.findPositionForTabWithId(defaultTabId);
        this.setDefaultTabPosition(defaultTabPosition);
    }

    public void setDefaultTabPosition(int defaultTabPosition) {
        if (this.isComingFromRestoredState) {
            return;
        }
        this.selectTabAtPosition(defaultTabPosition);
    }

    public void selectTabWithId(@IdRes int tabResId) {
        int tabPosition = this.findPositionForTabWithId(tabResId);
        this.selectTabAtPosition(tabPosition);
    }

    public void selectTabAtPosition(int position) {
        if (position > this.getTabCount() - 1 || position < 0) {
            throw new IndexOutOfBoundsException("Can't select tab at position " + position + ". This BottomBar has no items at that position.");
        }
        this.selectTabAtPosition(position, false);
    }

    public int getTabCount() {
        return this.tabContainer.getChildCount();
    }

    public BottomBarTab getCurrentTab() {
        return this.getTabAtPosition(this.getCurrentTabPosition());
    }

    public BottomBarTab getTabAtPosition(int position) {
        View child = this.tabContainer.getChildAt(position);
        if (child instanceof FrameLayout) {
            return this.findTabInLayout((ViewGroup)((FrameLayout)child));
        }
        return (BottomBarTab)child;
    }

    @IdRes
    public int getCurrentTabId() {
        return this.getCurrentTab().getId();
    }

    public int getCurrentTabPosition() {
        return this.currentTabPosition;
    }

    public int findPositionForTabWithId(@IdRes int tabId) {
        return this.getTabWithId(tabId).getIndexInTabContainer();
    }

    public BottomBarTab getTabWithId(@IdRes int tabId) {
        return (BottomBarTab)this.tabContainer.findViewById(tabId);
    }

    public void setInActiveTabAlpha(float alpha) {
        this.inActiveTabAlpha = alpha;
        this.refreshTabs();
    }

    public void setActiveTabAlpha(float alpha) {
        this.activeTabAlpha = alpha;
        this.refreshTabs();
    }

    public void setInActiveTabColor(@ColorInt int color2) {
        this.inActiveTabColor = color2;
        this.refreshTabs();
    }

    public void setActiveTabColor(@ColorInt int color2) {
        this.activeTabColor = color2;
        this.refreshTabs();
    }

    public void setBadgeBackgroundColor(@ColorInt int color2) {
        this.badgeBackgroundColor = color2;
        this.refreshTabs();
    }

    public void setTabTitleTextAppearance(int textAppearance) {
        this.titleTextAppearance = textAppearance;
        this.refreshTabs();
    }

    public void setTabTitleTypeface(String fontPath) {
        Typeface actualTypeface = this.getTypeFaceFromAsset(fontPath);
        this.setTabTitleTypeface(actualTypeface);
    }

    public void setTabTitleTypeface(Typeface typeface) {
        this.titleTypeFace = typeface;
        this.refreshTabs();
    }

    private void refreshTabs() {
        int tabCount = this.getTabCount();
        if (tabCount > 0) {
            BottomBarTab.Config newConfig = this.getTabConfig();
            for (int i = 0; i < this.getTabCount(); ++i) {
                BottomBarTab tab = this.getTabAtPosition(i);
                tab.setConfig(newConfig);
            }
        }
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        super.onLayout(changed, left, top, right, bottom);
        if (changed) {
            this.updateTitleBottomPadding();
            if (this.isShy()) {
                this.initializeShyBehavior();
            }
            if (this.drawUnderNav()) {
                this.resizeForDrawingUnderNavbar();
            }
        }
    }

    private void updateTitleBottomPadding() {
        if (this.tabContainer == null) {
            return;
        }
        int childCount = this.getTabCount();
        for (int i = 0; i < childCount; ++i) {
            View tab = this.tabContainer.getChildAt(i);
            TextView title = (TextView)tab.findViewById(R.id.bb_bottom_bar_title);
            if (title == null) continue;
            int baseline = title.getBaseline();
            int height = title.getHeight();
            int paddingInsideTitle = height - baseline;
            int missingPadding = this.tenDp - paddingInsideTitle;
            if (missingPadding <= 0) continue;
            title.setPadding(title.getPaddingLeft(), title.getPaddingTop(), title.getPaddingRight(), missingPadding + title.getPaddingBottom());
        }
    }

    private void initializeShyBehavior() {
        int height;
        boolean hasAbusiveParent;
        ViewParent parent = this.getParent();
        boolean bl = hasAbusiveParent = parent != null && parent instanceof CoordinatorLayout;
        if (!hasAbusiveParent) {
            throw new RuntimeException("In order to have shy behavior, the BottomBar must be a direct child of a CoordinatorLayout.");
        }
        if (!this.shyHeightAlreadyCalculated && (height = this.getHeight()) != 0) {
            this.updateShyHeight(height);
            this.shyHeightAlreadyCalculated = true;
        }
    }

    private void updateShyHeight(int height) {
        ((CoordinatorLayout.LayoutParams)this.getLayoutParams()).setBehavior(new BottomNavigationBehavior(height, 0, false));
    }

    private void resizeForDrawingUnderNavbar() {
        int currentHeight;
        if (Build.VERSION.SDK_INT >= 19 && (currentHeight = this.getHeight()) != 0 && !this.navBarAccountedHeightCalculated) {
            int finalHeight;
            this.navBarAccountedHeightCalculated = true;
            this.tabContainer.getLayoutParams().height = currentHeight;
            int navbarHeight = NavbarUtils.getNavbarHeight(this.getContext());
            this.getLayoutParams().height = finalHeight = currentHeight + navbarHeight;
            if (this.isShy()) {
                this.updateShyHeight(finalHeight);
            }
        }
    }

    public Parcelable onSaveInstanceState() {
        Bundle bundle = this.saveState();
        bundle.putParcelable("superstate", super.onSaveInstanceState());
        return bundle;
    }

    @VisibleForTesting
    Bundle saveState() {
        Bundle outState = new Bundle();
        outState.putInt(STATE_CURRENT_SELECTED_TAB, this.currentTabPosition);
        return outState;
    }

    public void onRestoreInstanceState(Parcelable state) {
        if (state instanceof Bundle) {
            Bundle bundle = (Bundle)state;
            this.restoreState(bundle);
            state = bundle.getParcelable("superstate");
        }
        super.onRestoreInstanceState(state);
    }

    @VisibleForTesting
    void restoreState(Bundle savedInstanceState) {
        if (savedInstanceState != null) {
            this.isComingFromRestoredState = true;
            this.ignoreTabReselectionListener = true;
            int restoredPosition = savedInstanceState.getInt(STATE_CURRENT_SELECTED_TAB, this.currentTabPosition);
            this.selectTabAtPosition(restoredPosition, false);
        }
    }

    public void onClick(View v) {
        this.handleClick(v);
    }

    public boolean onLongClick(View v) {
        return this.handleLongClick(v);
    }

    private BottomBarTab findTabInLayout(ViewGroup child) {
        for (int i = 0; i < child.getChildCount(); ++i) {
            View candidate = child.getChildAt(i);
            if (!(candidate instanceof BottomBarTab)) continue;
            return (BottomBarTab)candidate;
        }
        return null;
    }

    private void handleClick(View v) {
        BottomBarTab oldTab = this.getCurrentTab();
        BottomBarTab newTab = (BottomBarTab)v;
        oldTab.deselect(true);
        newTab.select(true);
        this.shiftingMagic(oldTab, newTab, true);
        this.handleBackgroundColorChange(newTab, true);
        this.updateSelectedTab(newTab.getIndexInTabContainer());
    }

    private boolean handleLongClick(View v) {
        if (v instanceof BottomBarTab) {
            BottomBarTab longClickedTab = (BottomBarTab)v;
            if ((this.isShiftingMode() || this.isTabletMode) && !longClickedTab.isActive()) {
                Toast.makeText((Context)this.getContext(), (CharSequence)longClickedTab.getTitle(), (int)0).show();
            }
        }
        return true;
    }

    private void selectTabAtPosition(int position, boolean animate) {
        BottomBarTab oldTab = this.getCurrentTab();
        BottomBarTab newTab = this.getTabAtPosition(position);
        oldTab.deselect(animate);
        newTab.select(animate);
        this.updateSelectedTab(position);
        this.shiftingMagic(oldTab, newTab, animate);
        this.handleBackgroundColorChange(newTab, false);
    }

    private void updateSelectedTab(int newPosition) {
        int newTabId = this.getTabAtPosition(newPosition).getId();
        if (newPosition != this.currentTabPosition) {
            if (this.onTabSelectListener != null) {
                this.onTabSelectListener.onTabSelected(newTabId);
            }
        } else if (this.onTabReselectListener != null && !this.ignoreTabReselectionListener) {
            this.onTabReselectListener.onTabReSelected(newTabId);
        }
        this.currentTabPosition = newPosition;
        if (this.ignoreTabReselectionListener) {
            this.ignoreTabReselectionListener = false;
        }
    }

    private void shiftingMagic(BottomBarTab oldTab, BottomBarTab newTab, boolean animate) {
        if (this.isShiftingMode()) {
            oldTab.updateWidth(this.inActiveShiftingItemWidth, animate);
            newTab.updateWidth(this.activeShiftingItemWidth, animate);
        }
    }

    private void handleBackgroundColorChange(BottomBarTab tab, boolean animate) {
        int newColor = tab.getBarColorWhenSelected();
        if (this.currentBackgroundColor == newColor) {
            return;
        }
        if (!animate) {
            this.outerContainer.setBackgroundColor(newColor);
            return;
        }
        BottomBarTab clickedView = tab;
        if (tab.hasActiveBadge()) {
            clickedView = tab.getOuterView();
        }
        this.animateBGColorChange((View)clickedView, newColor);
        this.currentBackgroundColor = newColor;
    }

    private void animateBGColorChange(View clickedView, int newColor) {
        this.prepareForBackgroundColorAnimation(newColor);
        if (Build.VERSION.SDK_INT >= 21) {
            if (!this.outerContainer.isAttachedToWindow()) {
                return;
            }
            this.backgroundCircularRevealAnimation(clickedView, newColor);
        } else {
            this.backgroundCrossfadeAnimation(newColor);
        }
    }

    private void prepareForBackgroundColorAnimation(int newColor) {
        this.outerContainer.clearAnimation();
        this.backgroundOverlay.clearAnimation();
        this.backgroundOverlay.setBackgroundColor(newColor);
        this.backgroundOverlay.setVisibility(0);
    }

    @TargetApi(value=21)
    private void backgroundCircularRevealAnimation(View clickedView, final int newColor) {
        int centerX = (int)(ViewCompat.getX((View)clickedView) + (float)(clickedView.getMeasuredWidth() / 2));
        int yOffset = this.isTabletMode ? (int)ViewCompat.getY((View)clickedView) : 0;
        int centerY = yOffset + clickedView.getMeasuredHeight() / 2;
        boolean startRadius = false;
        int finalRadius = this.isTabletMode ? this.outerContainer.getHeight() : this.outerContainer.getWidth();
        Animator animator = ViewAnimationUtils.createCircularReveal((View)this.backgroundOverlay, (int)centerX, (int)centerY, (float)((float)startRadius), (float)finalRadius);
        if (this.isTabletMode) {
            animator.setDuration(500L);
        }
        animator.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationEnd(Animator animation) {
                this.onEnd();
            }

            public void onAnimationCancel(Animator animation) {
                this.onEnd();
            }

            private void onEnd() {
                BottomBar.this.outerContainer.setBackgroundColor(newColor);
                BottomBar.this.backgroundOverlay.setVisibility(4);
                ViewCompat.setAlpha((View)BottomBar.this.backgroundOverlay, (float)1.0f);
            }
        });
        animator.start();
    }

    private void backgroundCrossfadeAnimation(final int newColor) {
        ViewCompat.setAlpha((View)this.backgroundOverlay, (float)0.0f);
        ViewCompat.animate((View)this.backgroundOverlay).alpha(1.0f).setListener((ViewPropertyAnimatorListener)new ViewPropertyAnimatorListenerAdapter(){

            public void onAnimationEnd(View view) {
                this.onEnd();
            }

            public void onAnimationCancel(View view) {
                this.onEnd();
            }

            private void onEnd() {
                BottomBar.this.outerContainer.setBackgroundColor(newColor);
                BottomBar.this.backgroundOverlay.setVisibility(4);
                ViewCompat.setAlpha((View)BottomBar.this.backgroundOverlay, (float)1.0f);
            }
        }).start();
    }

    private void toggleShyVisibility(boolean visible) {
        BottomNavigationBehavior<BottomBar> from = BottomNavigationBehavior.from(this);
        if (from != null) {
            from.setHidden(this, visible);
        }
    }
}

