/*
 * Decompiled with CFR 0.152.
 */
package com.roughike.bottombar;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.ShapeDrawable;
import android.os.Build;
import android.support.v4.view.ViewCompat;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import android.widget.FrameLayout;
import android.widget.TextView;
import com.roughike.bottombar.BadgeCircle;
import com.roughike.bottombar.MiscUtils;
import com.roughike.bottombar.R;

public class BottomBarBadge
extends TextView {
    private int count;
    private boolean isVisible = false;
    private long animationDuration = 150L;
    private boolean autoShowAfterUnSelection = false;
    private boolean autoHideOnSelection = true;

    public void setCount(int count) {
        this.count = count;
        this.setText(String.valueOf(count));
    }

    public int getCount() {
        return this.count;
    }

    public void setAutoHideOnSelection(boolean autoHideOnSelection) {
        this.autoHideOnSelection = autoHideOnSelection;
    }

    public boolean getAutoHideOnSelection() {
        return this.autoHideOnSelection;
    }

    public void setAutoShowAfterUnSelection(boolean autoShowAfterUnSelection) {
        this.autoShowAfterUnSelection = autoShowAfterUnSelection;
    }

    public boolean getAutoShowAfterUnSelection() {
        return this.autoShowAfterUnSelection;
    }

    public void setAnimationDuration(long duration) {
        this.animationDuration = duration;
    }

    public void show() {
        this.isVisible = true;
        ViewCompat.animate((View)this).setDuration(this.animationDuration).scaleX(1.0f).scaleY(1.0f).start();
    }

    public void hide() {
        this.isVisible = false;
        ViewCompat.animate((View)this).setDuration(this.animationDuration).scaleX(0.0f).scaleY(0.0f).start();
    }

    public boolean isVisible() {
        return this.isVisible;
    }

    protected BottomBarBadge(Context context, int position, final View tabToAddTo, int backgroundColor) {
        super(context);
        ViewGroup.LayoutParams params = new ViewGroup.LayoutParams(-2, -2);
        this.setLayoutParams(params);
        this.setGravity(17);
        MiscUtils.setTextAppearance(this, R.style.BB_BottomBarBadge_Text);
        int three = MiscUtils.dpToPixel(context, 3.0f);
        ShapeDrawable backgroundCircle = BadgeCircle.make(three * 3, backgroundColor);
        this.setPadding(three, three, three, three);
        this.setBackgroundCompat((Drawable)backgroundCircle);
        FrameLayout container = new FrameLayout(context);
        container.setLayoutParams(params);
        ViewGroup parent = (ViewGroup)tabToAddTo.getParent();
        parent.removeView(tabToAddTo);
        container.setTag(tabToAddTo.getTag());
        tabToAddTo.setTag(null);
        container.addView(tabToAddTo);
        container.addView((View)this);
        parent.addView((View)container, position);
        container.getViewTreeObserver().addOnGlobalLayoutListener(new ViewTreeObserver.OnGlobalLayoutListener(){

            public void onGlobalLayout() {
                BottomBarBadge.this.adjustPositionAndSize(tabToAddTo);
            }
        });
    }

    protected void adjustPosition(View tabToAddTo) {
        this.setX((float)((double)tabToAddTo.getX() + (double)tabToAddTo.getWidth() / 1.75));
    }

    private void adjustPositionAndSize(View tabToAddTo) {
        int size;
        this.adjustPosition(tabToAddTo);
        this.setTranslationY(10.0f);
        this.getLayoutParams().width = size = Math.max(this.getWidth(), this.getHeight());
        this.getLayoutParams().height = size;
    }

    private void setBackgroundCompat(Drawable background) {
        if (Build.VERSION.SDK_INT >= 16) {
            this.setBackground(background);
        } else {
            this.setBackgroundDrawable(background);
        }
    }
}

